""" sky and weather settings
"""

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sys
import os
import os.path
import string
import math

import Blender
from Blender.Draw import *

from BaseWindowClass import BaseWindowClass

from brad_i18n import *
from brad_lib import *
from brad_sun import *
from brad_io import *

registered_data = Blender.Registry.GetKey('brad')
if registered_data:
  brad_path  = registered_data['brad_path']

class SkyWeatherwin(BaseWindowClass):

    def __init__(self, LocX, LocY, Width, Heigth, Title, okEvent, Deco, locationwindow, timewindow):

        BaseWindowClass.__init__(self,LocX,LocY,Width,Heigth)

        self.type="SkyWeatherwin"


        self.okE=okEvent
        self.decoration=Deco
        self.title=Title

        self.locationwindow = locationwindow
        self.timewindow = timewindow

        self.generateSky = Create(0)

        self.SkyR = Create(1.0)
        self.SkyG = Create(1.0)
        self.SkyB = Create(1.0)
        self.SR = Create(1.0)
        self.SG = Create(1.0)
        self.SB = Create(1.0)

        self.SkyRefl = 1.0

        self.GroundR = Create(1.0)
        self.GroundG = Create(1.0)
        self.GroundB = Create(1.0)
        self.GR = Create(1.0)
        self.GG = Create(1.0)
        self.GB = Create(1.0)

        self.GroundRefl = 1.0

        self.GroundAlbedo = Create(0.2)

        self.SkyGenerator = Create(0)
        self.UseSun = Create(1)

        # gensky parameters
        self.GenskyTurbidity = Create(2.75)
        self.GenskyManual = Create(0)
        self.GenskySolarRadiance = Create(40.0)
        self.GenskyZenithRadiance = Create(10.0)
        self.GenskyDirectHorizIrradiance = Create(400.0)
        self.GenskyDiffuseHorizIrradiance = Create(100.0)
        self.GenskyDirectHorizIlluminance = Create(50000.0)
        self.GenskyDiffuseHorizIlluminance = Create(10000.0)
        self.GenskyRadianceIrradiance = Create(0)

        #gendaylit parameters
        #to be written

        #sky mapping parameters
        self.UseSkyMapping = Create(0)
        self.SkyMap = Create (0)
        self.MappingType = Create(0)

        self.SkyType = Create(0)

        self.SkyStaticDynamic = Create(0)
        self.WeatherDataFile = Create(0)

        self.UseAlbedo = Create(1)

        self.TimeType = Create(0) #0=solar time | 1=local (clock) time

    #-------------------------------------------#
    #    DRAWING THE BUTTONS                    #
    #-------------------------------------------#

    def drawIt(self):

     if self.Visibility==1:
      if self.decoration == 0:
              self.drawBox()
      else:
              self.drawBoxS()

      # generate sky (yes/no toggle)
      rh = 45
      self.generateSky = Toggle(msg_generateSkyList[self.generateSky.val],0,self.LocX + 10, self.LocY-rh,(self.Width-20), 20,self.generateSky.val,"")

      if self.generateSky.val:
        # sky colour
        rhr = 65
        rhg = 80
        rhb = 95
        self.drawText(self.LocX + 10, self.LocY-rhg, 0, 0, 0, msg_SkyColour)
        self.drawRectangle(self.LocX + 10 + ((self.Width-20)/4-3),self.LocY-rhr+15,
                           self.LocX + 10 + 2*((self.Width-20)/4)-65,self.LocY-rhb,
                           self.SkyR.val,self.SkyG.val,self.SkyB.val,
                           1)
        self.SkyR = Slider(msg_R+": ", 40, self.LocX + 10 + 2*((self.Width-20)/4-3)-30, self.LocY-rhr, (self.Width-20)/3, 13, self.SkyR.val, 0.0, 1.0, 1, msg_R)
        self.SkyG = Slider(msg_G+": ", 40, self.LocX + 10 + 2*((self.Width-20)/4-3)-30, self.LocY-rhg, (self.Width-20)/3, 13, self.SkyG.val, 0.0, 1.0, 1, msg_G)
        self.SkyB = Slider(msg_B+": ", 40, self.LocX + 10 + 2*((self.Width-20)/4-3)-30, self.LocY-rhb, (self.Width-20)/3, 13, self.SkyB.val, 0.0, 1.0, 1, msg_B)
        self.drawText(self.LocX + 10 + 4*((self.Width-20)/4-10)-10, self.LocY-rhr, 0, 0, 0, str(self.SkyRefl)[:6])
        self.drawText(self.LocX + 10 + 4*((self.Width-20)/4-10)-70, self.LocY-rhr, 0, 0, 0, str(self.SR)[:5])
        self.drawText(self.LocX + 10 + 4*((self.Width-20)/4-10)-70, self.LocY-rhg, 0, 0, 0, str(self.SG)[:5])
        self.drawText(self.LocX + 10 + 4*((self.Width-20)/4-10)-70, self.LocY-rhb, 0, 0, 0, str(self.SB)[:5])
        Button(msg_Normalise,41,self.LocX + 10 +4*((self.Width-20)/4-10)-30,self.LocY-rhb,(self.Width-20)/5-20,20)

        # ground colour
        rhr = 115
        rhg = 130
        rhb = 145
        self.drawText(self.LocX + 10, self.LocY-rhg, 0, 0, 0, msg_GroundColour)
        self.drawRectangle(self.LocX + 10 + ((self.Width-20)/4-3),self.LocY-rhr+15,
                           self.LocX + 10 + 2*((self.Width-20)/4)-65,self.LocY-rhb,
                           self.GroundR.val,self.GroundG.val,self.GroundB.val,
                           1)
        self.GroundR = Slider(msg_R+": ", 40, self.LocX + 10 + 2*((self.Width-20)/4-3)-30, self.LocY-rhr, (self.Width-20)/3, 13, self.GroundR.val, 0.0, 1.0, 1, msg_R)
        self.GroundG = Slider(msg_G+": ", 40, self.LocX + 10 + 2*((self.Width-20)/4-3)-30, self.LocY-rhg, (self.Width-20)/3, 13, self.GroundG.val, 0.0, 1.0, 1, msg_G)
        self.GroundB = Slider(msg_B+": ", 40, self.LocX + 10 + 2*((self.Width-20)/4-3)-30, self.LocY-rhb, (self.Width-20)/3, 13, self.GroundB.val, 0.0, 1.0, 1, msg_B)
        self.drawText(self.LocX + 10 + 4*((self.Width-20)/4-10)-10, self.LocY-rhr, 0, 0, 0, str(self.GroundRefl)[:6])
        self.drawText(self.LocX + 10 + 4*((self.Width-20)/4-10)-70, self.LocY-rhr, 0, 0, 0, str(self.GR)[:5])
        self.drawText(self.LocX + 10 + 4*((self.Width-20)/4-10)-70, self.LocY-rhg, 0, 0, 0, str(self.GG)[:5])
        self.drawText(self.LocX + 10 + 4*((self.Width-20)/4-10)-70, self.LocY-rhb, 0, 0, 0, str(self.GB)[:5])
        Button(msg_Normalise,42,self.LocX + 10 +4*((self.Width-20)/4-10)-30,self.LocY-rhb,(self.Width-20)/5-20,20)

        #sky mapping
        rh = 175
        self.UseSkyMapping = Toggle(msg_UseSkyMapping+": "+msg_YesNo[self.UseSkyMapping.val],0,self.LocX + 10, self.LocY-rh,(self.Width-20)/3-6, 20,self.UseSkyMapping.val,msg_UseSkyMapping)
        if self.UseSkyMapping.val==1:
           skymapslist = loadSkyMaps(os.path.join(brad_path, "brad", "radiance", "sky"))
           skymapslist.sort()
           skymap_list_string = self.formatSkyMaps(skymapslist)
           self.SkyMap = Menu(msg_SkyMap+" %t|"+skymap_list_string, 0, self.LocX + 10 + (self.Width-20)/3, self.LocY-rh, (self.Width-20)/3-6, 20, self.SkyMap.val, msg_SkyMap)
           self.MappingType = Menu(msg_MappingType+" %t|"+msg_MappingTypeCylindrical+" %x0|"+msg_MappingTypeAngular+" %x1|", 0, self.LocX + 10 + 2*(self.Width-20)/3, self.LocY-rh, (self.Width-20)/3-6, 20, self.MappingType.val, msg_MappingType)

        #ground albedo and solar/local time
        rh = 205
        self.GroundAlbedo = Number(msg_GroundAlbedo+": ",0,self.LocX+10,self.LocY-rh,(self.Width-20)/2-6,20,self.GroundAlbedo.val,0.0, 1.0,msg_GroundAlbedo)
        self.TimeType = Toggle(msg_TimeType[self.TimeType.val],0,self.LocX + 10 + self.Width/2-6, self.LocY-rh,(self.Width-20)/2-6, 20,self.TimeType.val,msg_TimeType[self.TimeType.val])

        #static/dynamic sky and sky generator type
        """
        rh = 235
        self.SkyStaticDynamic = Toggle(msg_SkyStaticDynamic[self.SkyStaticDynamic.val],0,self.LocX + 10, self.LocY-rh,(self.Width-20)/2-6, 20,self.SkyStaticDynamic.val,msg_SkyStaticDynamicHint[self.SkyStaticDynamic.val])
        self.SkyGenerator = Toggle(msg_SkyGenerator[self.SkyGenerator.val],0,self.LocX + 10 + self.Width/2-6, self.LocY-rh,(self.Width-20)/2-6, 20,self.SkyGenerator.val,msg_SkyGenerator[self.SkyGenerator.val])
        """

        rh = 260
        if self.SkyStaticDynamic.val==1:
           weatherfilelist = loadWeatherFiles(os.path.join(brad_path, "brad", "radiance", "weather"))
           weatherfilelist.sort()
           weatherfile_list_string = self.formatWeatherFiles(weatherfilelist)
           self.WeatherDataFile = Menu(msg_WeatherDataFile+" %t|"+weatherfile_list_string, 0, self.LocX + 10, self.LocY-rh, (self.Width-20)/2-6, 20, self.WeatherDataFile.val, msg_WeatherDataFile)
        elif self.SkyStaticDynamic.val==0:
           if self.SkyGenerator.val == 0:
              #gensky options
              self.SkyType = Menu(msg_SkyType+" %t|"+msg_SkyTypeList[0]+" %x0|"+msg_SkyTypeList[1]+" %x1|"+msg_SkyTypeList[2]+" %x2|"+msg_SkyTypeList[3]+" %x3|", 0, self.LocX + 10 + (self.Width-20)/2 + 3, self.LocY-rh, (self.Width-20)/4-6, 15, self.SkyType.val, msg_SkyType)
              if self.SkyType.val > 1:
                 self.UseSun.val = 0
              self.UseSun = Toggle(msg_UseSun + ": "+ msg_YesNo[self.UseSun.val],0,self.LocX + 10 + 3*((self.Width-20)/4)+ 3, self.LocY-rh,(self.Width-20)/4-6, 15,self.UseSun.val,msg_UseSun + ": "+ msg_YesNo[self.UseSun.val])
              rh = 280
              #automatic/manual
              self.GenskyManual = Toggle(msg_GenskyManual[self.GenskyManual.val],0,self.LocX + 10 + self.Width/2-6, self.LocY-rh,(self.Width-20)/2-6, 15,self.GenskyManual.val,msg_GenskyManual[self.GenskyManual.val])
              rh = 300
              if self.GenskyManual.val == 1:
                 self.GenskyRadianceIrradiance = Menu(msg_GenskyInputData+" %t|"+msg_GenskyRadianceIrradiance[0]+" %x0|"+msg_GenskyRadianceIrradiance[1]+" %x1|"+msg_GenskyRadianceIrradiance[2]+" %x2|",0,self.LocX+10+(self.Width-20)/2 + 3, self.LocY-rh,(self.Width-20)/4-6, 15,self.GenskyRadianceIrradiance.val,msg_GenskyInputData)
              self.GenskyTurbidity = Number(msg_GenskyTurbidity+": ",0,self.LocX + 10 + 3*((self.Width-20)/4)+ 3,self.LocY-rh,(self.Width-20)/4-6,15,self.GenskyTurbidity.val,1.0, 100.0,msg_GenskyTurbidity)
              rh = 320
              if self.GenskyManual.val == 1:
               if self.GenskyRadianceIrradiance.val == 0:
                 #radiance
                 self.GenskySolarRadiance  = Number(msg_SolarRadiance+": ",0,self.LocX+10+(self.Width-20)/2 + 3, self.LocY-rh,(self.Width-20)/4-6, 15,self.GenskySolarRadiance.val,0.0, 65536.0,msg_SolarRadianceHint)
                 self.GenskyZenithRadiance = Number(msg_ZenithRadiance+": ",0,self.LocX + 10 + 3*((self.Width-20)/4)+ 3,self.LocY-rh,(self.Width-20)/4-6,15,self.GenskyZenithRadiance.val,0.0, 65536.0,msg_ZenithRadianceHint)
               elif self.GenskyRadianceIrradiance.val == 1:
                 #irradiance
                 self.GenskyDirectHorizIrradiance  = Number(msg_DirectHorizIrradiance+": ",0,self.LocX+10+(self.Width-20)/2 + 3, self.LocY-rh,(self.Width-20)/4-6, 15,self.GenskyDirectHorizIrradiance.val,0.0, 65536.0,msg_DirectHorizIrradianceHint)
                 self.GenskyDiffuseHorizIrradiance = Number(msg_DiffuseHorizIrradiance+": ",0,self.LocX + 10 + 3*((self.Width-20)/4)+ 3,self.LocY-rh,(self.Width-20)/4-6,15,self.GenskyDiffuseHorizIrradiance.val,0.0, 65536.0,msg_DiffuseHorizIrradianceHint)
               elif self.GenskyRadianceIrradiance.val == 2:
                 #illuminance
                 self.GenskyDirectHorizIlluminance  = Number(msg_DirectHorizIlluminance+": ",0,self.LocX+10+(self.Width-20)/2 + 3, self.LocY-rh,(self.Width-20)/4-6, 15,self.GenskyDirectHorizIlluminance.val,0.0, 65536.0,msg_DirectHorizIlluminanceHint)
                 self.GenskyDiffuseHorizIlluminance = Number(msg_DiffuseHorizIlluminance+": ",0,self.LocX + 10 + 3*((self.Width-20)/4)+ 3,self.LocY-rh,(self.Width-20)/4-6,15,self.GenskyDiffuseHorizIlluminance.val,0.0, 65536.0,msg_DiffuseHorizIlluminanceHint)

           elif self.SkyGenerator.val == 1:
              #gendaylit options
              pass


      if self.generateSky.val:
        #test sky button
        Button(msg_TestSky,43,self.LocX+10+2*(self.Width/3-6),self.LocY-self.Height+10,self.Width/3-6,20)

      #ok button
      Button(msg_Ok,self.okE,self.LocX+10,self.LocY-self.Height+10,self.Width/3-6,20)

      if self.generateSky.val:
        #info
        self.drawText(self.LocX + 10 + (self.Width/3-6) + 10, self.LocY-self.Height+25, 0, 0, 0,
        "|"+ str(self.locationwindow.LocationLat.val)[:7] +
        "|"+ str(self.locationwindow.LocationLon.val)[:7] +
        "|"+ str(self.locationwindow.LocationMer.val)[:7] +"|")
        self.drawText(self.LocX + 10 + (self.Width/3-6) + 10, self.LocY-self.Height+10, 0, 0, 0,
        "|"+ str(self.timewindow.YearStart.val)[:4] +
        "-"+ zfill(str(self.timewindow.MonthStart.val)[:2],2) +
        "-"+ zfill(str(self.timewindow.DayStart.val)[:2],2) +"|"+
        ""+ zfill(str(self.timewindow.HourStart.val)[:2],2) +
        ":"+ zfill(str(self.timewindow.MinuteStart.val)[:2],2)+"|")

      self.drawTitle(self.title)
      if self.isSelected == 1:
          self.drawBoxHF()


    def updateColours(self):
      # event 40
      # As of 9-94, CIE_rf=.265074126, CIE_gf=.670114631 and CIE_bf=.064811243
      CIE_rf=.265074126
      CIE_gf=.670114631
      CIE_bf=.064811243
      self.SkyRefl = (CIE_rf*self.SkyR.val) + (CIE_gf*self.SkyG.val) + (CIE_bf*self.SkyB.val)
      self.GroundRefl = (CIE_rf*self.GroundR.val) + (CIE_gf*self.GroundG.val) + (CIE_bf*self.GroundB.val)
      self.SR = self.SkyR
      self.SG = self.SkyG
      self.SB = self.SkyB
      self.GR = self.GroundR
      self.GG = self.GroundG
      self.GB = self.GroundB

    def normaliseSkyColour(self):
      # event 41
      # As of 9-94, CIE_rf=.265074126, CIE_gf=.670114631 and CIE_bf=.064811243
      CIE_rf=.265074126
      CIE_gf=.670114631
      CIE_bf=.064811243
      refl = (CIE_rf*self.SR.val) + (CIE_gf*self.SG.val) + (CIE_bf*self.SB.val)
      while refl!=1.0:
         if refl<1.0:
            delta_r = (1.0 - refl)*self.SR.val
            delta_g = (1.0 - refl)*self.SG.val
            delta_b = (1.0 - refl)*self.SB.val
            self.SR.val += delta_r
            self.SG.val += delta_g
            self.SB.val += delta_b
         if refl>1.0:
            delta_r = (refl - 1.0)*self.SR.val
            delta_g = (refl - 1.0)*self.SG.val
            delta_b = (refl - 1.0)*self.SB.val
            self.SR.val -= delta_r
            self.SG.val -= delta_g
            self.SB.val -= delta_b
         refl = (CIE_rf*self.SR.val) + (CIE_gf*self.SG.val) + (CIE_bf*self.SB.val)
         if (refl<1.000001 and refl>0.999999) or refl==0.0:
            refl = 1.0
      self.SkyRefl = refl

    def normaliseGroundColour(self):
      # event 42
      # As of 9-94, CIE_rf=.265074126, CIE_gf=.670114631 and CIE_bf=.064811243
      CIE_rf=.265074126
      CIE_gf=.670114631
      CIE_bf=.064811243
      refl = (CIE_rf*self.GR.val) + (CIE_gf*self.GG.val) + (CIE_bf*self.GB.val)
      while refl!=1.0:
         if refl<1.0:
            delta_r = (1.0 - refl)*self.GR.val
            delta_g = (1.0 - refl)*self.GG.val
            delta_b = (1.0 - refl)*self.GB.val
            self.GR.val += delta_r
            self.GG.val += delta_g
            self.GB.val += delta_b
         if refl>1.0:
            delta_r = (refl - 1.0)*self.GR.val
            delta_g = (refl - 1.0)*self.GG.val
            delta_b = (refl - 1.0)*self.GB.val
            self.GR.val -= delta_r
            self.GG.val -= delta_g
            self.GB.val -= delta_b
         refl = (CIE_rf*self.GR.val) + (CIE_gf*self.GG.val) + (CIE_bf*self.GB.val)
         if (refl<1.000001 and refl>0.999999) or refl==0.0:
            refl = 1.0
      self.GroundRefl = refl

    def exportSky(self, skyfilename, frame):
      #event 43
      skycolour = str(self.SkyR.val) + " " + str(self.SkyG.val) + " " + str(self.SkyB.val)
      groundcolour = str(self.GroundR.val) + " " + str(self.GroundG.val) + " " + str(self.GroundB.val)
      skytypes = ["s", "i", "c", "u"]
      sky = skytypes[self.SkyType.val]
      yesno = ["-", "+"]
      sunyn = yesno[self.UseSun.val]
      solarclock = ["solar","clock"]
      self.timewindow.updateDateTime(frame)
      sun = SunTime( self.locationwindow.LocationLat.val,
                     -self.locationwindow.LocationLon.val,
                     -self.locationwindow.LocationMer.val,
                     self.timewindow.getMonth(),
                     self.timewindow.getDay(),
                     self.timewindow.getHour(),
                     self.timewindow.getMinute(),
                     solarclock[self.TimeType.val])
      """
      if self.TimeType.val==1:
         sun=SunClockTime( self.locationwindow.LocationLat.val,
                     self.locationwindow.LocationLon.val,
                     self.locationwindow.LocationMer.val,
                     self.timewindow.MonthStart.val,
                     self.timewindow.DayStart.val,
                     self.timewindow.HourStart.val,
                     self.timewindow.MinuteStart.val)
      elif self.TimeType.val==0:
         sun=SunSolarTime( self.locationwindow.LocationLat.val,
                     self.locationwindow.LocationLon.val,
                     self.locationwindow.LocationMer.val,
                     self.timewindow.MonthStart.val,
                     self.timewindow.DayStart.val,
                     self.timewindow.HourStart.val,
                     self.timewindow.MinuteStart.val)
      """
      sazi=sun.getSolarAzimuthDEG()
      salt=sun.getSolarAltitudeDEG()
      #print self.locationwindow.LocationLat.val, self.locationwindow.LocationLon.val, self.locationwindow.LocationMer.val, self.timewindow.MonthStart.val, self.timewindow.DayStart.val, self.timewindow.HourStart.val, self.timewindow.MinuteStart.val, salt, sazi

      #TODO: add sky generator choice
      skyfile = open(skyfilename, "w+")
      if self.GenskyManual.val == 1:
          #manual gensky input
          if self.GenskyRadianceIrradiance.val == 0:
             #radiance
             direct = "-r " + str(self.GenskySolarRadiance.val)
             diffuse = "-b " + str(self.GenskyZenithRadiance.val)
          elif self.GenskyRadianceIrradiance.val == 1:
             #irradiance
             direct = "-R " + str(self.GenskyDirectHorizIrradiance.val)
             diffuse = "-B " + str(self.GenskyDiffuseHorizIrradiance.val)
          elif self.GenskyRadianceIrradiance.val == 2:
             #illuminance
             direct = "-R " + str(self.GenskyDirectHorizIlluminance.val/179.0)
             diffuse = "-B " + str(self.GenskyDiffuseHorizIlluminance.val/179.0)
          skyfile.write("!gensky -ang "+ str(salt) +" "+ str(sazi) +" " + sunyn + sky + " " + direct + " " + diffuse + " -t " + str(self.GenskyTurbidity.val) + " -g "+ str(self.GroundAlbedo.val) +" | xform -rz " + str(-self.locationwindow.LocationNorth.val) + "\n")
      elif self.GenskyManual.val == 0:
          #automatic gensky generation
          local=""
          if self.TimeType.val==0:
             local="+"
          skyfile.write("!gensky "+
                          str(self.timewindow.getMonth()) +" "+
                          str(self.timewindow.getDay()) +" " +
                          local+
                          str(self.timewindow.getHour()) +":" +
                          zfill(str(self.timewindow.getMinute()), 2) +" " +
                          sunyn + sky +
                          " -a " + str(self.locationwindow.LocationLat.val) +
                          " -o " + str(self.locationwindow.LocationLon.val) +
                          " -m " + str(self.locationwindow.LocationMer.val)+
                          " -t " + str(self.GenskyTurbidity.val) +
                          " -g "+ str(self.GroundAlbedo.val) +
                          " | xform -rz " + str(-self.locationwindow.LocationNorth.val) + "\n\n")
      if self.UseSkyMapping.val == 1:
        skymapslist = loadSkyMaps(os.path.join(brad_path, "brad", "radiance", "sky"))
        skymapslist.sort()
        if self.MappingType.val == 0:
          skyfile.write("skyfunc colorpict skymap\n")
          skyfile.write("7 red green blue " + skymapslist[self.SkyMap.val] + " " + "skymap.cal" + " map_u map_v\n")
          skyfile.write("0 \n")
          skyfile.write("1 .5 \n\n")
          skyfile.write("skymap glow skyglow\n")
        elif self.MappingType.val == 1:
          skyfile.write("skyfunc colorpict skymap" + " \n")
          skyfile.write("11 red green blue " + skymapslist[self.SkyMap.val] + " fisheye.cal fish_u fish_v -rz 180 -rx -90" + " \n")
          skyfile.write("0" + " \n")
          skyfile.write("4 0 0 1 180" + " \n\n")
          skyfile.write("skymap glow skyglow\n")
      else:
         skyfile.write("skyfunc glow skyglow\n")
      skyfile.write("0\n")
      skyfile.write("0\n")
      skyfile.write("4 " + skycolour + " 0\n\n")
      skyfile.write("skyglow source sky\n")
      skyfile.write("0\n")
      skyfile.write("0\n")
      skyfile.write("4 0 0 1 180\n\n")
      if self.UseAlbedo.val == 1:
        if self.UseSkyMapping.val == 1:
           if self.MappingType.val == 0:
              skyfile.write("skymap glow groundglow\n")
           elif self.MappingType.val == 1:
              skymapslist = loadSkyMaps(os.path.join(brad_path, "brad", "radiance", "sky"))
              skymapslist.sort()
              skyfile.write("skyfunc colorpict groundmap" + " \n")
              skyfile.write("9 red green blue " + os.path.join(brad_path, "brad", "radiance", "sky", skymapslist[self.SkyMap.val]) + " fisheye.cal fish_u fish_v -rx -90" + " \n")
              skyfile.write("0" + " \n")
              skyfile.write("4 0 0 1 180" + " \n\n")
              skyfile.write("groundmap glow groundglow\n")
        else:
           skyfile.write("skyfunc glow groundglow\n")
        skyfile.write("0\n")
        skyfile.write("0\n")
        skyfile.write("4 " + groundcolour + " 0\n\n")
        skyfile.write("groundglow source ground\n")
        skyfile.write("0\n")
        skyfile.write("0\n")
        skyfile.write("4 0 0 -1 180\n\n")
      skyfile.close()

    def testSky(self):
      skyfilename = os.path.join(brad_path, "brad", "tmp", "tmp.sky")
      self.exportSky(skyfilename, 1)
      try:
         octreefilename = os.path.join(brad_path, "brad", "tmp", "tmp.oct")
         picturefilename = os.path.join(brad_path, "brad", "tmp", "tmp.pic")
         oconvcommand = "oconv " + skyfilename + " > " + octreefilename
         os.system(oconvcommand)
         rpictcommand = "rpict -vta -vp 0 0 0 -vd 0 0 1 -vu 0 1 0 -vv 180 -vh 180 " + octreefilename + " > " + picturefilename
         os.system(rpictcommand)
         hpicturefilename = os.path.join(brad_path, "brad", "tmp", "tmph.pic")
         pcondcommand = "pcond -s+ " + picturefilename + " " + hpicturefilename
         os.system(pcondcommand)
      except:
         print "problems creating sky preview"
      if sys.platform=='win32':
         ximagecommand = "winimage " + hpicturefilename
      else:
         ximagecommand = "ximage " + hpicturefilename + " &"
      try:
         os.system(ximagecommand)
         #os.remove(skyfilename)
         #os.remove(octreefilename)
         #os.remove(picturefilename)
         #os.remove(hpicturefilename)
      except:
         print "problems erasing temporary files ..."

    def formatWeatherFiles(self, fileslist):
       i=0
       weathermenu = ""
       for wf in fileslist:
          weathermenu += wf + " %x"+ str(i)+"|"
          i+=1
       return weathermenu

    def formatSkyMaps(self, fileslist):
       i=0
       mapmenu = ""
       for skymap in fileslist:
          mapmenu += skymap + " %x"+ str(i)+"|"
          i+=1
       return mapmenu
