<?php
/**
 * A generic form with yes/no buttons
 *
 * $Id: YesNo.php 392 2013-01-02 15:11:31Z hschletz $
 *
 * Copyright (C) 2011-2013 Holger Schletz <holger.schletz@web.de>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * @package Forms
 */
/**
 * A generic form with yes/no buttons
 *
 * After submission, only one of 'yes' or 'no' will show up in $_POST.
 * @package Forms
 */
class Form_YesNo extends Zend_Form
{

    /**
     * Create elements
     */
    public function init()
    {
        $yes = new Zend_Form_Element_Submit('yes');
        $yes->setLabel('Yes');
        $this->addElement($yes);

        $no = new Zend_Form_Element_Submit('no');
        $no->setLabel('No');
        $this->addElement($no);
    }

}
