#include "lasca.h"

Lasca::Lasca()
{
}

/** Calcula Briers Passo:
 * Metodo usado fazer o calculo Briers com janela deslizante, em uma imagem do
 * tipo IplImage de 8-bits e um canal, recebe a imagem a ser analisada, uma
 * variavel do tipo inteira que determina qual sera a mascara, e uma outra
 * variavel do tipo inteira que determina qual é o deslocamento da mascara
 * utilizada no algoritmo. Recebe uma imagem em tons de cinza, cria uma nova
 * imagem com a resolucao determinada por um calculo feito com o valor do passo.
 * Esta imagem eh preenchida usando o metodo valorBries() e retornada.
 * @return: IplImage*
 * @param: IplImage* -> imagem na qual sera realizado o calculo Briers
 *         int -> valor da mascara utilizado no algoritmo.
           int -> valor do passo de deslocamento da mascara.
 * @author: Michel Melo da Silva
 * @date: 2011/01/27
 * @last: 2011/01/27
 */
IplImage* Lasca::calcLasca(IplImage *imagem, int mascara, int passo)
{
    // Variaveis do metodo.
    QList<unsigned char> list;
    int largura = imagem->width;
    int altura = imagem->height;
    int dif = (largura % passo);
    int tamanho = (largura - dif) * (altura - (altura % passo));

    // Cria uma imagem em niveis de cinza para receber o resultado do briers.
    IplImage* briers = cvCreateImage(cvSize(((largura-dif)/passo),
                                            ((altura-altura %passo)/passo)),
                                     IPL_DEPTH_8U,
                                     1);

    // Seta o fundo da imagem criada como preto.
    cvSet(briers, cvScalar(0), 0);

    // Calculo Briers
    for(int x=0; x < tamanho/passo; x = x + imagem->widthStep){
        for (int i = 0; i < largura - dif; i = i + passo){
            // Calcula a lista de valores da mascara.
            for (int j = 0; j < mascara; j++){
                list.append(imagem->imageData[(x * passo) + i + j]);
                for (int k = 1; k < mascara; k++){
                    list.append(imagem->imageData[(largura * k) + j +
                                                  (passo * x) + i]);
                }
            }
            briers->imageData[briers->widthStep * x / largura + i / passo] =
                    valorBries(list);
            list.clear();
        }
    }

    // Retorna a Imagem formada
    return briers;
}

/** Valor Briers:
 * Metodo utilizado para calcular o valor Briers sobre uma mascara passada por
 * parametro na forma QList<unsigned char>.
 * @return: int
 * @param: QList<unsigned char> -> valores do bits que compoe a mascara
 * @author: Michel Melo da Silva
 * @date: 2011/01/25
 * @last: 2011/01/26
 */
int Lasca::valorBries(QList<unsigned char> list)
{
    // Variaveis utilizadas no metodo
    int soma = 0;
    int somaq = 0;
    double var = 0.0;
    double std = 0.0;
    double media = 0.0;

    // Percorre a lista fazendo a soma e a soma quadrada
    for (int a = 0; a < list.size(); a++){
        soma = soma + list[a];
        somaq = somaq + pow(list[a], 2);
    }

    media = soma/list.size();                         //cálculo da média
    var = (somaq/list.size()) - pow(media, 2);        //cálculo da variância
    std = sqrt(var);                                  //cálculo do desvio padrão

    // Retorna o valor Briers como inteiro.
    return (round(( (std/(media+1)))*255));
}
