#include <QApplication>

#include "mainwindow.h"

void help(void);

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    if(argc>=2)
    {
        if(strcmp(argv[1],"-v")==0)
        {
            printf("%s %s\n",APP_TARGET,APP_VERSION);
            return EXIT_SUCCESS;
        }
        if(strcmp(argv[1],"-h")==0)
        {
            help();
            return EXIT_SUCCESS;
        }
    }
    MainWindow w;
    w.show();

    return a.exec();
}

void help(void)
{
    printf("\t\n");
    printf("%s -[vh]\n",APP_TARGET);
    printf("\t\n");
    printf("\t-v\tReturns the program name and version.\n");
    printf("\t-h\tReturns this help text.\n");
    printf("\t\n");
    printf("Examples:\t\n");
    printf("\t%s\n",APP_TARGET);
    printf("\t%s -v\n",APP_TARGET);
    printf("\t%s -h\n",APP_TARGET);
    printf("\t\n");
}
