#!/bin/bash

BUILDPKG_VERSION="0.0.2r28f"
OS_name="UNKNOWN"

HELPERSDIR="/usr/lib/buildpkg/helpers"

# ---[ OS dependent options ]---
ECHO_OPTS_E="-e"
WHOAMI="whoami"

get_OS_name ()
{
  OS_name="`( uname -s ) 2>&1`"
  case "$OS_name" in
    Linux|FreeBSD|NetBSD|BSD/OS|OpenBSD|SunOS|QNX)
    ;;
    IRIX*)
      OS_name="IRIX"
    ;;
  esac
}

do_type_selection ()
{
  selection=""
  
  while (true) do
    echo ""

    echo $ECHO_OPTS_E "---[ \033[1mplease select type of distribution ...\033[0m"
    echo $ECHO_OPTS_E " [1] \033[1mSlackware\033[0m"
    echo $ECHO_OPTS_E " [2] \033[1mDEB\033[0m based distro (i.e. Debian, ...)"
    echo $ECHO_OPTS_E " [3] \033[1mRPM\033[0m based distro (i.e. RedHat, SuSE, Mandrake, ...)"
    echo ""
    echo $ECHO_OPTS_E "---[ \033[1mor different OS type ...\033[0m"
    echo $ECHO_OPTS_E " [4] \033[1mSolaris\033[0m/SunOS"
    echo $ECHO_OPTS_E " [5] \033[1mFreeBSD\033[0m"
    echo ""
    echo $ECHO_OPTS_E "Please enter your selection: \033[1m\c"

    read selection

    echo $ECHO_OPTS_E "\033[0m"
    
    case "$selection" in
      '1')
        break
      ;;

      '2')
        break
      ;;

      '3')
        break
      ;;

      '4')
        break
      ;;

      '5')
        break
      ;;
    esac
  done

  echo ""
}

# ---[ global part, place every global initialization here ]---
  get_OS_name

  if test "$OS_name" = "SunOS" ; then
#    ECHO_OPTS_E=""
    WHOAMI="/usr/ucb/whoami"
  fi

echo
echo $ECHO_OPTS_E "\033[1mbuildpkg $BUILDPKG_VERSION\033[0m"
echo $ECHO_OPTS_E "\033[1mcopyright (c) 2001-2004 by DiCE / PsychoMix\033[0m"
echo $ECHO_OPTS_E "\033[1mhttp://savannah.nongnu.org/projects/buildpkg\033[0m"
echo

if test "`$WHOAMI`" != "root" ; then
  echo "ERROR: need to be root to proceed"
  echo
  exit
fi

DESTDIR=""

CONFDIR="/etc/buildpkg"
JAILFILE="${CONFDIR}/buildpkg.jail"
CONFFILE="${CONFDIR}/buildpkg.conf"
SBINDIR="$DESTDIR/sbin"
MANDIR="$DESTDIR/usr/man"
OWNER="0:0"
PERM="0755"

echo $ECHO_OPTS_E "\033[1m---[ install buildpkg utilities ]---\033[0m"

if test -d $CONFDIR; then
  if test ! -d ${CONFDIR}~; then
    mv $CONFDIR ${CONFDIR}~
  else
    echo "${CONFDIR}~ detected. Please remove it and start $0 again!"
    exit
  fi
fi

if test ! -d $CONFDIR ; then
  mkdir -p $CONFDIR
fi

if test ! -d $SBINDIR ; then
  mkdir -p $SBINDIR
fi

if test ! -d $MANDIR/man1 ; then
  mkdir -p $MANDIR/man1
fi

if test -f $SBINDIR/buildpkg-$BUILDPKG_VERSION ; then
  ( cd $SBINDIR && mv buildpkg-$BUILDPKG_VERSION buildpkg-$BUILDPKG_VERSION.old )
fi

# if test "$BASH" = ""; then
#   if test -x /usr/local/bin/bash; then
#     BASH="/usr/local/bin/bash"
#   fi
#
#   if test -x /usr/bin/bash; then
#     BASH="/usr/bin/bash"
#   fi
#
#   if test -x /bin/bash; then
#     BASH="/bin/bash"
#   fi
#
#   if test "$BASH" = ""; then
#     echo $ECHO_OPTS_E "Please enter path to bash: \c"
#     read $BASH
#   fi
#
#   if test "$BASH" = ""; then
#     echo "Please install BASH"
#     exit
#   fi
# fi

cat ./buildpkg-$BUILDPKG_VERSION > $SBINDIR/buildpkg-$BUILDPKG_VERSION
chown $OWNER $SBINDIR/buildpkg-$BUILDPKG_VERSION
chmod $PERM $SBINDIR/buildpkg-$BUILDPKG_VERSION

for i in buildpkg-$BUILDPKG_VERSION.1 \
         buildpkg.1 \
         checkinstalllog.1 \
         compare_filelists.1 \
         copy_into_jail.1 \
         copy_to_destdir.1 \
         create_filelist.1 \
         find_deps.1 \
         show_deps.1 \
         mkinfodir.1 \
         mkskel.1 ;
do
  cat ./$i > $MANDIR/man1/$i
  chown $OWNER $MANDIR/man1/$i
  chmod 644 $MANDIR/man1/$i
  ( cd $MANDIR/man1
    if test -f $i.gz ; then
      rm -f $i.gz
    fi
    gzip -9 $i )
done

do_type_selection

case "$selection" in
# Slackware
  '1')
    ./utilities/generate_jail.sh defaults/default.jail > $JAILFILE
    cat defaults/default.conf | sed s/package_type/slackware/g > $CONFFILE
  ;;

# DEB
  '2')
    if test ! -d $CONFDIR/deb ; then
      mkdir -p $CONFDIR/deb
    fi

    ./utilities/generate_jail.sh defaults/default.jail > $JAILFILE
    cat defaults/default.conf | sed s/package_type/deb/g > $CONFFILE

    for i in default.control \
             default.changelog \
             default.rules ;
    do
      cat defaults/deb/$i > $CONFDIR/deb/$i
      chown $OWNER $CONFDIR/deb/$i
      chmod 644 $CONFDIR/deb/$i
    done
  ;;

# RPM
  '3')
    if test ! -d $CONFDIR/rpm ; then
      mkdir -p $CONFDIR/rpm
    fi

    ./utilities/generate_jail.sh defaults/default.jail > $JAILFILE
    cat defaults/default.conf | sed s/package_type/rpm/g > $CONFFILE

    cat defaults/rpm/default.spec > $CONFDIR/rpm/default.spec
    chown $OWNER $CONFDIR/rpm/default.spec
    chmod 644 $CONFDIR/rpm/default.spec
  ;;

# Solaris
  '4')
    if test ! -d $CONFDIR/solaris ; then
      mkdir -p $CONFDIR/solaris
    fi

    cat defaults/solaris/depend.txt > $CONFDIR/solaris/depend.txt
    chown $OWNER $CONFDIR/solaris/depend.txt
    chmod 644 $CONFDIR/solaris/depend.txt

    ./utilities/generate_jail.sh defaults/default.jail > $JAILFILE
    cat defaults/default.conf | sed s/package_type/solaris/g > $CONFFILE
  ;;

# FreeBSD
  '5')
    ./utilities/generate_jail.sh defaults/default.jail > $JAILFILE
    cat defaults/default.conf | sed s/package_type/freebsd/g > $CONFFILE
  ;;
esac

chown $OWNER $CONFFILE
chmod 644 $CONFFILE

chown $OWNER $JAILFILE
chmod 600 $JAILFILE

echo $ECHO_OPTS_E "\033[1m---[ compile and install helper utilities ]---\033[0m"

if test -d ./helpers ; then
  cd ./helpers
    for i in geteuid lstat rotopipe; do
      cd ./$i
      make && make -e DESTDIR=${DESTDIR} HELPERSDIR=${HELPERSDIR} install
      echo "${HELPERSDIR}/$i" >> $JAILFILE
      cd ..
    done
  cd ..
else
  echo "ERROR: ./helpers directory not found.";
  exit 1
fi

echo $ECHO_OPTS_E "\033[1m---[ create link files ]---\033[0m"

( cd $SBINDIR && ./buildpkg-$BUILDPKG_VERSION --install )
