/* PairStack.java -- A stack of heterogenous pairs.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.commons;

import java.util.Stack;

/**
 * A stack of heterogenous pairs.
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 * @see java.util.Stack
 */
public class PairStack<A,B>
  extends Stack<Pair<A,B>>
{

  /**
   * Serialization ID.
   */
  private static final long serialVersionUID = 4077300638060255809L;

  /**
   * Constructs an empty <code>PairStack</code>.
   */
  public PairStack()
  {
    super();
  }

  /**
   * Returns the pair at the top of the stack, without removing it.
   *
   * @return the pair at the top of the stack.
   */
  public Pair<A,B> peek()
  {
    return super.peek();
  }

  /**
   * Pops the pair at the top of the stack, and returns it.
   *
   * @return the pair at the top of the stack.  The top of the stack is
   *         now the item below that returned.
   */
  public Pair<A,B> pop()
  {
    return super.pop();
  }

  /**
   * Pushes the supplied value onto the top of the stack.  The value
   * is a pair composed of the two supplied values.
   *
   * @param left the left-hand value of the pair.
   * @param right the right-hand value of the pair.
   * @return the pair that was added.
   */
  public Pair<A,B> push(A left, B right)
  {
    return super.push(new Pair<A,B>(left,right));
  }

  /**
   * Returns the distance of the supplied value from the top of the stack,
   * or -1 if the value is not on the stack.  1 represents the top item
   * on the stack.  The value used is a pair composed
   * of the two supplied values.  Values are compared using the equality
   * test of the pair.
   *
   * @param left the left-hand value of the pair.
   * @param right the right-hand value of the pair.
   * @return the index of the pair of values on the stack, or -1 if the
   *         pair isn't present.
   */
  public int search(A left, B right)
  {
    return super.search(new Pair<A,B>(left,right));
  }

}
