/* Connection.java -- A connection between two nodes.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor Eclipse plug-in.

 The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
 and redistribute it under the terms of the GNU General Public License
 version 2 (or, at your option, any later version), and/or the Eclipse
 Public License version 1.0.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.

 The University of Sheffield makes available all content in this plug-in
 ("Content"). Unless otherwise indicated below, the Content is provided to
 you under the terms and conditions of the Eclipse Public License Version
 1.0 ("EPL"). A copy of the EPL is available at
 http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
 "Program" will mean the Content.

 If you did not receive this Content directly from the University of Sheffield,
 the Content is being redistributed by another party ("Redistributor") and
 different terms and conditions may apply to your use of any object code in
 the Content. Check the Redistributor's license that was provided with the
 Content. If no such license exists, contact the Redistributor. Unless
 otherwise indicated below, the terms and conditions of the EPL still apply
 to any source code in the Content.

 */


package nongnu.cashews.eclipse.composer.model;

import java.util.ArrayList;

import nongnu.cashews.language.process.Connection;

public class ConnectionElement extends Element
{

  /**
   * Comment for <code>serialVersionUID</code>
   */
  private static final long serialVersionUID = 1L;

  private Node target;

  private Node source;
  
  private Connection conn;

  public ConnectionElement(Node source, Node target)
  {
    this.source = source;
    this.target = target;
    if (target.inputs != null)
      {
        target.addInput(this);
      }
    else
      {
        target.inputs = new ArrayList<ConnectionElement>();
        target.addInput(this);
      }
    if (source.outputs != null)
      {
        source.addOutput(this);
      }
    else
      {
        source.outputs = new ArrayList<ConnectionElement>();
        source.addOutput(this);
      }
    
    conn = new Connection();
    PerformanceElement sourcePerformNode = (PerformanceElement) source; 
    conn.setFromPerformance(sourcePerformNode.getPerformance().getName());
    PerformanceElement targetPerformNode = (PerformanceElement) target; 
    conn.setToPerformance(targetPerformNode.getPerformance().getName());  
    
  }

  public Node getTarget()
  {
    return this.target;
  }

  public Node getSource()
  {
    return this.source;
  }
}
