/* Diagram.java -- Representation of the diagram as a whole.
Copyright (C) 2005  The University of Sheffield.

This file is part of the CASheW-s editor Eclipse plug-in.

The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
and redistribute it under the terms of the GNU General Public License
version 2 (or, at your option, any later version), and/or the Eclipse
Public License version 1.0.

The CASheW-s editor is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with The CASheW-s editor; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

The University of Sheffield makes available all content in this plug-in
("Content"). Unless otherwise indicated below, the Content is provided to
you under the terms and conditions of the Eclipse Public License Version
1.0 ("EPL"). A copy of the EPL is available at
http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
"Program" will mean the Content.

If you did not receive this Content directly from the University of Sheffield,
the Content is being redistributed by another party ("Redistributor") and
different terms and conditions may apply to your use of any object code in
the Content. Check the Redistributor's license that was provided with the
Content. If no such license exists, contact the Redistributor. Unless
otherwise indicated below, the terms and conditions of the EPL still apply
to any source code in the Content.

*/

package nongnu.cashews.eclipse.composer.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import java.io.InputStreamReader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Diagram 
extends Element 
implements XMLizable
{

// serialization version
static final long serialVersionUID = 1;

// properties
public static final String NODES = "nodes";

// actual fields
protected List<Node> nodes = new ArrayList<Node>();

public void addNode(Node node)
{
 nodes.add(node);
 fireStructureChange(NODES, nodes);
}

public void removeNode(Node node)
{
 nodes.remove(node);
 fireStructureChange(NODES, nodes);
}

public List getNodes()
{
 return this.nodes;
}

// ------------------------------------------------------------------------
// I/O

public InputStream getAsStream() throws IOException
{
 ByteArrayOutputStream os = new ByteArrayOutputStream();
 BufferedOutputStream o = new BufferedOutputStream(os);
 o.write(this.toXML().getBytes());
 o.close();
 InputStream istream = new ByteArrayInputStream(os.toByteArray());
 os.close();
 return istream;
}

public static Diagram makeFromStream(InputStream istream) throws IOException,
   ClassNotFoundException, Exception
{
 /*
  * ObjectInputStream ois = new ObjectInputStream(istream); Diagram diagram =
  * (Diagram) ois.readObject(); ois.close(); return diagram;
  */

 ByteArrayInputStream is = new ByteArrayInputStream(
                                                    istream.toString().getBytes());
 BufferedInputStream i = new BufferedInputStream(is);

 XMLReader reader = XMLReaderFactory.createXMLReader();
 DiagramParser handler = new DiagramParser();
 reader.setContentHandler(handler);
 reader.setErrorHandler(handler);

 InputStreamReader r = new InputStreamReader(istream);

 reader.parse(new InputSource(r));

 return handler.getDiagram();
}

/*
* (non-Javadoc)
* 
* @see nongnu.cashews.eclipse.composer.model.XMLizable#toXML()
*/
public String toXML()
{
 StringBuffer str = new StringBuffer();
 str.append("<WorkflowDiagram version=");
 str.append("\"");
 str.append(serialVersionUID + "\"" + ">");

 Iterator i = nodes.iterator();
 Node n;

 while (i.hasNext())
   {
     n = (Node) i.next();
     str.append(n.toXML());
   }
 str.append("</WorkflowDiagram>");
 return str.toString();
}

}
