/* DiagramParser.java -- Deserializer for diagrams.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor Eclipse plug-in.

 The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
 and redistribute it under the terms of the GNU General Public License
 version 2 (or, at your option, any later version), and/or the Eclipse
 Public License version 1.0.

 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.

 The University of Sheffield makes available all content in this plug-in
 ("Content"). Unless otherwise indicated below, the Content is provided to
 you under the terms and conditions of the Eclipse Public License Version
 1.0 ("EPL"). A copy of the EPL is available at
 http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
 "Program" will mean the Content.

 If you did not receive this Content directly from the University of Sheffield,
 the Content is being redistributed by another party ("Redistributor") and
 different terms and conditions may apply to your use of any object code in
 the Content. Check the Redistributor's license that was provided with the
 Content. If no such license exists, contact the Redistributor. Unless
 otherwise indicated below, the terms and conditions of the EPL still apply
 to any source code in the Content.

 */


package nongnu.cashews.eclipse.composer.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.geometry.Point;

import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/**
 * @author Ravish
 * @author Xianfeng Liu
 * 
 * 
 */
public class DiagramParser extends DefaultHandler
{
  private Diagram d;

  private List<String> sourceList;

  boolean duplicateAtTheEnd = false;

  private List<String> targetList;

  public DiagramParser()
  {
    super();
  }

  public void startDocument()
  {
    d = new Diagram();
    sourceList = new ArrayList<String>();
    targetList = new ArrayList<String>();

  }

  public void endDocument()
  {
    if (d.nodes.size() <= 1)
      {
        return;
      }

    Iterator targetNames = targetList.iterator();
    Iterator sourceNames = sourceList.iterator();
    Node sourceNodes = null;
    Node targetNodes = null;
    List diagramNodes = d.getNodes();
    Iterator diagramIterator = d.getNodes().iterator();
     int counter = 0;
    while (sourceNames.hasNext() && targetNames.hasNext())
      {
        String tempSourceName = (String) sourceNames.next();
        diagramIterator = d.getNodes().iterator();
        while (diagramIterator.hasNext())
          {
            Node tempNode = (Node) diagramIterator.next();
            if (tempSourceName.equals((String) (tempNode.getName())))
              {
                sourceNodes = tempNode;
                 
                
              }
          }
        diagramIterator = d.getNodes().iterator();
        String tempTargetNode = (String) targetNames.next();
        while (diagramIterator.hasNext())
          {
            Node tempNode = (Node) diagramIterator.next();
            if (tempTargetNode.equals((String) (tempNode.getName())))
              {
                targetNodes = tempNode;
                
              }
          }
        
        if (counter!=0 && sourceNodes.getName().equals(sourceList.get(counter-1))){
            sourceNodes.outputs.add(new ConnectionElement(sourceNodes,targetNodes));
        }
        else{
            sourceNodes.outputs = new ArrayList<ConnectionElement>();
        new ConnectionElement(sourceNodes, targetNodes);}
        counter++;
      }

    /*int max = 0;
    for (int k = 0; k < d.nodes.size(); k++)
      {
        Node cur = (Node) d.nodes.get(k);
        int tmp = Integer.parseInt(cur.getName().substring(8));
        if (cur.getName().startsWith("Untitled") && tmp > max)
          {
            max = tmp;
          }
      }
    System.out.println("Max autoId node is: " + max);*/

  }

  public void startElement(String uri, String name, String qName,
                           Attributes atts)
  {
    if (name.equals("WorkflowDiagram"))
      {
        return;
      }
    Node n;
    Point p;
    p = new Point();

    if (name.equals("RectangleNode"))
      {
        p.setLocation(Integer.parseInt(atts.getValue(1)),
                      Integer.parseInt(atts.getValue(2)));
        RectangleNodeFactory rFactory = new RectangleNodeFactory(
                                                                 PerformanceElement.class);
        n = rFactory.getNewObject(atts.getValue(0));
        n.setLocation(p);
        n.outputs = null;
        d.addNode(n);
      }
    else if (name.equals("EllipseNode"))
      {
        p.setLocation(Integer.parseInt(atts.getValue(1)),
                      Integer.parseInt(atts.getValue(2)));
        PerformanceElementFactory eFactory = new PerformanceElementFactory(PerformanceElement.class);
        n = eFactory.getNewObject(atts.getValue(0));
        n.setLocation(p);
        n.outputs = null;
        d.addNode(n);
      }
    else if (name.equals("OutgoingEdge"))
      {
        List temp = d.getNodes();

        Node s = (Node) temp.get(temp.size() - 1);
        String source = s.getName();
        String target = (String) atts.getValue(0);
        sourceList.add(source);
        System.out.println("Source node is: " + source);
        System.out.println("Target node is: " + target);
        targetList.add(target);
        System.out.println("sourcr list are: " + sourceList);
        System.out.println("target list are: " + targetList);

      }
  }

  public void endElement(String uri, String name, String qName)
  {

  }

  public Diagram getDiagram()
  {
    return d;
  }
}
