/* Element.java -- Representation of a diagram element.
   Copyright (C) 2005  The University of Sheffield.

This file is part of the CASheW-s editor Eclipse plug-in.

The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
and redistribute it under the terms of the GNU General Public License
version 2 (or, at your option, any later version), and/or the Eclipse
Public License version 1.0.
 
The CASheW-s editor is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with The CASheW-s editor; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

The University of Sheffield makes available all content in this plug-in
("Content"). Unless otherwise indicated below, the Content is provided to
you under the terms and conditions of the Eclipse Public License Version
1.0 ("EPL"). A copy of the EPL is available at
http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
"Program" will mean the Content.

If you did not receive this Content directly from the University of Sheffield,
the Content is being redistributed by another party ("Redistributor") and
different terms and conditions may apply to your use of any object code in
the Content. Check the Redistributor's license that was provided with the
Content. If no such license exists, contact the Redistributor. Unless
otherwise indicated below, the terms and conditions of the EPL still apply
to any source code in the Content.

*/

package nongnu.cashews.eclipse.composer.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

// abstract base class of elements in the model

public abstract class Element 
  implements Cloneable, Serializable
{

  // serialization version
  static final long serialVersionUID = 1;

  // property change listeners
  transient protected PropertyChangeSupport listeners = new PropertyChangeSupport(
                                                                                  this);

  public void addPropertyChangeListener(PropertyChangeListener listener)
  {
    listeners.addPropertyChangeListener(listener);
  }

  protected void firePropertyChange(String prop, Object old, Object newValue)
  {
    listeners.firePropertyChange(prop, old, newValue);
  }

  protected void fireStructureChange(String prop, Object child)
  {
    listeners.firePropertyChange(prop, null, child);
  }

  // implemented in order to create listeners field
  private void readObject(ObjectInputStream in) throws IOException,
      ClassNotFoundException
  {
    in.defaultReadObject();
    listeners = new PropertyChangeSupport(this);
  }

  public void removePropertyChangeListener(PropertyChangeListener l)
  {
    listeners.removePropertyChangeListener(l);
  }

}
