/* ConnectionPart.java -- Visible part of the connection.
   Copyright (C) 2005  The University of Sheffield.

This file is part of the CASheW-s editor Eclipse plug-in.

The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
and redistribute it under the terms of the GNU General Public License
version 2 (or, at your option, any later version), and/or the Eclipse
Public License version 1.0.
 
The CASheW-s editor is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with The CASheW-s editor; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

The University of Sheffield makes available all content in this plug-in
("Content"). Unless otherwise indicated below, the Content is provided to
you under the terms and conditions of the Eclipse Public License Version
1.0 ("EPL"). A copy of the EPL is available at
http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
"Program" will mean the Content.

If you did not receive this Content directly from the University of Sheffield,
the Content is being redistributed by another party ("Redistributor") and
different terms and conditions may apply to your use of any object code in
the Content. Check the Redistributor's license that was provided with the
Content. If no such license exists, contact the Redistributor. Unless
otherwise indicated below, the terms and conditions of the EPL still apply
to any source code in the Content.

*/

package nongnu.cashews.eclipse.composer.parts;

import nongnu.cashews.eclipse.composer.figures.PerformanceNodeFigure;
import nongnu.cashews.eclipse.composer.model.ConnectionElement;
import nongnu.cashews.eclipse.composer.model.PerformanceElement;
import nongnu.cashews.eclipse.composer.model.Node;

import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class ConnectionPart 
  extends AbstractConnectionEditPart
{

  // ------------------------------------------------------------------------
  // Abstract methods from AbstractEditPart

  private String name;

  private Ellipse ellipseFigure;

  private Label label;

  protected void createEditPolicies()
  {
    // none at present
  }

  protected void refreshVisuals()
  {
      try
      {
        PolylineConnection figure = (PolylineConnection) getFigure();
        ConnectionElement connx = (ConnectionElement) getModel();
    // figure.setRoutingConstraint(MagicHelper.getConnectionBendpoints(connx));

    PolygonDecoration decoration = new PolygonDecoration();
    PointList decorationPointList = new PointList();
    decorationPointList.addPoint(0, 0);
    decorationPointList.addPoint(-2, 2);
    // decorationPointList.addPoint(-4,0);
    decorationPointList.addPoint(-2, -2);
    decoration.setFill(true);
    decoration.setTemplate(decorationPointList);
    figure.setTargetDecoration(decoration);
    
    if (figure.getChildren().size() > 1)
    {
     figure.remove(ellipseFigure);   
     figure.remove(label);
    }
    
    ellipseFigure = new Ellipse();
    ellipseFigure.setSize(60,40);
   
    Dimension d = new Dimension(40, 40);
    label = new Label();
    label.setText("a\nb\nc");
    ellipseFigure.setLocation(midPoint(connx.getSource().getLocation(), connx.getTarget().getLocation()));
    label.setLocation(midPoint(connx.getSource().getLocation(), connx.getTarget().getLocation()));
    
    
    figure.add(ellipseFigure);
    figure.add(label);
    figure.addFigureListener
    (
            new FigureListener()
            {

              public void figureMoved(IFigure source)
              {
                ConnectionElement connx = (ConnectionElement) getModel();
                ellipseFigure.setLocation(midPoint(connx.getSource().getLocation(), connx.getTarget().getLocation()));
                label.setLocation(midPoint(connx.getSource().getLocation(), connx.getTarget().getLocation()));
              }
                
            }
    );

      }
      catch(Exception e)
      {
        e.printStackTrace();
        System.out.println("Refresh Visuals");
      }
    
  }
  public Point midPoint(Point x, Point y)
  {
      Point p = new Point ( (x.x + y.x)/2, (x.y + y.y) /2 );
      return p;
  }
}
