/* RectangleNodePart.java -- Displayable part of the rectangular node.
   Copyright (C) 2005  The University of Sheffield.

This file is part of the CASheW-s editor Eclipse plug-in.

The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
and redistribute it under the terms of the GNU General Public License
version 2 (or, at your option, any later version), and/or the Eclipse
Public License version 1.0.
 
The CASheW-s editor is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with The CASheW-s editor; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

The University of Sheffield makes available all content in this plug-in
("Content"). Unless otherwise indicated below, the Content is provided to
you under the terms and conditions of the Eclipse Public License Version
1.0 ("EPL"). A copy of the EPL is available at
http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
"Program" will mean the Content.

If you did not receive this Content directly from the University of Sheffield,
the Content is being redistributed by another party ("Redistributor") and
different terms and conditions may apply to your use of any object code in
the Content. Check the Redistributor's license that was provided with the
Content. If no such license exists, contact the Redistributor. Unless
otherwise indicated below, the terms and conditions of the EPL still apply
to any source code in the Content.

*/

package nongnu.cashews.eclipse.composer.parts;


import java.beans.PropertyChangeListener;
import java.util.List;

import nongnu.cashews.eclipse.composer.figures.RectangleNodeFigure;
import nongnu.cashews.eclipse.composer.model.RectangleNode;
import nongnu.cashews.eclipse.composer.tools.RectangleNodeCellEditorLocator;
import nongnu.cashews.eclipse.composer.tools.RectangleNodeDirectEditManager;


import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;

import org.eclipse.jface.viewers.TextCellEditor;

public class RectangleNodePart extends NodePart implements
    PropertyChangeListener, NodeEditPart
{ 
    

  // ------------------------------------------------------------------------
  // Overridden from AbstractGraphicalEditPart

  // override activate to register with the model for property changes
  public void activate()
  {
    if (isActive())
      {
        return;
      }
    super.activate();
    ((RectangleNode) getModel()).addPropertyChangeListener(this);
  }

  // override deactivate to deregister with the model
  public void deactivate()
  {
    if (!isActive())
      {
        return;
      }
    super.deactivate();
    ((RectangleNode) getModel()).removePropertyChangeListener(this);
  }

  protected List getModelSourceConnections()
  {
    return ((RectangleNode) this.getModel()).getOutgoingConnections();
  }

  protected List getModelTargetConnections()
  {
    return ((RectangleNode) this.getModel()).getIncomingConnections();
  }
  
  // ------------------------------------------------------------------------
  // Overridden from AbstractEditPart

  protected void refreshVisuals()
  {
    RectangleNode node = (RectangleNode) this.getModel();
    Point loc = node.getLocation();
    Dimension size = new Dimension(400, 10);
    Rectangle rectangle = new Rectangle(loc, size);
    ((RectangleNodeFigure) this.getFigure()).setName(((RectangleNode) this.getModel()).getName());
    // tells the parent part (in this case DiagramPart) that this part
    // and its figure are to be constrained to the given rectangle
    ((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
                                                    rectangle);
    // //////============================================================

  }
  
  public void performRequest(Request request)
  {
    if (request.getType() == RequestConstants.REQ_DIRECT_EDIT)
      {
        if (manager == null)
          {
            RectangleNodeFigure nodeFigure = (RectangleNodeFigure) getFigure();
            manager = new RectangleNodeDirectEditManager(
                                                         this,
                                                         TextCellEditor.class,
                                                         new RectangleNodeCellEditorLocator(
                                                                                            nodeFigure),
                                                         nodeFigure);
          }
        manager.show();
      }
  }

  // ------------------------------------------------------------------------
  // Abstract methods from AbstractGraphicalEditPart

  protected IFigure createFigure()
  {
    // return new NodeFigure();
    return new RectangleNodeFigure();
  }

}
