/* EllipseNodeDirectEditManager.java -- Manager for direct edits.
Copyright (C) 2005  The University of Sheffield.

This file is part of the CASheW-s editor Eclipse plug-in.

The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
and redistribute it under the terms of the GNU General Public License
version 2 (or, at your option, any later version), and/or the Eclipse
Public License version 1.0.

The CASheW-s editor is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with The CASheW-s editor; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

The University of Sheffield makes available all content in this plug-in
("Content"). Unless otherwise indicated below, the Content is provided to
you under the terms and conditions of the Eclipse Public License Version
1.0 ("EPL"). A copy of the EPL is available at
http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
"Program" will mean the Content.

If you did not receive this Content directly from the University of Sheffield,
the Content is being redistributed by another party ("Redistributor") and
different terms and conditions may apply to your use of any object code in
the Content. Check the Redistributor's license that was provided with the
Content. If no such license exists, contact the Redistributor. Unless
otherwise indicated below, the terms and conditions of the EPL still apply
to any source code in the Content.

*/

package nongnu.cashews.eclipse.composer.tools;
import nongnu.cashews.eclipse.composer.figures.StartPointFigure;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;

import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;

public class StartPointNodeDirectEditManager 
extends DirectEditManager
{

Font scaledFont;

protected VerifyListener verifyListener;

protected StartPointFigure startPointFigure;

public StartPointNodeDirectEditManager(GraphicalEditPart source,
                                   Class editorType,
                                   CellEditorLocator locator,
                                   StartPointFigure startPointFigure)
{
 super(source, editorType, locator);
 this.startPointFigure = startPointFigure;
}

// ------------------------------------------------------------------------
// Overridden methods from DirectEditManager

protected void bringDown()
{
 Font disposeFont = this.scaledFont;
 this.scaledFont = null;
 super.bringDown();
 if (disposeFont != null)
   {
     disposeFont.dispose();
   }
}

protected void unhookListeners()
{
 super.unhookListeners();
 Text text = (Text) getCellEditor().getControl();
 text.removeVerifyListener(verifyListener);
 verifyListener = null;
}

// ------------------------------------------------------------------------
// Abstract methods from DirectEditManager

protected void initCellEditor()
{

 verifyListener = new VerifyListener()
 {
   public void verifyText(VerifyEvent event)
   {
     Text text = (Text) getCellEditor().getControl();
     String oldText = text.getText();
     String leftText = oldText.substring(0, event.start);
     String rightText = oldText.substring(event.end, oldText.length());
     GC gc = new GC(text);
     Point size = gc.textExtent(leftText + event.text + rightText);
     gc.dispose();
     if (size.x != 0)
       {
         size = text.computeSize(size.x, SWT.DEFAULT);
       }
     getCellEditor().getControl().setSize(size.x, size.y);
   }
 };

 Text text = (Text) getCellEditor().getControl();
 text.addVerifyListener(verifyListener);

 getCellEditor().setValue(this.startPointFigure.getText());
 IFigure figure = ((GraphicalEditPart) getEditPart()).getFigure();
 scaledFont = figure.getFont();
 FontData data = scaledFont.getFontData()[0];
 Dimension fontSize = new Dimension(0, data.getHeight());
 data.setHeight(fontSize.height);
 scaledFont = new Font(null, data);

 text.setFont(scaledFont);
 text.selectAll();
}
}
