/* DiagramCreationWizard.java -- Wizard for creating the diagram.
   Copyright (C) 2005  The University of Sheffield.

This file is part of the CASheW-s editor Eclipse plug-in.

The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
and redistribute it under the terms of the GNU General Public License
version 2 (or, at your option, any later version), and/or the Eclipse
Public License version 1.0.
 
The CASheW-s editor is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with The CASheW-s editor; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

The University of Sheffield makes available all content in this plug-in
("Content"). Unless otherwise indicated below, the Content is provided to
you under the terms and conditions of the Eclipse Public License Version
1.0 ("EPL"). A copy of the EPL is available at
http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
"Program" will mean the Content.

If you did not receive this Content directly from the University of Sheffield,
the Content is being redistributed by another party ("Redistributor") and
different terms and conditions may apply to your use of any object code in
the Content. Check the Redistributor's license that was provided with the
Content. If no such license exists, contact the Redistributor. Unless
otherwise indicated below, the terms and conditions of the EPL still apply
to any source code in the Content.

*/

package nongnu.cashews.eclipse.composer.ui;

import java.io.InputStream;

import nongnu.cashews.eclipse.composer.model.Diagram;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;

public class DiagramCreationWizard 
  extends Wizard 
  implements INewWizard
{

  private WizardPage wizardPage;

  private IStructuredSelection selection;

  private IWorkbench workbench;

  // ------------------------------------------------------------------------
  // Abstract methods from IWorkbenchWizard

  public void init(IWorkbench workbench, IStructuredSelection currentSelection)
  {
    this.workbench = workbench;
    this.selection = currentSelection;
  }

  // ------------------------------------------------------------------------
  // Overridden from Wizard

  public void addPages()
  {
    // by default the superclass doesn't have any pages - here we add one
    this.wizardPage = new WizardPage(this.workbench, this.selection);
    addPage(this.wizardPage);
  }

  // ------------------------------------------------------------------------
  // Abstract methods from Wizard

  public boolean performFinish()
  {
    return this.wizardPage.finish();
  }
}

class WizardPage extends WizardNewFileCreationPage
{

  private IWorkbench workbench;

  public WizardPage(IWorkbench aWorkbench, IStructuredSelection selection)
  {
    super("Workflow Page1", selection);
    this.setTitle("Create Workflow Model");
    this.setDescription("Create a new workflow");
    this.workbench = aWorkbench;
  }

  public boolean finish()
  {
    IFile newFile = createNewFile();
    if (newFile == null)
      return false; // ie.- creation was unsuccessful

    // Since the file resource was created fine, open it for editing
    // iff requested by the user
    try
      {
        IWorkbenchWindow dwindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = dwindow.getActivePage();
        if (page != null)
          page.openEditor(new FileEditorInput(newFile),
                          "nongnu.cashews.eclipse.composer.editor");
      }
    catch (org.eclipse.ui.PartInitException e)
      {
        e.printStackTrace();
        return false;
      }
    return true;
  }

  // ------------------------------------------------------------------------
  // Overridden from WizardNewFileCreationPage

  public void createControl(Composite parent)
  {
    super.createControl(parent);
    this.setFileName("cashew.cws");
    setPageComplete(validatePage());
  }

  protected InputStream getInitialContents()
  {
    // by default the superclass returns null for this

    Diagram diagram = new Diagram();

    InputStream istream = null;
    try
      {
        istream = diagram.getAsStream();
      }
    catch (Exception e)
      {
        e.printStackTrace();
      }
    return istream;
  }
}
