/* PaletteFactory.java -- Factory for creating palettes.
Copyright (C) 2005  The University of Sheffield.

This file is part of the CASheW-s editor Eclipse plug-in.

The CASheW-s editor Eclipse plug-in is free software; you may copy, modify,
and redistribute it under the terms of the GNU General Public License
version 2 (or, at your option, any later version), and/or the Eclipse
Public License version 1.0.

The CASheW-s editor is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with The CASheW-s editor; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

The University of Sheffield makes available all content in this plug-in
("Content"). Unless otherwise indicated below, the Content is provided to
you under the terms and conditions of the Eclipse Public License Version
1.0 ("EPL"). A copy of the EPL is available at
http://www.eclipse.org/legal/epl-v10.html. For purposes of the EPL,
"Program" will mean the Content.

If you did not receive this Content directly from the University of Sheffield,
the Content is being redistributed by another party ("Redistributor") and
different terms and conditions may apply to your use of any object code in
the Content. Check the Redistributor's license that was provided with the
Content. If no such license exists, contact the Redistributor. Unless
otherwise indicated below, the terms and conditions of the EPL still apply
to any source code in the Content.

*/

package nongnu.cashews.eclipse.composer.ui;

import java.util.ArrayList;
import java.util.List;

import nongnu.cashews.eclipse.composer.model.PerformanceElement;
import nongnu.cashews.eclipse.composer.model.PerformanceElementFactory;
import nongnu.cashews.eclipse.composer.model.EndPointNode;
import nongnu.cashews.eclipse.composer.model.EndPointNodeFactory;
import nongnu.cashews.eclipse.composer.model.RectangleNode;
import nongnu.cashews.eclipse.composer.model.RectangleNodeFactory;
import nongnu.cashews.eclipse.composer.model.StartPointNode;
import nongnu.cashews.eclipse.composer.model.StartPointNodeFactory;

import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;

public class PaletteFactory
{

private static PaletteContainer createControlGroup(PaletteRoot root)
{
 PaletteGroup controlGroup = new PaletteGroup("Control Group");

 List<ToolEntry> entries = new ArrayList<ToolEntry>();
 ToolEntry tool = new SelectionToolEntry();
 entries.add(tool);
 root.setDefaultEntry(tool);

 tool = new ConnectionCreationToolEntry("Connection", "Create a connection",
                                        null, null, /* small icon */
                                        null /* large icon */
 );
 entries.add(tool);

 controlGroup.addAll(entries);
 return controlGroup;
}

private static PaletteContainer createComponentsDrawer()
{

 PaletteDrawer drawer = new PaletteDrawer("Components", null);

 List<ToolEntry> entries = new ArrayList<ToolEntry>();
 ToolEntry tool = new CombinedTemplateCreationEntry(
                                                    "Synchronization",
                                                    "Create a new Synchronization",
                                                    RectangleNode.class,
                                                    new RectangleNodeFactory(
                                                                             RectangleNode.class),
                                                    null, /* small icon */
                                                    null /* large icon */
 );
 ToolEntry ellipseTool = new CombinedTemplateCreationEntry(
                                                           "Performance",
                                                           "Create a new Performance",
                                                           PerformanceElement.class,
                                                           new PerformanceElementFactory(
                                                                                  PerformanceElement.class),
                                                           null, /*
                                                                  * small
                                                                  * icon
                                                                  */
                                                           null /*
                                                                  * large
                                                                  * icon
                                                                  */
 );
 ToolEntry endPointTool = new CombinedTemplateCreationEntry(
     "EndPoint",
     "Create a new EndPoint",
     EndPointNode.class,
     new EndPointNodeFactory(
                            EndPointNode.class),
     null, /*
            * small
            * icon
            */
     null /*
            * large
            * icon
            */
);
 ToolEntry startPointTool = new CombinedTemplateCreationEntry(
     "StartPoint",
     "Create a new StartPoint",
     StartPointNode.class,
     new StartPointNodeFactory(
             StartPointNode.class),
     null, /*
            * small
            * icon
            */
     null /*
            * large
            * icon
            */
);
 //entries.add(tool);
 entries.add(ellipseTool);
 //entries.add(startPointTool);
 //entries.add(endPointTool);
 drawer.addAll(entries);
 return drawer;
}

private static List createCategories(PaletteRoot root)
{
 List<PaletteContainer> categories = new ArrayList<PaletteContainer>();

 categories.add(createControlGroup(root));
 categories.add(createComponentsDrawer());

 return categories;
}

public static PaletteRoot createPalette()
{
 PaletteRoot paletteRoot = new PaletteRoot();
 paletteRoot.addAll(createCategories(paletteRoot));
 return paletteRoot;
}

}
