package nongnu.cashews.eclipse.composer.wizards;

import nongnu.cashews.eclipse.composer.commands.CreateNodeCommand;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.Wizard;

// The data model.

class ProcessWizard extends Wizard {
CreateNodeCommand cn = new CreateNodeCommand(); 
ProcessData data = new ProcessData();
ProcessDefine pd ;
static final String KEY_PERFORMANCE_NAME = "Performance Name";

  public ProcessWizard(ProcessDefine pd) {
    setWindowTitle("Process definition wizard");
    setNeedsProgressMonitor(true);
    DialogSettings dialogSettings = new DialogSettings("ProcessInfo");
    setDialogSettings(dialogSettings);
    this.pd = pd;
  }

  /* (non-Javadoc)
   * @see org.eclipse.jface.wizard.IWizard#addPages()
   */
  public void addPages() {
    addPage(new WSDLFileLoadPage());
    addPage(new NamePerformancePage());
    addPage(new OperationSelectPage());
    addPage(new ValueDataSelectedPage());
    addPage(new ValueDataSelectedPage2());

  }

  /* (non-Javadoc)
   * @see org.eclipse.jface.wizard.IWizard#performFinish()
   */
  public boolean performFinish() {
      if(getDialogSettings() != null) {
      getDialogSettings().put(KEY_PERFORMANCE_NAME, data.performanceName);
    }
    try {
      // puts the data into a database ...
      getContainer().run(true, true, new IRunnableWithProgress() {
        public void run(IProgressMonitor monitor)
          throws InvocationTargetException, InterruptedException {
          monitor.beginTask("Store data", 100);
          monitor.worked(40);
          // store data here ...
         // System.out.println(data);
          pd.setpName(data.performanceName);
          pd.setoName(data.operationName);
          Thread.sleep(2000);
          monitor.done();
        }
      });
    } catch (InvocationTargetException e) {
      e.printStackTrace();
    } catch (InterruptedException e) {
      e.printStackTrace();
    }
    return true;

  }

  /* (non-Javadoc)
   * @see org.eclipse.jface.wizard.IWizard#performCancel()
   */
  public boolean performCancel() {
    boolean ans = MessageDialog.openConfirm(getShell(), "Confirmation", "Are you sure to cancel the task?");
    if(ans)
      return true;
    else{
      return false;}
  }  
}
