

package nongnu.cashews.eclipse.composer.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class WSDLFileLoadPage extends WizardPage
{

  Button browse, load;

  Text filePath;
  //Display display = new Display();
  Shell shell = new Shell();
  ProcessData pd = new ProcessData();
  public WSDLFileLoadPage()
  {
    super("WSDL Load");
    setTitle("Please load a WSDL file");
    setDescription("Please specify the path of the file");
    setPageComplete(false);
  }

  /*
   * (non-Javadoc)
   * 
   * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
   */
  public void createControl(Composite parent)
  {
    Composite composite = new Composite(parent, SWT.NULL);
    GridLayout gridLayout = new GridLayout(2, false);
    composite.setLayout(gridLayout);
    new Label(composite, SWT.UP).setText("Please locate the file!");
    Composite compositeText = new Composite(composite, SWT.NULL);
    compositeText.setLayout(new RowLayout());
    filePath = new Text(composite, SWT.SINGLE | SWT.BORDER);
    filePath.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
    filePath.setSize(500, 20);
    filePath.addListener(SWT.Modify, new Listener() {
    public void handleEvent(Event event) {
     if (filePath.getText()!=null){
        setPageComplete(true);      
     }
     else{setPageComplete(false);}
    }
  });
    Composite compositeButton2 = new Composite(composite, SWT.NULL);
    compositeButton2.setLayout(new RowLayout());
    browse = new Button(composite, SWT.RIGHT);
    browse.setText("Browse");

    browse.addSelectionListener(new SelectionAdapter() {
    public void widgetSelected(SelectionEvent e) {
      FileDialog dialog = new FileDialog(shell, SWT.OPEN);
      String file = dialog.open();
      if(file != null) {
      try {
        
        filePath.setText(file);
        
      } catch (Exception ex) {
        ex.printStackTrace();
       
      }
    }
    }
  });
    setControl(composite);
  }

}
