/* ConnectionPage.java -- The wizard page for connecting two performances.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.eclipse.gui;

import java.io.File;
import java.io.IOException;

import java.net.URISyntaxException;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;

import nongnu.cashews.language.process.AtomicProcess;
import nongnu.cashews.language.process.MultiPerform;
import nongnu.cashews.language.process.MultiPerformElement;
import nongnu.cashews.language.process.Performance;

import nongnu.cashews.language.grounding.SoapOperation;
import nongnu.cashews.wsdl.WsdlParser;

import org.eclipse.core.runtime.Status;

import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.WizardPage;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

import org.xml.sax.SAXException;

/**
 * The wizard page for creating a connection.
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class ConnectionPage
  extends WizardPage
{

  List list1, list2;

  /**
   * The map of strings in the list to performances.
   */
  private Map<String,Performance> performanceMap;

  /**
   * Construct a new <code>ConnectionPage</code>.
   */
  public ConnectionPage()
  {
    super("Create a connection");
  }

  /**
   * Create the controls for this page.
   *
   * @param parent the parent wizard.
   */
  public void createControl(Composite parent)
  {
    Composite container = new Composite(parent, SWT.NULL);
    RowLayout layout = new RowLayout(SWT.HORIZONTAL);
    layout.justify = true;
    layout.fill = false;
    container.setLayout(layout);
    list1 = new List(container, SWT.CENTER | SWT.SINGLE);
    list2 = new List(container, SWT.CENTER | SWT.SINGLE);
    performanceMap = new HashMap<String,Performance>();
    setControl(container);
    setPageComplete(true);
  }

  public Control getControl()
  {
        CashewsWizard wizard = (CashewsWizard) getWizard();
    MultiPerform mp = (MultiPerform) wizard.getProcess().getControlStructure();
    if (mp != null)
      {
	for (MultiPerformElement e : mp.getContent())
	  {
	    Performance p = (Performance) e;
	    String name = p.getName().toString();
	    AtomicProcess ap = (AtomicProcess) p.getProcess();
	    SoapOperation op = (SoapOperation) ap.getGrounding();
	    String endpoint = op.getEndpoint().toString();
	    String listString = name + ":" + endpoint;
	    list1.add(listString);
	    list2.add(listString);
	    performanceMap.put(listString, p);
	  }
      }
    return super.getControl();
  }

}
