/* OperationChoicePage.java -- The wizard page for choosing the operation.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.eclipse.gui;

import java.io.File;
import java.io.IOException;

import java.net.URISyntaxException;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;

import nongnu.cashews.language.process.AtomicProcess;
import nongnu.cashews.language.process.MultiPerform;
import nongnu.cashews.language.process.Performance;

import nongnu.cashews.language.grounding.SoapOperation;

import nongnu.cashews.wsdl.WsdlParser;

import org.eclipse.core.runtime.Status;

import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.WizardPage;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

import org.xml.sax.SAXException;

/**
 * The wizard page for selecting an operation.
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class OperationChoicePage
  extends WizardPage
{

  /**
   * The list of operations.
   */
  private List list;

  /**
   * A map of <code>String</code>s to operations.
   */
  private Map<String,SoapOperation> operationMap;

  /**
   * Construct a new <code>OperationChoicePage</code>.
   */
  public OperationChoicePage()
  {
    super("Choose an operation");
  }

  /**
   * Create the controls for this page.
   *
   * @param parent the parent wizard.
   */
  public void createControl(Composite parent)
  {
    Composite container = new Composite(parent, SWT.NULL);
    RowLayout layout = new RowLayout(SWT.VERTICAL);
    layout.justify = true;
    layout.fill = false;
    container.setLayout(layout);
    Label label = new Label(container, SWT.LEFT);
    label.setText("Choose an operation from the list, or click Browse... " +
		  "to add more from a WSDL file.");
    Button button = new Button(container, SWT.CENTER);
    button.setText("Browse...");
    button.addSelectionListener(new SelectionAdapter()
      {
	public void widgetSelected(SelectionEvent event)
	{
	  FileDialog dialog = new FileDialog(getShell(), SWT.OPEN);
	  dialog.setFilterExtensions(new String[]{"wsdl"});
	  dialog.open();
	  String filename = dialog.getFilterPath() + "/" 
	    + dialog.getFileName();
	  try
	    {
	      Handler handler = new ConsoleHandler();
	      handler.setLevel(Level.FINE);
	      WsdlParser parser = new WsdlParser(handler);
	      parser.parse(new File(filename));
	      for (SoapOperation op: parser.getWsdlHandler().getOperations())
		{
		  String name = op.getEndpoint().toString();
		  list.add(name);
		  operationMap.put(name, op);
		}
	      list.pack();
	      setPageComplete(true);
	      int index = 0;
	      CashewsWizard wizard = (CashewsWizard) getWizard();
	      for (SoapOperation op: operationMap.values())
		{
		  try 
		    {
		      AtomicProcess ap = new AtomicProcess("Atomic" + index);
		      ap.setGrounding(op);
		      Performance performance = new Performance("Perform" +
								index);
		      performance.setProcess(ap);
		      MultiPerform mp = (MultiPerform) 
			wizard.getProcess().getControlStructure();
		      mp.add(performance);
		      ++index;
		    }
		  catch (URISyntaxException e)
		    {
		      System.err.println(e);
		      ErrorDialog.openError(getShell(), "I/O Error",
					    e.toString(), 
					    Status.CANCEL_STATUS);
		    }
		}
	      operationMap = new HashMap<String,SoapOperation>();
	      System.out.println(wizard.getProcess());
	    }
	  catch (IOException e)
	    {
	      System.err.println(e);
	      ErrorDialog.openError(getShell(), "I/O Error", e.toString(),
				    Status.CANCEL_STATUS);
	    }
	  catch (SAXException e)
	    {
	      System.err.println(e);
	      ErrorDialog.openError(getShell(), "Parsing error", e.toString(),
				    Status.CANCEL_STATUS);
	    }
	}
      });
    list = new List(container, SWT.CENTER | SWT.SINGLE);
    setControl(container);
    setPageComplete(false);
    operationMap = new HashMap<String,SoapOperation>();
  }


}
