/* AtomicProcess.java -- A simple process grounded in some web service.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.language.process;

import java.net.URI;
import java.net.URISyntaxException;

import nongnu.cashews.language.grounding.Grounding;

import nongnu.cashews.xml.XmlField;

/**
 * Represents a simple process with a set of inputs and outputs,
 * grounded in a web service.  The <code>AtomicProcess</code> provides
 * the connection between the CASheW-s language and the underlying
 * web services that provide the functionality.
 *
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class AtomicProcess
  extends Process
{

  /**
   * Serialization fields which specify how to serialize this class.
   */
  private static final XmlField[] serialPersistentFields
    = new XmlField[]
    {
      new XmlField("grounding",Grounding.class,false,true,true)
    };

  /**
   * The grounding for this <code>AtomicProcess</code>, which links
   * it to a real web service.
   *
   * @serial the process grounding.
   */
  private Grounding grounding;

  /**
   * Constructs a new <code>AtomicProcess</code> with the specified
   * name.
   *
   * @param name the name for this atomic process.
   * @throws URISyntaxException if the supplied name is not a valid URI.
   */
  public AtomicProcess(String name)
    throws URISyntaxException
  {
    super(name);
  }

  /**
   * Constructs a new <code>AtomicProcess</code> with the specified
   * name.
   *
   * @param name the name for this atomic process.
   */
  public AtomicProcess(URI name)
  {
    super(name);
  }

  /**
   * Sets the grounding of this atomic process.
   *
   * @param grounding the new grounding.
   */
  public void setGrounding(Grounding grounding)
  {
    this.grounding = grounding;
  }

  /**
   * Retrieves the grounding of this atomic process.
   *
   * @return the atomic process grounding.
   */
  public Grounding getGrounding()
  {
    return grounding;
  }

  /**
   * Returns a <code>String</code> representation of this atomic process.
   *
   * @return a textual representation.
   */
  public String toString()
  {
    String superString = super.toString();
    return superString.substring(0, superString.length() - 1) +
      ", grounding=" +
      grounding +
      "]";
  }

}

