/* DRSExpression.java -- Representation of a DRS expression.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.owls.expression;

/**
 * This class represents an OWL-S expression in DRS.
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class DRSExpression 
  extends Expression
{

  /**
   * This is the default constructor, which creates a new expression using the
   * DRS logical formalism and an empty body.
   */
  public DRSExpression()
  {
    super();
    setLanguage(LogicLanguage.DRS);
  }

  /**
   * This method always throws an exception in this subclass in order to
   * prevent changes to the expression language.
   * 
   * @throws UnsupportedOperationException
   *           as the language can not be modified.
   */
  public void setLanguage()
  {
    throw new UnsupportedOperationException("The logic language of this "
                                            + "class can not be changed.");
  }

}
