/* AtomicProcess.java -- Representation of an OWL-S atomic process.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.owls.process;

/**
 * An atomic process is the basic unit of a process implementation.
 * Interacting with an atomic process involves a maximum of two messages;
 * one containing the input parameters, and one containing the outputs.
 * The internals of the process are a `black box'; the only description
 * of the process is in terms of its external interface.  An atomic
 * process always has at least the two participants, the client
 * and the server.  To actually use the process, it must be related
 * to a grounding.
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 * @see Input
 * @see Output
 * @see Participant#CLIENT
 * @see Participant#SERVER
 * @see nongnu.cashews.owls.service.ServiceGrounding
 */
public class AtomicProcess
  extends Process
{

  /**
   * Default constructor, which constructs an <code>AtomicProcess</code>
   * with the two initial participants, the client and the server.
   */
  public AtomicProcess()
  {
    addParticipant(Participant.CLIENT);
    addParticipant(Participant.SERVER);
  }

}
