/* Binding.java -- Representation of an OWL-S binding.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.owls.process;

/**
 * <p>
 * Bindings are used to define output parameters and describe how
 * input parameters acquire their values.  In either case, the binding
 * contains a reference to the parameter and a description of its value,
 * using one of several different mechanisms
 * </p>
 * <p>
 * These mechanisms are as follows:
 * </p>
 * <ul>
 * <li>valueData &mdash; for constant data</li>
 * <li>valueSource &mdash; references a parameter in another process</li>
 * <li>
 * valueSpecifier &mdash; for a value specified by the interpretation of
 * an XML literal
 * </li>
 * </ul>
 * <p>
 * Value specifiers take one of the following two forms:
 * </p>
 * <ul>
 * <li>valueForm &mdash; an OWL description</li>
 * <li>valueFunction &mdash; a local client function call</li>
 * </ul>
 * <p>
 * and also contains the type of the parameter reference.
 * </p>
 *
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 * @see ValueData
 * @see ValueSource
 * @see ValueSpecifier
 * @see ValueForm
 * @see ValueFunction
 */
public abstract class Binding
{

  /**
   * The value descriptor which specifies how to obtain the value
   * for the bound parameter.
   *
   * @serial the value descriptor, which specifies how to obtain the value
   *         of the parameter.
   */
  private ValueDescriptor descriptor;

}
