/* CompositeProcess.java -- Representation of an OWL-S composite process.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.owls.process;

/**
 * A <code>CompositeProcess</code> is composed of several subprocesses,
 * and specify constraints on the order and conditional execution of
 * these processes.  They are constructed using control constructs,
 * and references to processes called <code>Perform</code>s.
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 * @see ControlConstruct
 * @see Perform
 */
public class CompositeProcess
  extends Process
{

  /**
   * The top-level or root control construct for this composite process.
   *
   * @serial the root control construct.
   */
  private ControlConstruct root;

  /**
   * A flag to determine whether this composite process descends finally
   * to atomic processes, and thus can be invoked.
   *
   * @serial whether the composite process can be invoked or not.
   */
  private boolean invocable;

  /**
   * The computed input of this composite process.  A computed input
   * consists of an expression which results in the input to this 
   * composite process as a whole.
   * This allows one of several inputs to be selected conditionally, for
   * example.  It is computed based on the makeup of the composite process.
   * The final expressiveness of this is excepted to be greater than OWL.
   *
   * @serial the computed input.
   * FIXME: Change to Thing when OWL exists.
   */
  private Object computedInput;

  /**
   * The computed output of this composite process.  A computed output
   * consists of an expression which results in the input to this 
   * composite process as a whole.
   * This allows one of several outputts to be selected conditionally, for
   * example.  It is computed based on the makeup of the composite process.
   * The final expressiveness of this is excepted to be greater than OWL.
   *
   * @serial the computed output.
   * FIXME: Change to Thing when OWL exists.
   */
  private Object computedOutput;

  /**
   * The computed precondition of this composite process.  A computed
   * precondition consists of an expression that characterises the
   * preconditions of the subprocesses.
   * The final expressiveness of this is excepted to be greater than OWL.
   *
   * @serial the computed precondition.
   * FIXME: Change to Thing when OWL exists.
   */
  private Object computedPrecondition;

  /**
   * The computed effect of this composite process.  A computed
   * effect consists of an expression that characterises the
   * effects of the subprocesses.
   * The final expressiveness of this is excepted to be greater than OWL,
   * and it is not presently well-defined for conditional effects.
   *
   * @serial the computed effect.
   * FIXME: Change to Thing when OWL exists.
   */
  private Object computedEffect;

}
