/* RepeatWhile.java -- An iterative construct which executes while true.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.owls.process;

import nongnu.cashews.owls.expression.Condition;

/**
 * A <code>RepeatWhile</code> construct repeatedly executes its
 * control construct while the condition holds.
 *
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 * @see ControlConstruct
 * @see nongnu.cashews.owls.expression.Condition
 */
public class RepeatWhile
  extends Iterate
{

  /**
   * The condition on which the iteration depends.
   *
   * @serial the condition.
   */
  private Condition condition;

  /**
   * The control construct which is repeatedly executed while the condition
   * returns true.
   *
   * @serial the control construct which is executed while the condition holds.
   */
  private ControlConstruct construct;

}
