/* Result.java -- Representation of an OWL-S process result.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.owls.process;

import nongnu.cashews.owls.expression.Condition;
import nongnu.cashews.owls.expression.Expression;

import java.util.List;

/**
 * This class represents the <code>Result</code> of an OWL-S process. It
 * bundles the conditional effects and outputs of the process, as well as
 * parameters that are used within this context.
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class Result
{

  /**
   * A list of <code>ResultVar</code> s used within the scope of this
   * <code>Result</code> instance.
   * 
   * @serial the result variables scoped over this instance.
   */
  private List<ResultVar> variables;

  /**
   * A list of <code>Condition</code> s used within the scope of this
   * <code>Result</code> instance.
   * 
   * @serial the conditions scoped over this instance.
   */
  private List<Condition> conditions;

  /**
   * A list of <code>Expression</code>s used within the scope of this
   * <code>Result</code> instance to define the effects of this operation.
   * 
   * @serial the effects scoped over this instance.
   */
  private List<Expression> expressions;

  /**
   * A list of <code>OutputBinding</code>s used within the scope of this
   * <code>Result</code> instance to define the relationship between
   * particular output parameters and value patterns.  Different result
   * conditions can set the same output parameters with different values,
   * and the consumers can refer to different values of the process.
   *
   * @serial the output bindings scoped over this instance.
   */
  private List<OutputBinding> outputBindings;

}
