/* ValueForm.java -- Representation of a binding with an OWL-based value.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.owls.process;

/**
 * <p>
 * A value form specifies the value of a binding using a pseudo-OWL
 * description.  This varies from the normal legal form of OWL, in
 * that variables (including process parameters) and <code>ValueOf</code>
 * forms can appear as the object of properties, where these things
 * violate the range of the property.  
 * </p>
 * <p>
 * The intended interpretation of this is as a pattern for the actual
 * value of the binding, following substitution of the variables.
 * </p>
 *
 * @see ValueOf
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class ValueForm
  extends ValueSpecifier
{

}
