/* Blank.java -- Representation of a RDF blank node.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.rdf;

/**
 * <p>
 * Blank nodes allow different parts of an RDF graph to be connected,
 * where there are no URIs to use for the intervening nodes.  Each blank
 * node has an identifier, which allows it to be used and referenced
 * in a triple.
 * </p>
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class Blank
  extends Node
{

  /**
   * The identifier for this blank node.
   * 
   * @serial the identifier for this node.
   */
  private String id;

  /**
   * Constructs a <code>Blank</code> using the specified identifier.
   *
   * @param identifier the identifier for this blank node.
   */
  public Blank(String identifier)
  {
    setIdentifier(identifier);
  }

  /**
   * Returns a textual representation of the blank node.
   *
   * @return a textual representation.
   */
  public String toString()
  {
    String superToString = super.toString();
    return superToString.substring(0, superToString.length() - 1) +
      ", id = " +
      id +
      "]";
  }

  /**
   * Returns a deep copy of this blank node.
   *
   * @return a clone of the blank node.
   */
  public Blank clone()
  {
    return (Blank) super.clone();
  }

  /**
   * Sets the identifier used by the blank node to the one specified.
   *
   * @param identifier the new identifier to use.
   */
  public void setIdentifier(String identifier)
  {
    id = identifier;
  }

}
