/* Subject.java -- Representation of a RDF subject.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.rdf;

/**
 * <p>
 * This interface represents an RDF subject. A subject can either be a URI
 * reference or a blank node.  Subjects are also defined as being instances
 * of a particular class by their <strong>type</strong>.
 * </p>
 * 
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 * @see Node
 * @see Subject
 * @see RDFURI
 * @see Blank
 */
public interface Subject 
  extends Cloneable
{

  /**
   * Returns a deep copy of the subject.
   *
   * @return a deep copy of the subject.
   */
  Subject clone();

}
