/* KeyValueService.java -- The CASheW-s key-value service.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.services;

import java.io.IOException;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;

import java.util.LinkedList;
import java.util.List;

import static javax.xml.XMLConstants.W3C_XML_SCHEMA_NS_URI;

import nongnu.cashews.language.grounding.MessagePart;
import nongnu.cashews.language.grounding.SoapMessage;
import nongnu.cashews.language.grounding.SoapOperation;

import nongnu.cashews.soap.SoapClient;

/**
 * Represents the CASheW-s key-value service.
 *
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class KeyValueService
{

  public static SoapOperation getService(String endpoint)
    throws URISyntaxException
  {
    SoapOperation operation = new SoapOperation(endpoint);
    SoapMessage input = new SoapMessage(null, "execRequest");
    MessagePart part1 = new MessagePart("input");
    part1.setName(null, "input");
    part1.setType(W3C_XML_SCHEMA_NS_URI, "string", "xsd");
    input.addPart(part1);
    operation.setInputMessage(input);
    return operation;
  }
  
  /**
   * Test harness which performs a workflow request with a test
   * composite process.
   *
   * @param args the command-line arguments.
   * @throws IOException if an I/O error occurs.
   * @throws URISyntaxException if one of the operation URIs is invalid.
   * @throws MalformedURLException if the endpoint URL is invalid.
   * @throws InstantiationException if a needed class can't be instantiated.
   * @throws IllegalAccessException if a needed class can't be accessed.
   * @throws ClassNotFoundException if a needed class can't be found.
   */
  public static void main(String[] args)
    throws URISyntaxException, MalformedURLException, IOException,
	   InstantiationException, IllegalAccessException,
	   ClassNotFoundException
  {
    SoapClient client = new SoapClient();
    SoapOperation operation = getService(args[0]);
    List<Input> inputs = new LinkedList<Input>();
    for (int a = 1; a < args.length; ++a)
      {
	String[] parts = args[a].split("=");
	Input input = new Input(parts[0],parts[1]);
	inputs.add(input);
      }
    client.call(operation, inputs);
  }

}
