/* Processes.java -- Test service processes.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.services;

import java.net.URISyntaxException;

import static javax.xml.XMLConstants.W3C_XML_SCHEMA_NS_URI;

import nongnu.cashews.language.grounding.MessagePart;
import nongnu.cashews.language.grounding.SoapMessage;
import nongnu.cashews.language.grounding.SoapOperation;

import nongnu.cashews.language.process.AtomicProcess;
import nongnu.cashews.language.process.CompositeProcess;
import nongnu.cashews.language.process.Consume;
import nongnu.cashews.language.process.Performance;
import nongnu.cashews.language.process.Produce;
import nongnu.cashews.language.process.Sequence;

/**
 * Test CASheW-s processes for use in service calls.
 *
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class Processes
{

  /**
   * A test composite process using a sequence.
   */
  public static final CompositeProcess TEST_COMPOSITE_SEQUENCE;

  /**
   * Static initializer
   */
  static
  {
    try
      {
	CompositeProcess process = new CompositeProcess("MyProcess");
	Sequence sequence = new Sequence();
	Performance performance = new Performance("MyPerform");
	AtomicProcess atomic1 = new AtomicProcess("MyAtomic");
	SoapOperation operation1 = new 
	  SoapOperation("http://soapclient.com/xml/soapresponder.wsdl");
	SoapMessage method1 = new 
	  SoapMessage("http://soapclient.com/xml/soapresponder.wsdl",
		      "Method1", "ns1");
	MessagePart input1a = new MessagePart("input1");
	input1a.setName(null, "bstrParam1");
	input1a.setType(W3C_XML_SCHEMA_NS_URI, "string", "xsd");
	method1.addPart(input1a);
	MessagePart input1b = new MessagePart("input2");
	input1b.setName(null, "bstrParam2");
	input1b.setType(W3C_XML_SCHEMA_NS_URI, "string", "xsd");
	method1.addPart(input1b);
	SoapMessage method1Response = new
	  SoapMessage("http://soapclient.com/xml/soapresponder.wsdl", 
		      "Method1Response","ns1");
	MessagePart output1 = new MessagePart("output");
	output1.setName(null, "bstrReturn");
	output1.setType(W3C_XML_SCHEMA_NS_URI, "string", "xsd");
	method1Response.addPart(output1);
	operation1.setInputMessage(method1);
	operation1.setOutputMessage(method1Response);
	atomic1.setGrounding(operation1);
	performance.setProcess(atomic1);
	sequence.add(performance);
	process.setControlStructure(sequence);
	Consume consume = new Consume("in1","MyPerform","input1",0);
	process.addConsumer(consume);
	Produce produce = new Produce("out1","MyPerform","output");
	process.addProducer(produce);
	TEST_COMPOSITE_SEQUENCE = process;
      }
    catch (URISyntaxException e)
      {
	throw new IllegalStateException("Couldn't initialise process.", e);
      }
  }

  /**
   * Private constructor to prevent instantiation.
   */
  private Processes()
  {
  }

}
