/* TypeMapper.java -- Maps Java types to XML schema types.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.xml.schema;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import nongnu.cashews.xml.schema.datatypes.AnyUri;
import nongnu.cashews.xml.schema.datatypes.Int;
import nongnu.cashews.xml.schema.datatypes.XsdQName;
import nongnu.cashews.xml.schema.datatypes.XsdString;

/**
 * Maps a Java data type to an XML schema data type.
 *
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public class TypeMapper
{

  /**
   * Map for the built-in XML schema datatypes.
   */
  private static Map<Type,XsdType<?>> builtInTypes;

  /**
   * Initializer for the static map.
   */
  static
  {
    builtInTypes = new HashMap<Type,XsdType<?>>();
    builtInTypes.put(URI.class, new AnyUri());
    builtInTypes.put(QName.class, new XsdQName());
    builtInTypes.put(Integer.class, new Int());
    builtInTypes.put(String.class, new XsdString());
  }

  /**
   * Maps a Java <code>Type</code> to its corresponding
   * XSD type.
   *
   * @param type the Java type to map, or <code>null</code>
   *             if no mapping exists.
   */
  public XsdType<?> map(Type type)
  {
    return builtInTypes.get(type);
  }

}
