/* XsdType.java -- Representation of an XML schema datatype.
 Copyright (C) 2005  The University of Sheffield.

 This file is part of the CASheW-s editor.

 The CASheW-s editor is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 The CASheW-s editor is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with The CASheW-s editor; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA.
*/

package nongnu.cashews.xml.schema;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

/**
 * Specifies that a class represents an XML schema data type.
 *
 * @author Andrew John Hughes (gnu_andrew@member.fsf.org)
 */
public interface XsdType<T>
{

  /**
   * Translates a value represented in a Java data type
   * to the appropriate value in this XML schema data type.
   *
   * @param document the XML document to use to create the XML tree.
   * @param value the value to translate.
   * @return an XML tree node representing the type.
   */
  Node translateValue(Document document, T value);

}
