# Catkin/Comment.pm
# Copyright (C) 2002-2003 colin z robertson
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package Catkin::Comment;

use XML::Escape;
use XML::DOM;
use Catkin::Util;
use CGI::Carp;
use Catkin::Item;
use DateTime;
use vars qw( $AUTOLOAD @ISA );

@ISA = qw(Catkin::Item);

my %fields = (
	parent    => undef,
);

# subroutine new
# 
# Returns: Entry object
#
sub new {
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $self  = {
		date       => undef,
		comments  => undef,
		_permitted => \%fields,
		%fields,
	};
    bless ($self, $class);

	my ($elem) = @_;
	$self->{DOM_NODE} = $elem || (new XML::DOM::Document())->createElement("comment");
	my @comments = ();
	foreach my $comment (XML::DOMWrap::get_child_elements($elem,"comment")) {
		push @comments, new Catkin::Comment($comment);
	}
	$self->comments([@comments]);
    $self->date(DateTime->now) unless $self->date;
	
    return $self;
}

sub comments {
	my $self = shift;
	my ($comment_list) = @_;
	if (defined $comment_list) {
		foreach my $old_comment (XML::DOMWrap::get_child_elements($self->node,"comment")) {
			$self->node->removeChild($old_comment);
		}
		$self->{comments} = $comment_list;
		foreach my $new_comment (@{$comment_list}) {
			$new_comment->parent($self);
			$new_comment->node->setOwnerDocument($self->node->getOwnerDocument);
			$self->node->appendChild($new_comment->node);
		}
	}
	return $self->{comments};
}

# subroutine add_comment
# 
# Args: list of child comment objects
# 
sub add_comment {
	my $self = shift;
	my ($comment) = @_;
	$self->comments([@{$self->{comments}},$comment]);
	return 1;
}

sub remove_comment {
    my $self = shift;
	my ($comment_id) = @_;
	my $found;
	my @new_comments;
	foreach my $comment(@{$self->comments}) {
		if ($comment->id eq $comment_id) {
			$found = 1;
		} else {
			push @new_comments, $comment;
			if ($comment->remove_comment($comment_id)) {
				$found = 1;
			}
		}
	}
	$self->comments(\@new_comments);
	return $found;
}

sub parent_entry {
	my $self = shift;
	return if !$self->parent;
	if ($self->parent->type eq 'entry') {
		return $self->parent;
	} else {
		return $self->parent->parent_entry;
	}
}

sub count {
	my $self = shift;
	my $total = 1;
	foreach my $child(@{$self->comments}) {
		$total += $child->count();
	}
	return $total;
}

sub type {
	return "comment";
}

sub id {
	my $self = shift;
	return ($self->simple_element("id",@_))[0];
}

sub name {
	my $self = shift;
	return ($self->simple_element("name",@_))[0];
}

sub email {
	my $self = shift;
	return ($self->simple_element("email",@_))[0];
}

sub url {
	my $self = shift;
	return ($self->simple_element("url",@_))[0];
}

sub title {
	my $self = shift;
	return ($self->simple_element("title",@_))[0];
}

sub text {
	my $self = shift;
	return ($self->simple_element("text",@_))[0];
}

sub AUTOLOAD {
	my $self = shift;
	my $type = ref($self) or croak "$self is not an object";

	my $name = $AUTOLOAD;
	$name =~ s/.*://;   # strip fully-qualified portion
	if ($name eq 'DESTROY') { return }

	unless (exists $self->{_permitted}->{$name} ) {
		croak "Can't access `$name' field in class $type";
	}

	if (@_) {
		return $self->{$name} = shift;
	} else {
		return $self->{$name};
	}
}

1;
