# Catkin/Template.pm
# Copyright (C) 2003 colin z robertson
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package Catkin::Template;

use Template::Parser;
use Template::Context;
use Template::Document;
use Catkin::Config;
use Catkin::Util;
use CGI::Carp;
use File::Spec::Functions;
use Data::Dumper;
use strict;

sub new {
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $self  = {
		HEADERS   => {},
		DATA      => "",
	};
    bless ($self, $class);
	
	my ($filename) = @_;
	
	if ($self->read($filename)) {
		return $self;
	} else {
		return;
	}
}

sub read {
	my $self = shift;
	my ($filename) = @_;
	if (open INPUT, $filename) {
		while (<INPUT>) {
			chomp;
			if ( /^([-A-Za-z]*):\s*(.*)/ ) {
				$self->header($1,$2);
			} elsif ( /^$/ ) {
				$self->parse_template(join "",<INPUT>) || return;
			} else {
				carp "Bad header in $filename\n";
				return;
			}
		}
		close INPUT;
		return 1;
	} else {
		carp "Could not open $filename for reading\n";
		return;
	}
}

sub header {
	my $self = shift;
	my ($name, $data) = @_;
	$name = lc($name);
	if (@_ == 1) {
		return $self->{HEADERS}->{$name};
	} elsif (@_ == 2) {
		$self->{HEADERS}->{$name} = $data;
		return 1;
	} else {
		carp "Wrong number of arguments in Catkin::Template::header\n";
		return;
	}
}

sub dependencies {
	my $self = shift;
	my $dependency_string = $self->header("depends");
	$dependency_string =~ s/\s*//g;
	my @dependencies = split(",",$dependency_string);
	if (!@dependencies) {
		@dependencies = ("self");
	}
	return @dependencies;
}

sub extension {
	my $self = shift;
	return $self->header("extension");
}

sub filename {
	my $self = shift;
	return $self->header("filename");
}

sub parse_template {
	my $self = shift;
	my ($template_data) = @_;
	if ($template_data) {
		$self->{DATA} = $template_data;
		my $parser = Template::Parser->new;
		if (my $parser_output = $parser->parse($self->data)) {
			$self->{PARSED_TEMPLATE} = Template::Document->new($parser_output);
		} else {
			print "Template could not be parsed.\n";
			return;
		}
	}
	return 1;
}

sub data {
	my $self = shift;
	return $self->{DATA};
}

sub parsed_template {
	my $self = shift;
	return $self->{PARSED_TEMPLATE};
}

sub process {
	my $self = shift;
	my ($vars) = @_;
	my $context = Template::Context->new(VARIABLES => $vars);
	my $output = eval { $self->parsed_template->process($context) };
	carp "Error while processing template: $@" if $@;
	return $output || "";
}

1;
