# Catkin/Item.pm
# Copyright (C) 2003 colin z robertson
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package Catkin::Item;

use XML::Escape;
use XML::DOM;
use Catkin::Util;
use CGI::Carp;
use Catkin::Item;
use vars qw( $AUTOLOAD @ISA );

sub as_xml {
	my $self = shift;
	return $self->node->toString;
}

sub simple_element {
	my $self = shift;
	my ($element_name, $text, $attributes) = @_;
	if (defined $text) {
		foreach my $node ($self->node->getElementsByTagName($element_name, 0)) {
			$self->node->removeChild($node);
		}
		my $new_node = $self->node->getOwnerDocument->createElement($element_name);
		my $text_node = $self->node->getOwnerDocument->createTextNode($text);
		$new_node->appendChild($text_node);
		if ($attributes) {
			foreach my $att_name (keys(%$attributes)) {
				$new_node->setAttribute($att_name,$attributes->{$att_name});
			}
		}
		$self->node->appendChild($new_node);
	}
	my $return_elem = XML::DOMWrap::get_child_element($self->node,$element_name);
	if ($return_elem) {
		my $return_text = XML::DOMWrap::text_of($return_elem);
		my $return_atts = {};
		foreach my $return_att ($return_elem->getAttributes->getValues) {
			$return_atts->{$return_att->getName} = $return_att->getValue;
		}
		return $return_text,$return_atts;
	} else {
		return;
	}
}

sub date {
	my $self = shift;
	if (@_) {
		if (ref($_[0]) eq 'DateTime') {
			my ($new_date) = @_;
			$self->simple_element("date",$new_date->strftime("%Y-%m-%dT%H:%M:%S%z"),{timezone=>$new_date->time_zone_long_name});
		} else {
			my ($format) = @_;
			my $date = $self->date;
			if ($date) {
				return $date->strftime($format);
			} else {
				return;
			}
		}
	}
	my ($date_str,$atts) = $self->simple_element('date');
	my $timezone = $atts->{timezone};
	if (($date_str || '') =~ m/
		^
		(\d\d\d\d)   # year
		[^\d]*
		(\d\d)       # month
		[^\d]*
		(\d\d)       # day
		[^\d]*
		(\d\d)       # hours
		[^\d]*
		(\d\d)       # mins
		(?:          # optional secs
		  [^-+\d]*
		  (\d\d)
		)?
		(            # optional tz
		  [-+]
		  \d\d\d\d
		)?
		$
	/x) {
		my ($year,$month,$day,$hour,$min,$tz_or_sec) = ($1,$2,$3,$4,$5,$6);
		my ($sec,$tz);
		if ($tz_or_sec) {
			if ($tz_or_sec =~ /^[-+]/) {
				$tz = $tz_or_sec;
				$sec = 0;
			}
			if ($tz_or_sec =~ /\d\d/) {
				$tz = '+0000';
				$sec = $tz_or_sec;
			}
		} else {
			$tz = '+0000';
			$sec = 0;
		}
		my $date = new DateTime(
			year      => $year,
			month     => $month,
			day       => $day,
			hour      => $hour,
			minute    => $min,
			second    => $sec,
			time_zone => $timezone || $tz,
		);
		return $date;
	} else {
		return;
	}
}

sub node {
	my $self = shift;
	return $self->{DOM_NODE};
}

1;
