package Catkin::Session;

use strict;
use File::Spec::Functions;

my $timeout = 180 * 60; # 3hrs;

sub clean_dir {
	my ($dir,$timeout) = @_;
	foreach my $file (list_dir($dir)) {
		my $now = time;
		my $ftime = (stat($file))[9];
		if ($ftime < $now - $timeout) {
			unlink($file);
		}
	}
}

sub list_dir {
	my ($directory) = @_;
	my @filelist;
	opendir(DIR,$directory) or return;
	foreach (readdir(DIR)) {
		if (!m/^\.\.?$/ && m/([^\/]+)/) {
			push @filelist, $1;
		}
	}
	closedir(DIR);
	return map $_ = catdir($directory,$_), @filelist;
}

sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my ($config,$raw_id) = @_;
	
	my $session_dir = catdir($config->key('priv_dir'),'sessions');
	if (!-e $session_dir) {
		mkdir($session_dir);
	}
	clean_dir($session_dir,$timeout);
	
	my $id = check_id($raw_id || '') or return;

	my $self = {
		id => $id,
		file => catfile($session_dir,$id),
	};
	bless($self,$class);
	if (-e $self->{file}) {
		$self->update;
		return $self;
	} else {
		return;
	}
}

sub create {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my ($config) = @_;

	my $session_dir = catdir($config->key('priv_dir'),'sessions');
	if (!-e $session_dir) {
		mkdir($session_dir);
	}
	clean_dir($session_dir,$timeout);

	my $id = generate_id($session_dir);

	my $self = {
		id   => $id,
		file => catfile($session_dir,$id),
	};
	bless($self,$class);
	
	if (open(OUTPUT,'>'.$self->{file})) {
		print OUTPUT "id: " . $self->{id} . "\n";
		close OUTPUT;
		return $self;
	} else {
		warn "Error opening file: $!\n";
		return;
	}
}

sub check_id {
	my ($raw_id) = @_;
	if ($raw_id =~ m/^([-a-z0-9]+)$/) {
		return $1;
	}
	return;
}

sub generate_id {
	my ($dir) = @_;
	my $id;
	while (1) {
		$id = sprintf('%x',time) . sprintf('%x',int(rand(10000)));
		last if !-e catfile($dir,$id);
	}
	return sprintf('%x',time) . sprintf('%x',int(rand(10000)));
}

sub update {
	my $self = shift;
	my $now = time;
	utime($now,$now,$self->{file});
}

sub delete {
	my $self = shift;
	unlink $self->{file};
}

sub id {
	my $self = shift;
	return $self->{id};
}

1;
