package Catkin::Template::Plugin::StripTags;

=head1 NAME

Catkin::Template::Plugin::StripTags - Strip HTML or XML tags

=head1 SYNOPSIS

  [% USE StripTags %]
  
  [% FILTER strip_tags %]
  <p>
  Foo <i>Bar</i>
  </p>
  [% END %]

=head1 DESCRIPTION

This Template Toolkit plugin provides a filter for stripping HTML or XML tags
and leaving just the text.

It's pretty crude.

=cut

use Template::Plugin::Filter;
use base qw( Template::Plugin::Filter );

sub init {
	my $self = shift;
	my $name = 'strip_tags';
	$self->install_filter($name);
	return $self;
}

sub filter {
	my ($self,$text) = @_;
	$text =~ s/ < [^>]* > / /gx;
	return $text;
}

1;
