# Catkin/Util.pm
# Copyright (C) 2002 colin z robertson
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package Catkin::Util;

use strict;
use Fcntl ':flock';
use CGI::Carp;
use File::Spec::Functions;

# subroutine _formatted_time
#
# Creates a string of the current date and time (UTC) in the format:
# "YYYY-MM-DD HH:MM:SS"
#
# Returns: date and time string
#
sub isodate {
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime;
	$year = $year + 1900;
	$mon = $mon + 1;
	return sprintf("%.4d-%.2d-%.2dT%.2d:%.2d:%.2d", $year, $mon, $mday, $hour, $min, $sec);
}

sub atomic_write {
	my ($filename, $output) = @_;
    if (open OUTFILE, ">$filename.tmp-$$") {
		print OUTFILE $output;
		close OUTFILE;
		rename("$filename.tmp-$$",$filename);
		return 1;
	} else {
		carp "Unable to write to $filename.tmp-$$: $!\n";
		return;
	}
}

sub last_n {
	my ($num,@oldlist) = @_;
	my (@newlist);
	while (@oldlist && $num) {
		push(@newlist,pop(@oldlist));
		$num--;
	}
	return @newlist;
}

sub list_dir {
	my ($directory) = @_;
	opendir(DIR,$directory);
	my @filelist = grep !m/^\.\.?$/, readdir(DIR);
	closedir(DIR);
	return map $_ = catdir($directory,$_), @filelist;
}

1;
