//This file comes from http://code.google.com/p/libjson-glibmm/
//and it is licensed under the GPLv2+.
//Copyright (C) 2009 tevaum
//Copyright (C) 2009 mxsoares
#include "JsonParserMM.hpp"

#include <exception>

JsonParserMM::JsonParserMM() {
  g_type_init();
  this->parser = json_parser_new();
}

JsonParserMM::~JsonParserMM() {
  g_object_unref (this->parser);
}

bool JsonParserMM::load_from_file(std::string file) {
  g_assert(JSON_IS_PARSER(this->parser));

  GError *err = NULL;
  json_parser_load_from_file(this->parser, file.c_str(), &err);
  if ( err != NULL ) {
    //throw std::exception::exception((char *)err->message);
    return false;
  }
  return true;
}

bool JsonParserMM::load_from_data(std::string data) {
  g_assert(JSON_IS_PARSER(this->parser));

  GError *err = NULL;
  json_parser_load_from_data(this->parser, data.c_str(), data.length(), &err);
  if ( err != NULL ) {
    //throw std::exception::exception((char *)err->message);
    return false;
  }
  return true;  
}

JsonNodeMM *JsonParserMM::get_root() {
  g_assert(JSON_IS_PARSER(this->parser));

  return new JsonNodeMM (json_parser_get_root(this->parser));
}
