// Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "cbc-show-list.h"
#include "cbc-show.h"
#include "json-glibmm.hpp"
#include "ucompose.hpp"

CBCShowList::CBCShowList()
{
}

CBCShowList::~CBCShowList()
{
}

bool CBCShowList::contains(Glib::ustring id)
{
  for (iterator it = begin(); it != end(); it++)
    if ((*it).get_id() == id)
      return true;
  return false;
}

        
CBCShowList::CBCShowList(const char *data, int datalen)
{
  JsonParserMM parser;
  bool success = parser.load_from_data(std::string(data));
  JsonNodeMM *items_node = parser.get_root()->get_object()->get_member("items");
  JsonArrayMM *items = items_node->get_array();
  for (unsigned int i = 0; i < items->get_length(); i++)
    {
      JsonObjectMM *node = items->get_element(i)->get_object();
      JsonNodeMM *id = node->get_member("ID");
      JsonNodeMM *airdate = node->get_member("airdate");
      JsonNodeMM *length = node->get_member("length");
      JsonNodeMM *title = node->get_member("title");
      push_back(CBCShow(String::ucompose("%1", id->get_int()), title->get_string(), airdate->get_int() / 1000, length->get_int() / 1000));
    }
}

CBCShowList* CBCShowList::create_from_json(const char *data, int datalen)
{
  return new CBCShowList(data, datalen);
}
