//  Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef CBC_OSD_MAIN_H
#define CBC_OSD_MAIN_H

// initialize the GUI and run the main loop; only one instance is ever
// constructed so Main::instance is a convenience for retrieving it
#include <string>
#include <glibmm.h>
class CBCShowList;
class Main
{
 public:
    Main(int &argc, char **&argv);
    ~Main();

    // singleton interface
    static Main &instance();
    
    void start_main_loop();
    void stop_main_loop();
    bool iterate_main_loop();

    static bool get_watching_news();
    static bool get_watching_sports();
    void set_sports_toggled();
    void set_news_toggled();
    static std::string get_data_path();
    void restart_polling();

 private:
    struct Impl;
    Impl *impl;

    bool version_appears_on_the_command_line;
    void on_connect_succeeded(bool success);
    void on_polled(const char *data, int datalen, Glib::ustring category, CBCShowList *shown);
    void on_show_popup(guint button, guint32 activate_time);
};


#endif // CBC_OSD_MAIN_H
