// Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "cbc-show-list.h"
#include "cbc-show.h"
#include "ucompose.hpp"

CBCShowList::CBCShowList()
{
}

CBCShowList::~CBCShowList()
{
}

bool CBCShowList::contains(Glib::ustring id)
{
  for (iterator it = begin(); it != end(); it++)
    if ((*it).get_id() == id)
      return true;
  return false;
}

Glib::ustring CBCShowList::get_span(Glib::ustring data, Glib::ustring span)
{
  std::vector < Glib::ustring > a = Glib::Regex::split_simple 
    (String::ucompose("<span class=\"%1\">", span), data);
  if (a.size() <= 1)
    return "";
  std::vector < Glib::ustring > b = Glib::Regex::split_simple ("</span>", a[1]);
  return b[0];
}

Glib::ustring CBCShowList::get_id(Glib::ustring data)
{
  std::vector < Glib::ustring > a = Glib::Regex::split_simple ("/ID/", data);
  if (a.size() <= 1)
    return "";
  std::vector < Glib::ustring > b = Glib::Regex::split_simple ("/\">", a[1]);
  return b[0];
}

Glib::ustring CBCShowList::get_title(Glib::ustring data)
{
  return get_span(data, "title");
}

Glib::ustring CBCShowList::get_desc(Glib::ustring data)
{
  return get_span(data, "desc");
}

bool CBCShowList::get_live(Glib::ustring data)
{
  Glib::ustring live = get_span(data, "liveinfo livenow");
  if (live.empty() == true)
    return false;
  return true;
}

CBCShowList::CBCShowList(const char *data, int datalen)
{
  //iterate over
  std::vector < Glib::ustring > a = Glib::Regex::split_simple
    ("<div class=\"clip col", data);
  for (unsigned int i = 1; i < a.size(); i++)
    push_back(CBCShow(get_id(a[i]), get_title(a[i]), get_desc(a[i]), 
                      get_live(a[i])));
}

CBCShowList* CBCShowList::create_from_html(const char *data, int datalen)
{
  return new CBCShowList(data, datalen);
}
