// Generated on 2011 July Wed, 20 at 18:05:17 by the CERTI message generator
// ----------------------------------------------------------------------------
// CERTI - HLA Run Time Infrastructure
// Copyright (C) 2010 Andrej Pancik
//
// This program is free software ; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public License
// as published by the Free Software Foundation ; either version 2 of
// the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY ; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program ; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
// ----------------------------------------------------------------------------
package certi;

import certi.communication.CertiException;
import certi.communication.MessageBuffer;
import certi.communication.CertiMessageType;
import certi.communication.CertiMessage;
import certi.rti.impl.CertiAttributeHandleSet;
import certi.rti.impl.CertiSuppliedAttributes;
import hla.rti.AttributeHandleSet;
import hla.rti.SuppliedAttributes;
import certi.rti.impl.CertiExtent;
import java.util.List;
import hla.rti.Region;
import hla.rti.FederateHandleSet;
import hla.rti.SuppliedParameters;
import certi.rti.impl.CertiLogicalTime;
import certi.rti.impl.CertiLogicalTimeInterval;
import hla.rti.LogicalTime;
import hla.rti.LogicalTimeInterval;

public class SendInteraction extends CertiMessage {
   private InteractionClassHandle interactionClass;
   private ParameterHandle parameters;
   private ParameterValue_t values;
   private RegionHandle region;
   private EventRetraction eventRetraction;

   public SendInteraction() {
      super(CertiMessageType.SEND_INTERACTION);
   }

   public SendInteraction(CertiLogicalTime federationTime) {
      super(CertiMessageType.SEND_INTERACTION, federationTime);
   }

   @Override
   public void writeMessage(MessageBuffer messageBuffer) {
      super.writeMessage(messageBuffer); //Header

      messageBuffer.write(interactionClass);
      messageBuffer.write(parameters);
      messageBuffer.write(region);
   }

   @Override
   public void readMessage(MessageBuffer messageBuffer) throws CertiException {
      super.readMessage(messageBuffer); //Header 

      messageBuffer.write(interactionClass);
      messageBuffer.write(parameters);
      messageBuffer.write(region);
   }

   @Override
   public String toString() {
      return (super.toString() + ", interactionClass: " + interactionClass + ", parameters: " + parameters + ", values: " + values + ", region: " + region + ", Combined: " + Combined);
   }

   public InteractionClassHandle getInteractionClass() {
      return interactionClass;
   }

   public ParameterHandle getParameters() {
      return parameters;
   }

   public ParameterValue_t getValues() {
      return values;
   }

   public RegionHandle getRegion() {
      return region;
   }

   public void setInteractionClass(InteractionClassHandle newInteractionClass) {
      this.interactionClass = newInteractionClass;
   }

   public void setParameters(ParameterHandle newParameters) {
      this.parameters = newParameters;
   }

   public void setValues(ParameterValue_t newValues) {
      this.values = newValues;
   }

   public void setRegion(RegionHandle newRegion) {
      this.region = newRegion;
   }

}

