#include "ab.h"
/*  The generated file will be put in 
 *  the AddressBook package
 */
/* ---------------------- BEGIN <nmsg> ------------------------ */
ab_nmsg_t* 
ab_nmsg_create(uint32_t nb) {
   ab_nmsg_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(ab_nmsg_t));
   assert(newObj!=NULL);
   newObj->type=0;
   newObj->messageName= strndup("nsmg",MAX_CSTRINGSIZE);
   return newObj;
}

void ab_nmsg_destroy(ab_nmsg_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void nmsg_serialize(MsgBuffer_t* msgBuffer) {
   /* Specific serialization code    */
   MB_write_uint32(msgBuffer,type);
   MB_write_string(msgBuffer,messageName);
}

void nmsg_deserialize(MsgBuffer_t* msgBuffer) {
   /* Specific deserialization code    */
   type = MB_read_uint32(msgBuffer);
   messageName = MB_read_string(msgBuffer);
}

/* specific Getter(s)/Setter(s) */
uint32_t ab_nmsg_getType(ab_nmsg_t* cthis)  {return cthis->type;}
void ab_nmsg_setType(ab_nmsg_t* cthis,  uint32_t newType) {cthis->type=newType;}
char* ab_nmsg_getMessageName(ab_nmsg_t* cthis)  {return cthis->messageName;}
void ab_nmsg_setMessageName(ab_nmsg_t* cthis,  char* newMessageName) {cthis->messageName=newMessageName;}
FILE* nmsg_show(FILE* out) {
   fprintf(out,"[nmsg -Begin] \n");
   /* Specific show code    */
   fprintf(out," type = " + type + " "     + "\n");
   fprintf(out," messageName = " + messageName + " "     + "\n");
   fprintf(out,"[nmsg -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <nmsg> ------------------------ */

/* ---------------------- BEGIN <PhoneNumber> ------------------------ */
ab_PhoneNumber_t* 
ab_PhoneNumber_create(uint32_t nb) {
   ab_PhoneNumber_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(ab_PhoneNumber_t));
   assert(newObj!=NULL);
   /* string without default value are unallocated before they are assigned a value    */
   newObj->number = NULL;
   _hasType=0;
   newObj->type = MOBILE;
   return newObj;
}

void ab_PhoneNumber_destroy(ab_PhoneNumber_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void PhoneNumber_serialize(MsgBuffer_t* msgBuffer) {
   /* Specific serialization code    */
   MB_write_string(msgBuffer,number);
   MB_write_bool(msgBuffer,_hasType);
   if (_hasType) {
      MB_write_uint32(msgBuffertype);
   }
}

void PhoneNumber_deserialize(MsgBuffer_t* msgBuffer) {
   /* Specific deserialization code    */
   number = MB_read_string(msgBuffer);
   _hasType = MB_read_bool(msgBuffer);
   if (_hasType) {
      type = static_cast<ab_PhoneType_t>(MB_read_uint32 ());
   }
}

/* specific Getter(s)/Setter(s) */
char* ab_PhoneNumber_getNumber(ab_PhoneNumber_t* cthis)  {return cthis->number;}
void ab_PhoneNumber_setNumber(ab_PhoneNumber_t* cthis,  char* newNumber) {cthis->number=newNumber;}
ab_PhoneType_t ab_PhoneNumber_getType(ab_PhoneNumber_t* cthis)  {return cthis->type;}
void ab_PhoneNumber_setType(ab_PhoneNumber_t* cthis,  ab_PhoneType_t newType) {
   cthis->_hasType=1;
   cthis->type=newType;
}
uint8_t hasType(ab_PhoneNumber_t cthis) {return cthis->_hasType;}
FILE* PhoneNumber_show(FILE* out) {
   fprintf(out,"[PhoneNumber -Begin] \n");
   /* Specific show code    */
   fprintf(out," number = " + number + " "     + "\n");
   fprintf(out,"(opt) type =" + type + " "    + "\n");
   fflush(out)
   fprintf(out,"[PhoneNumber -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <PhoneNumber> ------------------------ */

/* ---------------------- BEGIN <Person> ------------------------ */
ab_Person_t* 
ab_Person_create(uint32_t nb) {
   ab_Person_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(ab_Person_t));
   assert(newObj!=NULL);
   for (uint32_t i=0;i<nb;++i) {
      newObj[i].super = ab_nmsg_create(1)
      newObj[i].super->messageName = "Person"; 
      newObj[i].super->type = PERSON;
   }
   /* string without default value are unallocated before they are assigned a value    */
   newObj->name = NULL;
   /* id= <no default value in message spec using builtin>    */
   _hasEmail=0;
   /* string without default value are unallocated before they are assigned a value    */
   newObj->email = NULL;
   phoneSize = 0;
   phone = NULL;
   return newObj;
}

void ab_Person_destroy(ab_Person_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void Person_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   MB_write_string(msgBuffer,name);
   MB_write_int32(msgBuffer,id);
   MB_write_bool(msgBuffer,_hasEmail);
   if (_hasEmail) {
      MB_write_string(msgBuffer,email);
   }
   uint32_t phoneSize = phonesize;
   MB_write_uint32(msgBuffer,phoneSize);
   for (uint32_t i = 0; i < phoneSize; ++i) {
      phone[i]_serialize(msgBuffer);
   }
}

void Person_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   name = MB_read_string(msgBuffer);
   id = MB_read_int32(msgBuffer);
   _hasEmail = MB_read_bool(msgBuffer);
   if (_hasEmail) {
      email = MB_read_string(msgBuffer);
   }
   uint32_t phoneSize = MB_read_uint32(msgBuffer);
   phonesize =phoneSize);
   for (uint32_t i = 0; i < phoneSize; ++i) {
      phone[i]_deserialize(msgBuffer);
   }
}

/* specific Getter(s)/Setter(s) */
char* ab_Person_getName(ab_Person_t* cthis)  {return cthis->name;}
void ab_Person_setName(ab_Person_t* cthis,  char* newName) {cthis->name=newName;}
int32_t ab_Person_getId(ab_Person_t* cthis)  {return cthis->id;}
void ab_Person_setId(ab_Person_t* cthis,  int32_t newId) {cthis->id=newId;}
char* ab_Person_getEmail(ab_Person_t* cthis)  {return cthis->email;}
void ab_Person_setEmail(ab_Person_t* cthis,  char* newEmail) {
   cthis->_hasEmail=1;
   cthis->email=newEmail;
}
uint8_t hasEmail(ab_Person_t cthis) {return cthis->_hasEmail;}
uint32_t ab_Person_getPhoneSize(ab_Person_t* cthis){ return cthis->phoneSize;}
void ab_Person_setPhoneSize(ab_Person_t* cthis, uint32_t sz) {
   ab_PhoneNumber_t* temp;
   temp = ab_PhoneNumber_t_create(sz);
   if (cthis->phoneSize>0) {
      memcpy(temp,cthis->phone, (cthis->phoneSize)*sizeof(ab_PhoneNumber_t));
      free(cthis->phone);
      cthis->phone = temp;
      cthis->phoneSize = num;
}
}
ab_PhoneNumber_t ab_Person_getPhone(ab_Person_t* cthis, uint32_t rank) {return cthis->phone[rank];}
void ab_Person_setPhone(ab_Person_t* cthis, ab_PhoneNumber_t newPhone, uint32_t rank) {cthis->phone[rank]=newPhone;}
FILE* Person_show(FILE* out) {
   fprintf(out,"[Person -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out," name = " + name + " "     + "\n");
   fprintf(out," id = " + id + " "     + "\n");
   fprintf(out,"(opt) email =" + email + " "    + "\n");
   fflush(out)
   fprintf(out,"    phone [] = 
");
   for (uint32_t i = 0; i < getPhoneSize(); ++i) {
      out phone[i].show(out);
   }
   fprintf(out,"\n");
   fprintf(out,"[Person -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <Person> ------------------------ */

/* ---------------------- BEGIN <AddressBook> ------------------------ */
ab_AddressBook_t* 
ab_AddressBook_create(uint32_t nb) {
   ab_AddressBook_t* newObj;
   assert(nb>0);
   newObj = malloc(nb*sizeof(ab_AddressBook_t));
   assert(newObj!=NULL);
   for (uint32_t i=0;i<nb;++i) {
      newObj[i].super = ab_nmsg_create(1)
      newObj[i].super->messageName = "AddressBook"; 
      newObj[i].super->type = ADDRESSBOOK;
   }
   personSize = 0;
   person = NULL;
   return newObj;
}

void ab_AddressBook_destroy(ab_AddressBook_t** cthis) {
   assert(cthis!=NULL);
   free(*cthis);
   *cthis = NULL;
}

void AddressBook_serialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_serialize(msgBuffer);
   /* Specific serialization code    */
   uint32_t personSize = personsize;
   MB_write_uint32(msgBuffer,personSize);
   for (uint32_t i = 0; i < personSize; ++i) {
      person[i]_serialize(msgBuffer);
   }
}

void AddressBook_deserialize(MsgBuffer_t* msgBuffer) {
   /* Call mother class    */
   Super_deserialize(msgBuffer);
   /* Specific deserialization code    */
   uint32_t personSize = MB_read_uint32(msgBuffer);
   personsize =personSize);
   for (uint32_t i = 0; i < personSize; ++i) {
      person[i]_deserialize(msgBuffer);
   }
}

/* specific Getter(s)/Setter(s) */
uint32_t ab_AddressBook_getPersonSize(ab_AddressBook_t* cthis){ return cthis->personSize;}
void ab_AddressBook_setPersonSize(ab_AddressBook_t* cthis, uint32_t sz) {
   ab_Person_t* temp;
   temp = ab_Person_t_create(sz);
   if (cthis->personSize>0) {
      memcpy(temp,cthis->person, (cthis->personSize)*sizeof(ab_Person_t));
      free(cthis->person);
      cthis->person = temp;
      cthis->personSize = num;
}
}
ab_Person_t ab_AddressBook_getPerson(ab_AddressBook_t* cthis, uint32_t rank) {return cthis->person[rank];}
void ab_AddressBook_setPerson(ab_AddressBook_t* cthis, ab_Person_t newPerson, uint32_t rank) {cthis->person[rank]=newPerson;}
FILE* AddressBook_show(FILE* out) {
   fprintf(out,"[AddressBook -Begin] \n");
   /* Call mother class    */
   Super_show(out);
   /* Specific show code    */
   fprintf(out,"    person [] = 
");
   for (uint32_t i = 0; i < getPersonSize(); ++i) {
      out person[i].show(out);
   }
   fprintf(out,"\n");
   fprintf(out,"[AddressBook -End] \n");
   fflush(out);
   return out;
}
/* ---------------------- END <AddressBook> ------------------------ */

nmsg* MFactory_create(MType type){ 
   nmsg* msg = NULL;

   switch (type) {
      case nmsg_NOT_USED:
         return -1; /* value NOT_USED may not be used*/
         break;
      case nmsg_PERSON:
         msg = new Person();
         break;
      case nmsg_ADDRESSBOOK:
         msg = new AddressBook();
         break;
      case nmsg_LAST:
         return -1; /* value LAST may not be used*/
         break;
   } /*  end if switch (type)
   return msg;
} /* end of MFactory_create */

