#ifndef GG_H
#define GG_H
/* ****-**** Global System includes ****-**** */
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <assert.h>
#include <string.h>
/* ****-**** Includes coming from native types ****-**** */
/*  ----------------------------------------------------------------------------
 *  CERTI - HLA RunTime Infrastructure
 *  Copyright (C) 2002-2008  ONERA
 * 
 *  This program is free software ; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation ; either version 2 of
 *  the License, or (at your option) Any later version.
 * 
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY ; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program ; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 *  USA
 * 
 *  ----------------------------------------------------------------------------
 *  CERTI Messages description
 *  ----------------------------------------------------------------------------
 *  The messages related classes will be placed in the certi package
 */
/*  Native types has been defined:
 * - by included headers (see above)
 * - with typedef (see below [if any])
 */
static const uint32_t cer_versionMajor = 1;
static const uint32_t cer_versionMinor = 0;

/* ---------------------- BEGIN <EventRetraction> ------------------------ */
/*  The EventRetraction is not inheriting from base "Message"
 *  this is a plain message which may be used as field
 *  in messages merging from "Message". As such
 *  it won't appear in the generated factory method.
 *  It's a convenient way to describe a structured native
 *  message using "combine". 
 */
typedef struct  cer_EventRetraction {
   cer_FederateHandle_t sendingFederate;
   uint64_t SN;
} cer_EventRetraction_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_EventRetraction_t* cer_EventRetraction_create(uint32_t nb);
/* Destructor function */
void cer_EventRetraction_destroy(cer_EventRetraction_t** cthis);

/* Serialize function */
void cer_EventRetraction_serialize(cer_EventRetraction_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_EventRetraction_deserialize(cer_EventRetraction_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_FederateHandle_t cer_EventRetraction_getSendingFederate(cer_EventRetraction_t* cthis) ;
void cer_EventRetraction_setSendingFederate(cer_EventRetraction_t* cthis,  cer_FederateHandle_t newSendingFederate);
uint64_t cer_EventRetraction_getSN(cer_EventRetraction_t* cthis) ;
void cer_EventRetraction_setSN(cer_EventRetraction_t* cthis,  uint64_t newSN);
/* the show method */
FILE* EventRetraction_show(FILE* out);
/* ---------------------- END <EventRetraction> ------------------------ */

/* ---------------------- BEGIN <M_Open_Connexion> ------------------------ */
/*  Connexion initialization message
 */
typedef struct  cer_M_Open_Connexion {
   Message super;
   uint32_t versionMajor;
   uint32_t versionMinor;
} cer_M_Open_Connexion_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Open_Connexion_t* cer_M_Open_Connexion_create(uint32_t nb);
/* Destructor function */
void cer_M_Open_Connexion_destroy(cer_M_Open_Connexion_t** cthis);

/* Serialize function */
void cer_M_Open_Connexion_serialize(cer_M_Open_Connexion_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Open_Connexion_deserialize(cer_M_Open_Connexion_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
uint32_t cer_M_Open_Connexion_getVersionMajor(cer_M_Open_Connexion_t* cthis) ;
void cer_M_Open_Connexion_setVersionMajor(cer_M_Open_Connexion_t* cthis,  uint32_t newVersionMajor);
uint32_t cer_M_Open_Connexion_getVersionMinor(cer_M_Open_Connexion_t* cthis) ;
void cer_M_Open_Connexion_setVersionMinor(cer_M_Open_Connexion_t* cthis,  uint32_t newVersionMinor);
/* the show method */
FILE* M_Open_Connexion_show(FILE* out);
/* ---------------------- END <M_Open_Connexion> ------------------------ */

/* ---------------------- BEGIN <M_Close_Connexion> ------------------------ */
/*  Closing connexion message
 */
typedef struct  cer_M_Close_Connexion {
   Message super;
} cer_M_Close_Connexion_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Close_Connexion_t* cer_M_Close_Connexion_create(uint32_t nb);
/* Destructor function */
void cer_M_Close_Connexion_destroy(cer_M_Close_Connexion_t** cthis);

/* ---------------------- BEGIN <M_Create_Federation_Execution> ------------------------ */

typedef struct  cer_M_Create_Federation_Execution {
   Message super;
   char* federationName;/*  the federation name
 */
   char* FEDid;/*  the Federation ID which is in fact a filename
 */
} cer_M_Create_Federation_Execution_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Create_Federation_Execution_t* cer_M_Create_Federation_Execution_create(uint32_t nb);
/* Destructor function */
void cer_M_Create_Federation_Execution_destroy(cer_M_Create_Federation_Execution_t** cthis);

/* Serialize function */
void cer_M_Create_Federation_Execution_serialize(cer_M_Create_Federation_Execution_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Create_Federation_Execution_deserialize(cer_M_Create_Federation_Execution_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
char* cer_M_Create_Federation_Execution_getFederationName(cer_M_Create_Federation_Execution_t* cthis) ;
void cer_M_Create_Federation_Execution_setFederationName(cer_M_Create_Federation_Execution_t* cthis,  char* newFederationName);
char* cer_M_Create_Federation_Execution_getFEDid(cer_M_Create_Federation_Execution_t* cthis) ;
void cer_M_Create_Federation_Execution_setFEDid(cer_M_Create_Federation_Execution_t* cthis,  char* newFEDid);
/* the show method */
FILE* M_Create_Federation_Execution_show(FILE* out);
/* ---------------------- END <M_Create_Federation_Execution> ------------------------ */

/* ---------------------- BEGIN <M_Destroy_Federation_Execution> ------------------------ */

typedef struct  cer_M_Destroy_Federation_Execution {
   Message super;
   char* federationName;
} cer_M_Destroy_Federation_Execution_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Destroy_Federation_Execution_t* cer_M_Destroy_Federation_Execution_create(uint32_t nb);
/* Destructor function */
void cer_M_Destroy_Federation_Execution_destroy(cer_M_Destroy_Federation_Execution_t** cthis);

/* Serialize function */
void cer_M_Destroy_Federation_Execution_serialize(cer_M_Destroy_Federation_Execution_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Destroy_Federation_Execution_deserialize(cer_M_Destroy_Federation_Execution_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
char* cer_M_Destroy_Federation_Execution_getFederationName(cer_M_Destroy_Federation_Execution_t* cthis) ;
void cer_M_Destroy_Federation_Execution_setFederationName(cer_M_Destroy_Federation_Execution_t* cthis,  char* newFederationName);
/* the show method */
FILE* M_Destroy_Federation_Execution_show(FILE* out);
/* ---------------------- END <M_Destroy_Federation_Execution> ------------------------ */

/* ---------------------- BEGIN <M_Join_Federation_Execution> ------------------------ */

typedef struct  cer_M_Join_Federation_Execution {
   Message super;
   cer_FederateHandle_t federate;
   char* federationName;
   char* federateName;
} cer_M_Join_Federation_Execution_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Join_Federation_Execution_t* cer_M_Join_Federation_Execution_create(uint32_t nb);
/* Destructor function */
void cer_M_Join_Federation_Execution_destroy(cer_M_Join_Federation_Execution_t** cthis);

/* Serialize function */
void cer_M_Join_Federation_Execution_serialize(cer_M_Join_Federation_Execution_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Join_Federation_Execution_deserialize(cer_M_Join_Federation_Execution_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_FederateHandle_t cer_M_Join_Federation_Execution_getFederate(cer_M_Join_Federation_Execution_t* cthis) ;
void cer_M_Join_Federation_Execution_setFederate(cer_M_Join_Federation_Execution_t* cthis,  cer_FederateHandle_t newFederate);
char* cer_M_Join_Federation_Execution_getFederationName(cer_M_Join_Federation_Execution_t* cthis) ;
void cer_M_Join_Federation_Execution_setFederationName(cer_M_Join_Federation_Execution_t* cthis,  char* newFederationName);
char* cer_M_Join_Federation_Execution_getFederateName(cer_M_Join_Federation_Execution_t* cthis) ;
void cer_M_Join_Federation_Execution_setFederateName(cer_M_Join_Federation_Execution_t* cthis,  char* newFederateName);
/* the show method */
FILE* M_Join_Federation_Execution_show(FILE* out);
/* ---------------------- END <M_Join_Federation_Execution> ------------------------ */

/* ---------------------- BEGIN <M_Resign_Federation_Execution> ------------------------ */

typedef struct  cer_M_Resign_Federation_Execution {
   Message super;
   cer_ResignAction_t resignAction;
} cer_M_Resign_Federation_Execution_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Resign_Federation_Execution_t* cer_M_Resign_Federation_Execution_create(uint32_t nb);
/* Destructor function */
void cer_M_Resign_Federation_Execution_destroy(cer_M_Resign_Federation_Execution_t** cthis);

/* Serialize function */
void cer_M_Resign_Federation_Execution_serialize(cer_M_Resign_Federation_Execution_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Resign_Federation_Execution_deserialize(cer_M_Resign_Federation_Execution_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ResignAction_t cer_M_Resign_Federation_Execution_getResignAction(cer_M_Resign_Federation_Execution_t* cthis) ;
void cer_M_Resign_Federation_Execution_setResignAction(cer_M_Resign_Federation_Execution_t* cthis,  cer_ResignAction_t newResignAction);
/* the show method */
FILE* M_Resign_Federation_Execution_show(FILE* out);
/* ---------------------- END <M_Resign_Federation_Execution> ------------------------ */

/* ---------------------- BEGIN <M_Register_Federation_Synchronization_Point> ------------------------ */

typedef struct  cer_M_Register_Federation_Synchronization_Point {
   Message super;
   cer_FederateHandle_t* federateSet;
   uint32_t federateSetSize;/*  the set of Federate which will participate to this sync point.
 */
} cer_M_Register_Federation_Synchronization_Point_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Register_Federation_Synchronization_Point_t* cer_M_Register_Federation_Synchronization_Point_create(uint32_t nb);
/* Destructor function */
void cer_M_Register_Federation_Synchronization_Point_destroy(cer_M_Register_Federation_Synchronization_Point_t** cthis);

/* Serialize function */
void cer_M_Register_Federation_Synchronization_Point_serialize(cer_M_Register_Federation_Synchronization_Point_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Register_Federation_Synchronization_Point_deserialize(cer_M_Register_Federation_Synchronization_Point_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
uint32_t cer_M_Register_Federation_Synchronization_Point_getFederateSetSize(cer_M_Register_Federation_Synchronization_Point_t* cthis);
void cer_M_Register_Federation_Synchronization_Point_setFederateSetSize(cer_M_Register_Federation_Synchronization_Point_t* cthis, uint32_t num);
cer_FederateHandle_t cer_M_Register_Federation_Synchronization_Point_getFederateSet(cer_M_Register_Federation_Synchronization_Point_t* cthis, uint32_t rank);
void cer_M_Register_Federation_Synchronization_Point_setFederateSet(cer_M_Register_Federation_Synchronization_Point_t* cthis, cer_FederateHandle_t newFederateSet, uint32_t rank);
/* the show method */
FILE* M_Register_Federation_Synchronization_Point_show(FILE* out);
/* ---------------------- END <M_Register_Federation_Synchronization_Point> ------------------------ */

/* ---------------------- BEGIN <M_Synchronization_Point_Registration_Failed> ------------------------ */

typedef struct  cer_M_Synchronization_Point_Registration_Failed {
   Message super;
} cer_M_Synchronization_Point_Registration_Failed_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Synchronization_Point_Registration_Failed_t* cer_M_Synchronization_Point_Registration_Failed_create(uint32_t nb);
/* Destructor function */
void cer_M_Synchronization_Point_Registration_Failed_destroy(cer_M_Synchronization_Point_Registration_Failed_t** cthis);

/* ---------------------- BEGIN <M_Synchronization_Point_Registration_Succeeded> ------------------------ */

typedef struct  cer_M_Synchronization_Point_Registration_Succeeded {
   Message super;
} cer_M_Synchronization_Point_Registration_Succeeded_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Synchronization_Point_Registration_Succeeded_t* cer_M_Synchronization_Point_Registration_Succeeded_create(uint32_t nb);
/* Destructor function */
void cer_M_Synchronization_Point_Registration_Succeeded_destroy(cer_M_Synchronization_Point_Registration_Succeeded_t** cthis);

/* ---------------------- BEGIN <M_Announce_Synchronization_Point> ------------------------ */

typedef struct  cer_M_Announce_Synchronization_Point {
   Message super;
} cer_M_Announce_Synchronization_Point_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Announce_Synchronization_Point_t* cer_M_Announce_Synchronization_Point_create(uint32_t nb);
/* Destructor function */
void cer_M_Announce_Synchronization_Point_destroy(cer_M_Announce_Synchronization_Point_t** cthis);

/* ---------------------- BEGIN <M_Synchronization_Point_Achieved> ------------------------ */

typedef struct  cer_M_Synchronization_Point_Achieved {
   Message super;
} cer_M_Synchronization_Point_Achieved_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Synchronization_Point_Achieved_t* cer_M_Synchronization_Point_Achieved_create(uint32_t nb);
/* Destructor function */
void cer_M_Synchronization_Point_Achieved_destroy(cer_M_Synchronization_Point_Achieved_t** cthis);

/* ---------------------- BEGIN <M_Federation_Synchronized> ------------------------ */

typedef struct  cer_M_Federation_Synchronized {
   Message super;
} cer_M_Federation_Synchronized_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Federation_Synchronized_t* cer_M_Federation_Synchronized_create(uint32_t nb);
/* Destructor function */
void cer_M_Federation_Synchronized_destroy(cer_M_Federation_Synchronized_t** cthis);

/* ---------------------- BEGIN <M_Request_Federation_Save> ------------------------ */

typedef struct  cer_M_Request_Federation_Save {
   Message super;
} cer_M_Request_Federation_Save_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Request_Federation_Save_t* cer_M_Request_Federation_Save_create(uint32_t nb);
/* Destructor function */
void cer_M_Request_Federation_Save_destroy(cer_M_Request_Federation_Save_t** cthis);

/* ---------------------- BEGIN <M_Initiate_Federate_Save> ------------------------ */

typedef struct  cer_M_Initiate_Federate_Save {
   Message super;
} cer_M_Initiate_Federate_Save_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Initiate_Federate_Save_t* cer_M_Initiate_Federate_Save_create(uint32_t nb);
/* Destructor function */
void cer_M_Initiate_Federate_Save_destroy(cer_M_Initiate_Federate_Save_t** cthis);

/* ---------------------- BEGIN <M_Federate_Save_Begun> ------------------------ */

typedef struct  cer_M_Federate_Save_Begun {
   Message super;
} cer_M_Federate_Save_Begun_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Federate_Save_Begun_t* cer_M_Federate_Save_Begun_create(uint32_t nb);
/* Destructor function */
void cer_M_Federate_Save_Begun_destroy(cer_M_Federate_Save_Begun_t** cthis);

/* ---------------------- BEGIN <M_Federate_Save_Complete> ------------------------ */

typedef struct  cer_M_Federate_Save_Complete {
   Message super;
} cer_M_Federate_Save_Complete_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Federate_Save_Complete_t* cer_M_Federate_Save_Complete_create(uint32_t nb);
/* Destructor function */
void cer_M_Federate_Save_Complete_destroy(cer_M_Federate_Save_Complete_t** cthis);

/* ---------------------- BEGIN <M_Federate_Save_Not_Complete> ------------------------ */

typedef struct  cer_M_Federate_Save_Not_Complete {
   Message super;
} cer_M_Federate_Save_Not_Complete_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Federate_Save_Not_Complete_t* cer_M_Federate_Save_Not_Complete_create(uint32_t nb);
/* Destructor function */
void cer_M_Federate_Save_Not_Complete_destroy(cer_M_Federate_Save_Not_Complete_t** cthis);

/* ---------------------- BEGIN <M_Federation_Saved> ------------------------ */

typedef struct  cer_M_Federation_Saved {
   Message super;
} cer_M_Federation_Saved_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Federation_Saved_t* cer_M_Federation_Saved_create(uint32_t nb);
/* Destructor function */
void cer_M_Federation_Saved_destroy(cer_M_Federation_Saved_t** cthis);

/* ---------------------- BEGIN <M_Federation_Not_Saved> ------------------------ */

typedef struct  cer_M_Federation_Not_Saved {
   Message super;
} cer_M_Federation_Not_Saved_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Federation_Not_Saved_t* cer_M_Federation_Not_Saved_create(uint32_t nb);
/* Destructor function */
void cer_M_Federation_Not_Saved_destroy(cer_M_Federation_Not_Saved_t** cthis);

/* ---------------------- BEGIN <M_Request_Federation_Restore> ------------------------ */

typedef struct  cer_M_Request_Federation_Restore {
   Message super;
} cer_M_Request_Federation_Restore_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Request_Federation_Restore_t* cer_M_Request_Federation_Restore_create(uint32_t nb);
/* Destructor function */
void cer_M_Request_Federation_Restore_destroy(cer_M_Request_Federation_Restore_t** cthis);

/* ---------------------- BEGIN <M_Request_Federation_Restore_Failed> ------------------------ */

typedef struct  cer_M_Request_Federation_Restore_Failed {
   Message super;
   char* reason;
} cer_M_Request_Federation_Restore_Failed_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Request_Federation_Restore_Failed_t* cer_M_Request_Federation_Restore_Failed_create(uint32_t nb);
/* Destructor function */
void cer_M_Request_Federation_Restore_Failed_destroy(cer_M_Request_Federation_Restore_Failed_t** cthis);

/* Serialize function */
void cer_M_Request_Federation_Restore_Failed_serialize(cer_M_Request_Federation_Restore_Failed_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Request_Federation_Restore_Failed_deserialize(cer_M_Request_Federation_Restore_Failed_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
char* cer_M_Request_Federation_Restore_Failed_getReason(cer_M_Request_Federation_Restore_Failed_t* cthis) ;
void cer_M_Request_Federation_Restore_Failed_setReason(cer_M_Request_Federation_Restore_Failed_t* cthis,  char* newReason);
/* the show method */
FILE* M_Request_Federation_Restore_Failed_show(FILE* out);
/* ---------------------- END <M_Request_Federation_Restore_Failed> ------------------------ */

/* ---------------------- BEGIN <M_Request_Federation_Restore_Succeeded> ------------------------ */

typedef struct  cer_M_Request_Federation_Restore_Succeeded {
   Message super;
} cer_M_Request_Federation_Restore_Succeeded_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Request_Federation_Restore_Succeeded_t* cer_M_Request_Federation_Restore_Succeeded_create(uint32_t nb);
/* Destructor function */
void cer_M_Request_Federation_Restore_Succeeded_destroy(cer_M_Request_Federation_Restore_Succeeded_t** cthis);

/* ---------------------- BEGIN <M_Initiate_Federate_Restore> ------------------------ */

typedef struct  cer_M_Initiate_Federate_Restore {
   Message super;
   cer_FederateHandle_t federate;
} cer_M_Initiate_Federate_Restore_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Initiate_Federate_Restore_t* cer_M_Initiate_Federate_Restore_create(uint32_t nb);
/* Destructor function */
void cer_M_Initiate_Federate_Restore_destroy(cer_M_Initiate_Federate_Restore_t** cthis);

/* Serialize function */
void cer_M_Initiate_Federate_Restore_serialize(cer_M_Initiate_Federate_Restore_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Initiate_Federate_Restore_deserialize(cer_M_Initiate_Federate_Restore_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_FederateHandle_t cer_M_Initiate_Federate_Restore_getFederate(cer_M_Initiate_Federate_Restore_t* cthis) ;
void cer_M_Initiate_Federate_Restore_setFederate(cer_M_Initiate_Federate_Restore_t* cthis,  cer_FederateHandle_t newFederate);
/* the show method */
FILE* M_Initiate_Federate_Restore_show(FILE* out);
/* ---------------------- END <M_Initiate_Federate_Restore> ------------------------ */

/* ---------------------- BEGIN <M_Federate_Restore_Complete> ------------------------ */

typedef struct  cer_M_Federate_Restore_Complete {
   Message super;
} cer_M_Federate_Restore_Complete_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Federate_Restore_Complete_t* cer_M_Federate_Restore_Complete_create(uint32_t nb);
/* Destructor function */
void cer_M_Federate_Restore_Complete_destroy(cer_M_Federate_Restore_Complete_t** cthis);

/* ---------------------- BEGIN <M_Federate_Restore_Not_Complete> ------------------------ */

typedef struct  cer_M_Federate_Restore_Not_Complete {
   Message super;
} cer_M_Federate_Restore_Not_Complete_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Federate_Restore_Not_Complete_t* cer_M_Federate_Restore_Not_Complete_create(uint32_t nb);
/* Destructor function */
void cer_M_Federate_Restore_Not_Complete_destroy(cer_M_Federate_Restore_Not_Complete_t** cthis);

/* ---------------------- BEGIN <M_Federation_Restored> ------------------------ */

typedef struct  cer_M_Federation_Restored {
   Message super;
} cer_M_Federation_Restored_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Federation_Restored_t* cer_M_Federation_Restored_create(uint32_t nb);
/* Destructor function */
void cer_M_Federation_Restored_destroy(cer_M_Federation_Restored_t** cthis);

/* ---------------------- BEGIN <M_Federation_Not_Restored> ------------------------ */

typedef struct  cer_M_Federation_Not_Restored {
   Message super;
} cer_M_Federation_Not_Restored_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Federation_Not_Restored_t* cer_M_Federation_Not_Restored_create(uint32_t nb);
/* Destructor function */
void cer_M_Federation_Not_Restored_destroy(cer_M_Federation_Not_Restored_t** cthis);

/* ---------------------- BEGIN <M_Federation_Restore_Begun> ------------------------ */

typedef struct  cer_M_Federation_Restore_Begun {
   Message super;
} cer_M_Federation_Restore_Begun_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Federation_Restore_Begun_t* cer_M_Federation_Restore_Begun_create(uint32_t nb);
/* Destructor function */
void cer_M_Federation_Restore_Begun_destroy(cer_M_Federation_Restore_Begun_t** cthis);

/* ---------------------- BEGIN <M_Publish_Object_Class> ------------------------ */
/*  Declaration
 */
typedef struct  cer_M_Publish_Object_Class {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Publish_Object_Class_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Publish_Object_Class_t* cer_M_Publish_Object_Class_create(uint32_t nb);
/* Destructor function */
void cer_M_Publish_Object_Class_destroy(cer_M_Publish_Object_Class_t** cthis);

/* Serialize function */
void cer_M_Publish_Object_Class_serialize(cer_M_Publish_Object_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Publish_Object_Class_deserialize(cer_M_Publish_Object_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Publish_Object_Class_getObjectClass(cer_M_Publish_Object_Class_t* cthis) ;
void cer_M_Publish_Object_Class_setObjectClass(cer_M_Publish_Object_Class_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
uint32_t cer_M_Publish_Object_Class_getAttributesSize(cer_M_Publish_Object_Class_t* cthis);
void cer_M_Publish_Object_Class_setAttributesSize(cer_M_Publish_Object_Class_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Publish_Object_Class_getAttributes(cer_M_Publish_Object_Class_t* cthis, uint32_t rank);
void cer_M_Publish_Object_Class_setAttributes(cer_M_Publish_Object_Class_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Publish_Object_Class_show(FILE* out);
/* ---------------------- END <M_Publish_Object_Class> ------------------------ */

/* ---------------------- BEGIN <M_Unpublish_Object_Class> ------------------------ */

typedef struct  cer_M_Unpublish_Object_Class {
   Message super;
   cer_ObjectClassHandle_t objectClass;
} cer_M_Unpublish_Object_Class_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Unpublish_Object_Class_t* cer_M_Unpublish_Object_Class_create(uint32_t nb);
/* Destructor function */
void cer_M_Unpublish_Object_Class_destroy(cer_M_Unpublish_Object_Class_t** cthis);

/* Serialize function */
void cer_M_Unpublish_Object_Class_serialize(cer_M_Unpublish_Object_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Unpublish_Object_Class_deserialize(cer_M_Unpublish_Object_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Unpublish_Object_Class_getObjectClass(cer_M_Unpublish_Object_Class_t* cthis) ;
void cer_M_Unpublish_Object_Class_setObjectClass(cer_M_Unpublish_Object_Class_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
/* the show method */
FILE* M_Unpublish_Object_Class_show(FILE* out);
/* ---------------------- END <M_Unpublish_Object_Class> ------------------------ */

/* ---------------------- BEGIN <M_Publish_Interaction_Class> ------------------------ */

typedef struct  cer_M_Publish_Interaction_Class {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
} cer_M_Publish_Interaction_Class_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Publish_Interaction_Class_t* cer_M_Publish_Interaction_Class_create(uint32_t nb);
/* Destructor function */
void cer_M_Publish_Interaction_Class_destroy(cer_M_Publish_Interaction_Class_t** cthis);

/* Serialize function */
void cer_M_Publish_Interaction_Class_serialize(cer_M_Publish_Interaction_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Publish_Interaction_Class_deserialize(cer_M_Publish_Interaction_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Publish_Interaction_Class_getInteractionClass(cer_M_Publish_Interaction_Class_t* cthis) ;
void cer_M_Publish_Interaction_Class_setInteractionClass(cer_M_Publish_Interaction_Class_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
/* the show method */
FILE* M_Publish_Interaction_Class_show(FILE* out);
/* ---------------------- END <M_Publish_Interaction_Class> ------------------------ */

/* ---------------------- BEGIN <M_Unpublish_Interaction_Class> ------------------------ */

typedef struct  cer_M_Unpublish_Interaction_Class {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
} cer_M_Unpublish_Interaction_Class_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Unpublish_Interaction_Class_t* cer_M_Unpublish_Interaction_Class_create(uint32_t nb);
/* Destructor function */
void cer_M_Unpublish_Interaction_Class_destroy(cer_M_Unpublish_Interaction_Class_t** cthis);

/* Serialize function */
void cer_M_Unpublish_Interaction_Class_serialize(cer_M_Unpublish_Interaction_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Unpublish_Interaction_Class_deserialize(cer_M_Unpublish_Interaction_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Unpublish_Interaction_Class_getInteractionClass(cer_M_Unpublish_Interaction_Class_t* cthis) ;
void cer_M_Unpublish_Interaction_Class_setInteractionClass(cer_M_Unpublish_Interaction_Class_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
/* the show method */
FILE* M_Unpublish_Interaction_Class_show(FILE* out);
/* ---------------------- END <M_Unpublish_Interaction_Class> ------------------------ */

/* ---------------------- BEGIN <M_Subscribe_Object_Class_Attributes> ------------------------ */

typedef struct  cer_M_Subscribe_Object_Class_Attributes {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
   uint8_t active;
} cer_M_Subscribe_Object_Class_Attributes_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Subscribe_Object_Class_Attributes_t* cer_M_Subscribe_Object_Class_Attributes_create(uint32_t nb);
/* Destructor function */
void cer_M_Subscribe_Object_Class_Attributes_destroy(cer_M_Subscribe_Object_Class_Attributes_t** cthis);

/* Serialize function */
void cer_M_Subscribe_Object_Class_Attributes_serialize(cer_M_Subscribe_Object_Class_Attributes_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Subscribe_Object_Class_Attributes_deserialize(cer_M_Subscribe_Object_Class_Attributes_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Subscribe_Object_Class_Attributes_getObjectClass(cer_M_Subscribe_Object_Class_Attributes_t* cthis) ;
void cer_M_Subscribe_Object_Class_Attributes_setObjectClass(cer_M_Subscribe_Object_Class_Attributes_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
uint32_t cer_M_Subscribe_Object_Class_Attributes_getAttributesSize(cer_M_Subscribe_Object_Class_Attributes_t* cthis);
void cer_M_Subscribe_Object_Class_Attributes_setAttributesSize(cer_M_Subscribe_Object_Class_Attributes_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Subscribe_Object_Class_Attributes_getAttributes(cer_M_Subscribe_Object_Class_Attributes_t* cthis, uint32_t rank);
void cer_M_Subscribe_Object_Class_Attributes_setAttributes(cer_M_Subscribe_Object_Class_Attributes_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
uint8_t cer_M_Subscribe_Object_Class_Attributes_getActive(cer_M_Subscribe_Object_Class_Attributes_t* cthis) ;
void cer_M_Subscribe_Object_Class_Attributes_setActive(cer_M_Subscribe_Object_Class_Attributes_t* cthis,  uint8_t newActive);
/* the show method */
FILE* M_Subscribe_Object_Class_Attributes_show(FILE* out);
/* ---------------------- END <M_Subscribe_Object_Class_Attributes> ------------------------ */

/* ---------------------- BEGIN <M_Unsubscribe_Object_Class> ------------------------ */

typedef struct  cer_M_Unsubscribe_Object_Class {
   Message super;
   cer_ObjectClassHandle_t objectClass;
} cer_M_Unsubscribe_Object_Class_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Unsubscribe_Object_Class_t* cer_M_Unsubscribe_Object_Class_create(uint32_t nb);
/* Destructor function */
void cer_M_Unsubscribe_Object_Class_destroy(cer_M_Unsubscribe_Object_Class_t** cthis);

/* Serialize function */
void cer_M_Unsubscribe_Object_Class_serialize(cer_M_Unsubscribe_Object_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Unsubscribe_Object_Class_deserialize(cer_M_Unsubscribe_Object_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Unsubscribe_Object_Class_getObjectClass(cer_M_Unsubscribe_Object_Class_t* cthis) ;
void cer_M_Unsubscribe_Object_Class_setObjectClass(cer_M_Unsubscribe_Object_Class_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
/* the show method */
FILE* M_Unsubscribe_Object_Class_show(FILE* out);
/* ---------------------- END <M_Unsubscribe_Object_Class> ------------------------ */

/* ---------------------- BEGIN <M_Subscribe_Interaction_Class> ------------------------ */

typedef struct  cer_M_Subscribe_Interaction_Class {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
} cer_M_Subscribe_Interaction_Class_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Subscribe_Interaction_Class_t* cer_M_Subscribe_Interaction_Class_create(uint32_t nb);
/* Destructor function */
void cer_M_Subscribe_Interaction_Class_destroy(cer_M_Subscribe_Interaction_Class_t** cthis);

/* Serialize function */
void cer_M_Subscribe_Interaction_Class_serialize(cer_M_Subscribe_Interaction_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Subscribe_Interaction_Class_deserialize(cer_M_Subscribe_Interaction_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Subscribe_Interaction_Class_getInteractionClass(cer_M_Subscribe_Interaction_Class_t* cthis) ;
void cer_M_Subscribe_Interaction_Class_setInteractionClass(cer_M_Subscribe_Interaction_Class_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
/* the show method */
FILE* M_Subscribe_Interaction_Class_show(FILE* out);
/* ---------------------- END <M_Subscribe_Interaction_Class> ------------------------ */

/* ---------------------- BEGIN <M_Unsubscribe_Interaction_Class> ------------------------ */

typedef struct  cer_M_Unsubscribe_Interaction_Class {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
} cer_M_Unsubscribe_Interaction_Class_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Unsubscribe_Interaction_Class_t* cer_M_Unsubscribe_Interaction_Class_create(uint32_t nb);
/* Destructor function */
void cer_M_Unsubscribe_Interaction_Class_destroy(cer_M_Unsubscribe_Interaction_Class_t** cthis);

/* Serialize function */
void cer_M_Unsubscribe_Interaction_Class_serialize(cer_M_Unsubscribe_Interaction_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Unsubscribe_Interaction_Class_deserialize(cer_M_Unsubscribe_Interaction_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Unsubscribe_Interaction_Class_getInteractionClass(cer_M_Unsubscribe_Interaction_Class_t* cthis) ;
void cer_M_Unsubscribe_Interaction_Class_setInteractionClass(cer_M_Unsubscribe_Interaction_Class_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
/* the show method */
FILE* M_Unsubscribe_Interaction_Class_show(FILE* out);
/* ---------------------- END <M_Unsubscribe_Interaction_Class> ------------------------ */

/* ---------------------- BEGIN <M_Start_Registration_For_Object_Class> ------------------------ */

typedef struct  cer_M_Start_Registration_For_Object_Class {
   Message super;
   cer_ObjectClassHandle_t objectClass;
} cer_M_Start_Registration_For_Object_Class_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Start_Registration_For_Object_Class_t* cer_M_Start_Registration_For_Object_Class_create(uint32_t nb);
/* Destructor function */
void cer_M_Start_Registration_For_Object_Class_destroy(cer_M_Start_Registration_For_Object_Class_t** cthis);

/* Serialize function */
void cer_M_Start_Registration_For_Object_Class_serialize(cer_M_Start_Registration_For_Object_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Start_Registration_For_Object_Class_deserialize(cer_M_Start_Registration_For_Object_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Start_Registration_For_Object_Class_getObjectClass(cer_M_Start_Registration_For_Object_Class_t* cthis) ;
void cer_M_Start_Registration_For_Object_Class_setObjectClass(cer_M_Start_Registration_For_Object_Class_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
/* the show method */
FILE* M_Start_Registration_For_Object_Class_show(FILE* out);
/* ---------------------- END <M_Start_Registration_For_Object_Class> ------------------------ */

/* ---------------------- BEGIN <M_Stop_Registration_For_Object_Class> ------------------------ */

typedef struct  cer_M_Stop_Registration_For_Object_Class {
   Message super;
   cer_ObjectClassHandle_t objectClass;
} cer_M_Stop_Registration_For_Object_Class_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Stop_Registration_For_Object_Class_t* cer_M_Stop_Registration_For_Object_Class_create(uint32_t nb);
/* Destructor function */
void cer_M_Stop_Registration_For_Object_Class_destroy(cer_M_Stop_Registration_For_Object_Class_t** cthis);

/* Serialize function */
void cer_M_Stop_Registration_For_Object_Class_serialize(cer_M_Stop_Registration_For_Object_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Stop_Registration_For_Object_Class_deserialize(cer_M_Stop_Registration_For_Object_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Stop_Registration_For_Object_Class_getObjectClass(cer_M_Stop_Registration_For_Object_Class_t* cthis) ;
void cer_M_Stop_Registration_For_Object_Class_setObjectClass(cer_M_Stop_Registration_For_Object_Class_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
/* the show method */
FILE* M_Stop_Registration_For_Object_Class_show(FILE* out);
/* ---------------------- END <M_Stop_Registration_For_Object_Class> ------------------------ */

/* ---------------------- BEGIN <M_Turn_Interactions_On> ------------------------ */

typedef struct  cer_M_Turn_Interactions_On {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
} cer_M_Turn_Interactions_On_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Turn_Interactions_On_t* cer_M_Turn_Interactions_On_create(uint32_t nb);
/* Destructor function */
void cer_M_Turn_Interactions_On_destroy(cer_M_Turn_Interactions_On_t** cthis);

/* Serialize function */
void cer_M_Turn_Interactions_On_serialize(cer_M_Turn_Interactions_On_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Turn_Interactions_On_deserialize(cer_M_Turn_Interactions_On_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Turn_Interactions_On_getInteractionClass(cer_M_Turn_Interactions_On_t* cthis) ;
void cer_M_Turn_Interactions_On_setInteractionClass(cer_M_Turn_Interactions_On_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
/* the show method */
FILE* M_Turn_Interactions_On_show(FILE* out);
/* ---------------------- END <M_Turn_Interactions_On> ------------------------ */

/* ---------------------- BEGIN <M_Turn_Interactions_Off> ------------------------ */

typedef struct  cer_M_Turn_Interactions_Off {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
} cer_M_Turn_Interactions_Off_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Turn_Interactions_Off_t* cer_M_Turn_Interactions_Off_create(uint32_t nb);
/* Destructor function */
void cer_M_Turn_Interactions_Off_destroy(cer_M_Turn_Interactions_Off_t** cthis);

/* Serialize function */
void cer_M_Turn_Interactions_Off_serialize(cer_M_Turn_Interactions_Off_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Turn_Interactions_Off_deserialize(cer_M_Turn_Interactions_Off_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Turn_Interactions_Off_getInteractionClass(cer_M_Turn_Interactions_Off_t* cthis) ;
void cer_M_Turn_Interactions_Off_setInteractionClass(cer_M_Turn_Interactions_Off_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
/* the show method */
FILE* M_Turn_Interactions_Off_show(FILE* out);
/* ---------------------- END <M_Turn_Interactions_Off> ------------------------ */

/* ---------------------- BEGIN <M_Register_Object_Instance> ------------------------ */
/*  Object
 */
typedef struct  cer_M_Register_Object_Instance {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   cer_ObjectHandle_t object;
   char* objectName;
   uint8_t _hasObjectName;
} cer_M_Register_Object_Instance_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Register_Object_Instance_t* cer_M_Register_Object_Instance_create(uint32_t nb);
/* Destructor function */
void cer_M_Register_Object_Instance_destroy(cer_M_Register_Object_Instance_t** cthis);

/* Serialize function */
void cer_M_Register_Object_Instance_serialize(cer_M_Register_Object_Instance_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Register_Object_Instance_deserialize(cer_M_Register_Object_Instance_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Register_Object_Instance_getObjectClass(cer_M_Register_Object_Instance_t* cthis) ;
void cer_M_Register_Object_Instance_setObjectClass(cer_M_Register_Object_Instance_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
cer_ObjectHandle_t cer_M_Register_Object_Instance_getObject(cer_M_Register_Object_Instance_t* cthis) ;
void cer_M_Register_Object_Instance_setObject(cer_M_Register_Object_Instance_t* cthis,  cer_ObjectHandle_t newObject);
char* cer_M_Register_Object_Instance_getObjectName(cer_M_Register_Object_Instance_t* cthis) ;
void cer_M_Register_Object_Instance_setObjectName(cer_M_Register_Object_Instance_t* cthis,  char* newObjectName);
uint8_t hasObjectName(cer_M_Register_Object_Instance_t cthis);
/* the show method */
FILE* M_Register_Object_Instance_show(FILE* out);
/* ---------------------- END <M_Register_Object_Instance> ------------------------ */

/* ---------------------- BEGIN <M_Update_Attribute_Values> ------------------------ */

typedef struct  cer_M_Update_Attribute_Values {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
   cer_AttributeValue_t_t* values;
   uint32_t valuesSize;
   cer_EventRetraction_t eventRetraction;
   uint8_t _hasEventRetraction;
} cer_M_Update_Attribute_Values_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Update_Attribute_Values_t* cer_M_Update_Attribute_Values_create(uint32_t nb);
/* Destructor function */
void cer_M_Update_Attribute_Values_destroy(cer_M_Update_Attribute_Values_t** cthis);

/* Serialize function */
void cer_M_Update_Attribute_Values_serialize(cer_M_Update_Attribute_Values_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Update_Attribute_Values_deserialize(cer_M_Update_Attribute_Values_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Update_Attribute_Values_getObjectClass(cer_M_Update_Attribute_Values_t* cthis) ;
void cer_M_Update_Attribute_Values_setObjectClass(cer_M_Update_Attribute_Values_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
cer_ObjectHandle_t cer_M_Update_Attribute_Values_getObject(cer_M_Update_Attribute_Values_t* cthis) ;
void cer_M_Update_Attribute_Values_setObject(cer_M_Update_Attribute_Values_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Update_Attribute_Values_getAttributesSize(cer_M_Update_Attribute_Values_t* cthis);
void cer_M_Update_Attribute_Values_setAttributesSize(cer_M_Update_Attribute_Values_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Update_Attribute_Values_getAttributes(cer_M_Update_Attribute_Values_t* cthis, uint32_t rank);
void cer_M_Update_Attribute_Values_setAttributes(cer_M_Update_Attribute_Values_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
uint32_t cer_M_Update_Attribute_Values_getValuesSize(cer_M_Update_Attribute_Values_t* cthis);
void cer_M_Update_Attribute_Values_setValuesSize(cer_M_Update_Attribute_Values_t* cthis, uint32_t num);
cer_AttributeValue_t_t cer_M_Update_Attribute_Values_getValues(cer_M_Update_Attribute_Values_t* cthis, uint32_t rank);
void cer_M_Update_Attribute_Values_setValues(cer_M_Update_Attribute_Values_t* cthis, cer_AttributeValue_t_t newValues, uint32_t rank);
cer_EventRetraction_t cer_M_Update_Attribute_Values_getEventRetraction(cer_M_Update_Attribute_Values_t* cthis) ;
void cer_M_Update_Attribute_Values_setEventRetraction(cer_M_Update_Attribute_Values_t* cthis,  cer_EventRetraction_t newEventRetraction);
uint8_t hasEventRetraction(cer_M_Update_Attribute_Values_t cthis);
/* the show method */
FILE* M_Update_Attribute_Values_show(FILE* out);
/* ---------------------- END <M_Update_Attribute_Values> ------------------------ */

/* ---------------------- BEGIN <M_Discover_Object_Instance> ------------------------ */

typedef struct  cer_M_Discover_Object_Instance {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   cer_ObjectHandle_t object;
   char* objectName;
   cer_EventRetraction_t eventRetraction;
   uint8_t _hasEventRetraction;
} cer_M_Discover_Object_Instance_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Discover_Object_Instance_t* cer_M_Discover_Object_Instance_create(uint32_t nb);
/* Destructor function */
void cer_M_Discover_Object_Instance_destroy(cer_M_Discover_Object_Instance_t** cthis);

/* Serialize function */
void cer_M_Discover_Object_Instance_serialize(cer_M_Discover_Object_Instance_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Discover_Object_Instance_deserialize(cer_M_Discover_Object_Instance_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Discover_Object_Instance_getObjectClass(cer_M_Discover_Object_Instance_t* cthis) ;
void cer_M_Discover_Object_Instance_setObjectClass(cer_M_Discover_Object_Instance_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
cer_ObjectHandle_t cer_M_Discover_Object_Instance_getObject(cer_M_Discover_Object_Instance_t* cthis) ;
void cer_M_Discover_Object_Instance_setObject(cer_M_Discover_Object_Instance_t* cthis,  cer_ObjectHandle_t newObject);
char* cer_M_Discover_Object_Instance_getObjectName(cer_M_Discover_Object_Instance_t* cthis) ;
void cer_M_Discover_Object_Instance_setObjectName(cer_M_Discover_Object_Instance_t* cthis,  char* newObjectName);
cer_EventRetraction_t cer_M_Discover_Object_Instance_getEventRetraction(cer_M_Discover_Object_Instance_t* cthis) ;
void cer_M_Discover_Object_Instance_setEventRetraction(cer_M_Discover_Object_Instance_t* cthis,  cer_EventRetraction_t newEventRetraction);
uint8_t hasEventRetraction(cer_M_Discover_Object_Instance_t cthis);
/* the show method */
FILE* M_Discover_Object_Instance_show(FILE* out);
/* ---------------------- END <M_Discover_Object_Instance> ------------------------ */

/* ---------------------- BEGIN <M_Reflect_Attribute_Values> ------------------------ */

typedef struct  cer_M_Reflect_Attribute_Values {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
   cer_AttributeValue_t_t* values;
   uint32_t valuesSize;
   cer_EventRetraction_t eventRetraction;
   uint8_t _hasEventRetraction;
} cer_M_Reflect_Attribute_Values_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Reflect_Attribute_Values_t* cer_M_Reflect_Attribute_Values_create(uint32_t nb);
/* Destructor function */
void cer_M_Reflect_Attribute_Values_destroy(cer_M_Reflect_Attribute_Values_t** cthis);

/* Serialize function */
void cer_M_Reflect_Attribute_Values_serialize(cer_M_Reflect_Attribute_Values_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Reflect_Attribute_Values_deserialize(cer_M_Reflect_Attribute_Values_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Reflect_Attribute_Values_getObjectClass(cer_M_Reflect_Attribute_Values_t* cthis) ;
void cer_M_Reflect_Attribute_Values_setObjectClass(cer_M_Reflect_Attribute_Values_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
cer_ObjectHandle_t cer_M_Reflect_Attribute_Values_getObject(cer_M_Reflect_Attribute_Values_t* cthis) ;
void cer_M_Reflect_Attribute_Values_setObject(cer_M_Reflect_Attribute_Values_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Reflect_Attribute_Values_getAttributesSize(cer_M_Reflect_Attribute_Values_t* cthis);
void cer_M_Reflect_Attribute_Values_setAttributesSize(cer_M_Reflect_Attribute_Values_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Reflect_Attribute_Values_getAttributes(cer_M_Reflect_Attribute_Values_t* cthis, uint32_t rank);
void cer_M_Reflect_Attribute_Values_setAttributes(cer_M_Reflect_Attribute_Values_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
uint32_t cer_M_Reflect_Attribute_Values_getValuesSize(cer_M_Reflect_Attribute_Values_t* cthis);
void cer_M_Reflect_Attribute_Values_setValuesSize(cer_M_Reflect_Attribute_Values_t* cthis, uint32_t num);
cer_AttributeValue_t_t cer_M_Reflect_Attribute_Values_getValues(cer_M_Reflect_Attribute_Values_t* cthis, uint32_t rank);
void cer_M_Reflect_Attribute_Values_setValues(cer_M_Reflect_Attribute_Values_t* cthis, cer_AttributeValue_t_t newValues, uint32_t rank);
cer_EventRetraction_t cer_M_Reflect_Attribute_Values_getEventRetraction(cer_M_Reflect_Attribute_Values_t* cthis) ;
void cer_M_Reflect_Attribute_Values_setEventRetraction(cer_M_Reflect_Attribute_Values_t* cthis,  cer_EventRetraction_t newEventRetraction);
uint8_t hasEventRetraction(cer_M_Reflect_Attribute_Values_t cthis);
/* the show method */
FILE* M_Reflect_Attribute_Values_show(FILE* out);
/* ---------------------- END <M_Reflect_Attribute_Values> ------------------------ */

/* ---------------------- BEGIN <M_Send_Interaction> ------------------------ */

typedef struct  cer_M_Send_Interaction {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
   cer_ParameterHandle_t* parameters;
   uint32_t parametersSize;
   cer_ParameterValue_t_t* values;
   uint32_t valuesSize;
   cer_RegionHandle_t region;
   cer_EventRetraction_t eventRetraction;
   uint8_t _hasEventRetraction;
} cer_M_Send_Interaction_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Send_Interaction_t* cer_M_Send_Interaction_create(uint32_t nb);
/* Destructor function */
void cer_M_Send_Interaction_destroy(cer_M_Send_Interaction_t** cthis);

/* Serialize function */
void cer_M_Send_Interaction_serialize(cer_M_Send_Interaction_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Send_Interaction_deserialize(cer_M_Send_Interaction_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Send_Interaction_getInteractionClass(cer_M_Send_Interaction_t* cthis) ;
void cer_M_Send_Interaction_setInteractionClass(cer_M_Send_Interaction_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
uint32_t cer_M_Send_Interaction_getParametersSize(cer_M_Send_Interaction_t* cthis);
void cer_M_Send_Interaction_setParametersSize(cer_M_Send_Interaction_t* cthis, uint32_t num);
cer_ParameterHandle_t cer_M_Send_Interaction_getParameters(cer_M_Send_Interaction_t* cthis, uint32_t rank);
void cer_M_Send_Interaction_setParameters(cer_M_Send_Interaction_t* cthis, cer_ParameterHandle_t newParameters, uint32_t rank);
uint32_t cer_M_Send_Interaction_getValuesSize(cer_M_Send_Interaction_t* cthis);
void cer_M_Send_Interaction_setValuesSize(cer_M_Send_Interaction_t* cthis, uint32_t num);
cer_ParameterValue_t_t cer_M_Send_Interaction_getValues(cer_M_Send_Interaction_t* cthis, uint32_t rank);
void cer_M_Send_Interaction_setValues(cer_M_Send_Interaction_t* cthis, cer_ParameterValue_t_t newValues, uint32_t rank);
cer_RegionHandle_t cer_M_Send_Interaction_getRegion(cer_M_Send_Interaction_t* cthis) ;
void cer_M_Send_Interaction_setRegion(cer_M_Send_Interaction_t* cthis,  cer_RegionHandle_t newRegion);
cer_EventRetraction_t cer_M_Send_Interaction_getEventRetraction(cer_M_Send_Interaction_t* cthis) ;
void cer_M_Send_Interaction_setEventRetraction(cer_M_Send_Interaction_t* cthis,  cer_EventRetraction_t newEventRetraction);
uint8_t hasEventRetraction(cer_M_Send_Interaction_t cthis);
/* the show method */
FILE* M_Send_Interaction_show(FILE* out);
/* ---------------------- END <M_Send_Interaction> ------------------------ */

/* ---------------------- BEGIN <M_Receive_Interaction> ------------------------ */

typedef struct  cer_M_Receive_Interaction {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
   cer_ParameterHandle_t* parameters;
   uint32_t parametersSize;
   cer_ParameterValue_t_t* values;
   uint32_t valuesSize;
   cer_RegionHandle_t region;
   cer_EventRetraction_t eventRetraction;
   uint8_t _hasEventRetraction;
} cer_M_Receive_Interaction_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Receive_Interaction_t* cer_M_Receive_Interaction_create(uint32_t nb);
/* Destructor function */
void cer_M_Receive_Interaction_destroy(cer_M_Receive_Interaction_t** cthis);

/* Serialize function */
void cer_M_Receive_Interaction_serialize(cer_M_Receive_Interaction_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Receive_Interaction_deserialize(cer_M_Receive_Interaction_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Receive_Interaction_getInteractionClass(cer_M_Receive_Interaction_t* cthis) ;
void cer_M_Receive_Interaction_setInteractionClass(cer_M_Receive_Interaction_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
uint32_t cer_M_Receive_Interaction_getParametersSize(cer_M_Receive_Interaction_t* cthis);
void cer_M_Receive_Interaction_setParametersSize(cer_M_Receive_Interaction_t* cthis, uint32_t num);
cer_ParameterHandle_t cer_M_Receive_Interaction_getParameters(cer_M_Receive_Interaction_t* cthis, uint32_t rank);
void cer_M_Receive_Interaction_setParameters(cer_M_Receive_Interaction_t* cthis, cer_ParameterHandle_t newParameters, uint32_t rank);
uint32_t cer_M_Receive_Interaction_getValuesSize(cer_M_Receive_Interaction_t* cthis);
void cer_M_Receive_Interaction_setValuesSize(cer_M_Receive_Interaction_t* cthis, uint32_t num);
cer_ParameterValue_t_t cer_M_Receive_Interaction_getValues(cer_M_Receive_Interaction_t* cthis, uint32_t rank);
void cer_M_Receive_Interaction_setValues(cer_M_Receive_Interaction_t* cthis, cer_ParameterValue_t_t newValues, uint32_t rank);
cer_RegionHandle_t cer_M_Receive_Interaction_getRegion(cer_M_Receive_Interaction_t* cthis) ;
void cer_M_Receive_Interaction_setRegion(cer_M_Receive_Interaction_t* cthis,  cer_RegionHandle_t newRegion);
cer_EventRetraction_t cer_M_Receive_Interaction_getEventRetraction(cer_M_Receive_Interaction_t* cthis) ;
void cer_M_Receive_Interaction_setEventRetraction(cer_M_Receive_Interaction_t* cthis,  cer_EventRetraction_t newEventRetraction);
uint8_t hasEventRetraction(cer_M_Receive_Interaction_t cthis);
/* the show method */
FILE* M_Receive_Interaction_show(FILE* out);
/* ---------------------- END <M_Receive_Interaction> ------------------------ */

/* ---------------------- BEGIN <M_Delete_Object_Instance> ------------------------ */

typedef struct  cer_M_Delete_Object_Instance {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   cer_ObjectHandle_t object;
   char* objectName;
   cer_EventRetraction_t eventRetraction;
   uint8_t _hasEventRetraction;
} cer_M_Delete_Object_Instance_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Delete_Object_Instance_t* cer_M_Delete_Object_Instance_create(uint32_t nb);
/* Destructor function */
void cer_M_Delete_Object_Instance_destroy(cer_M_Delete_Object_Instance_t** cthis);

/* Serialize function */
void cer_M_Delete_Object_Instance_serialize(cer_M_Delete_Object_Instance_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Delete_Object_Instance_deserialize(cer_M_Delete_Object_Instance_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Delete_Object_Instance_getObjectClass(cer_M_Delete_Object_Instance_t* cthis) ;
void cer_M_Delete_Object_Instance_setObjectClass(cer_M_Delete_Object_Instance_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
cer_ObjectHandle_t cer_M_Delete_Object_Instance_getObject(cer_M_Delete_Object_Instance_t* cthis) ;
void cer_M_Delete_Object_Instance_setObject(cer_M_Delete_Object_Instance_t* cthis,  cer_ObjectHandle_t newObject);
char* cer_M_Delete_Object_Instance_getObjectName(cer_M_Delete_Object_Instance_t* cthis) ;
void cer_M_Delete_Object_Instance_setObjectName(cer_M_Delete_Object_Instance_t* cthis,  char* newObjectName);
cer_EventRetraction_t cer_M_Delete_Object_Instance_getEventRetraction(cer_M_Delete_Object_Instance_t* cthis) ;
void cer_M_Delete_Object_Instance_setEventRetraction(cer_M_Delete_Object_Instance_t* cthis,  cer_EventRetraction_t newEventRetraction);
uint8_t hasEventRetraction(cer_M_Delete_Object_Instance_t cthis);
/* the show method */
FILE* M_Delete_Object_Instance_show(FILE* out);
/* ---------------------- END <M_Delete_Object_Instance> ------------------------ */

/* ---------------------- BEGIN <M_Local_Delete_Object_Instance> ------------------------ */

typedef struct  cer_M_Local_Delete_Object_Instance {
   Message super;
   cer_ObjectHandle_t object;
} cer_M_Local_Delete_Object_Instance_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Local_Delete_Object_Instance_t* cer_M_Local_Delete_Object_Instance_create(uint32_t nb);
/* Destructor function */
void cer_M_Local_Delete_Object_Instance_destroy(cer_M_Local_Delete_Object_Instance_t** cthis);

/* Serialize function */
void cer_M_Local_Delete_Object_Instance_serialize(cer_M_Local_Delete_Object_Instance_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Local_Delete_Object_Instance_deserialize(cer_M_Local_Delete_Object_Instance_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Local_Delete_Object_Instance_getObject(cer_M_Local_Delete_Object_Instance_t* cthis) ;
void cer_M_Local_Delete_Object_Instance_setObject(cer_M_Local_Delete_Object_Instance_t* cthis,  cer_ObjectHandle_t newObject);
/* the show method */
FILE* M_Local_Delete_Object_Instance_show(FILE* out);
/* ---------------------- END <M_Local_Delete_Object_Instance> ------------------------ */

/* ---------------------- BEGIN <M_Remove_Object_Instance> ------------------------ */

typedef struct  cer_M_Remove_Object_Instance {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   cer_ObjectHandle_t object;
   char* objectName;
   cer_EventRetraction_t eventRetraction;
   uint8_t _hasEventRetraction;
} cer_M_Remove_Object_Instance_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Remove_Object_Instance_t* cer_M_Remove_Object_Instance_create(uint32_t nb);
/* Destructor function */
void cer_M_Remove_Object_Instance_destroy(cer_M_Remove_Object_Instance_t** cthis);

/* Serialize function */
void cer_M_Remove_Object_Instance_serialize(cer_M_Remove_Object_Instance_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Remove_Object_Instance_deserialize(cer_M_Remove_Object_Instance_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Remove_Object_Instance_getObjectClass(cer_M_Remove_Object_Instance_t* cthis) ;
void cer_M_Remove_Object_Instance_setObjectClass(cer_M_Remove_Object_Instance_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
cer_ObjectHandle_t cer_M_Remove_Object_Instance_getObject(cer_M_Remove_Object_Instance_t* cthis) ;
void cer_M_Remove_Object_Instance_setObject(cer_M_Remove_Object_Instance_t* cthis,  cer_ObjectHandle_t newObject);
char* cer_M_Remove_Object_Instance_getObjectName(cer_M_Remove_Object_Instance_t* cthis) ;
void cer_M_Remove_Object_Instance_setObjectName(cer_M_Remove_Object_Instance_t* cthis,  char* newObjectName);
cer_EventRetraction_t cer_M_Remove_Object_Instance_getEventRetraction(cer_M_Remove_Object_Instance_t* cthis) ;
void cer_M_Remove_Object_Instance_setEventRetraction(cer_M_Remove_Object_Instance_t* cthis,  cer_EventRetraction_t newEventRetraction);
uint8_t hasEventRetraction(cer_M_Remove_Object_Instance_t cthis);
/* the show method */
FILE* M_Remove_Object_Instance_show(FILE* out);
/* ---------------------- END <M_Remove_Object_Instance> ------------------------ */

/* ---------------------- BEGIN <M_Change_Attribute_Transportation_Type> ------------------------ */

typedef struct  cer_M_Change_Attribute_Transportation_Type {
   Message super;
   cer_TransportType_t transportationType;
   cer_OrderType_t orderType;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Change_Attribute_Transportation_Type_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Change_Attribute_Transportation_Type_t* cer_M_Change_Attribute_Transportation_Type_create(uint32_t nb);
/* Destructor function */
void cer_M_Change_Attribute_Transportation_Type_destroy(cer_M_Change_Attribute_Transportation_Type_t** cthis);

/* Serialize function */
void cer_M_Change_Attribute_Transportation_Type_serialize(cer_M_Change_Attribute_Transportation_Type_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Change_Attribute_Transportation_Type_deserialize(cer_M_Change_Attribute_Transportation_Type_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_TransportType_t cer_M_Change_Attribute_Transportation_Type_getTransportationType(cer_M_Change_Attribute_Transportation_Type_t* cthis) ;
void cer_M_Change_Attribute_Transportation_Type_setTransportationType(cer_M_Change_Attribute_Transportation_Type_t* cthis,  cer_TransportType_t newTransportationType);
cer_OrderType_t cer_M_Change_Attribute_Transportation_Type_getOrderType(cer_M_Change_Attribute_Transportation_Type_t* cthis) ;
void cer_M_Change_Attribute_Transportation_Type_setOrderType(cer_M_Change_Attribute_Transportation_Type_t* cthis,  cer_OrderType_t newOrderType);
cer_ObjectHandle_t cer_M_Change_Attribute_Transportation_Type_getObject(cer_M_Change_Attribute_Transportation_Type_t* cthis) ;
void cer_M_Change_Attribute_Transportation_Type_setObject(cer_M_Change_Attribute_Transportation_Type_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Change_Attribute_Transportation_Type_getAttributesSize(cer_M_Change_Attribute_Transportation_Type_t* cthis);
void cer_M_Change_Attribute_Transportation_Type_setAttributesSize(cer_M_Change_Attribute_Transportation_Type_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Change_Attribute_Transportation_Type_getAttributes(cer_M_Change_Attribute_Transportation_Type_t* cthis, uint32_t rank);
void cer_M_Change_Attribute_Transportation_Type_setAttributes(cer_M_Change_Attribute_Transportation_Type_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Change_Attribute_Transportation_Type_show(FILE* out);
/* ---------------------- END <M_Change_Attribute_Transportation_Type> ------------------------ */

/* ---------------------- BEGIN <M_Change_Interaction_Transportation_Type> ------------------------ */

typedef struct  cer_M_Change_Interaction_Transportation_Type {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
   cer_TransportType_t transportationType;
   cer_OrderType_t orderType;
} cer_M_Change_Interaction_Transportation_Type_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Change_Interaction_Transportation_Type_t* cer_M_Change_Interaction_Transportation_Type_create(uint32_t nb);
/* Destructor function */
void cer_M_Change_Interaction_Transportation_Type_destroy(cer_M_Change_Interaction_Transportation_Type_t** cthis);

/* Serialize function */
void cer_M_Change_Interaction_Transportation_Type_serialize(cer_M_Change_Interaction_Transportation_Type_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Change_Interaction_Transportation_Type_deserialize(cer_M_Change_Interaction_Transportation_Type_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Change_Interaction_Transportation_Type_getInteractionClass(cer_M_Change_Interaction_Transportation_Type_t* cthis) ;
void cer_M_Change_Interaction_Transportation_Type_setInteractionClass(cer_M_Change_Interaction_Transportation_Type_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
cer_TransportType_t cer_M_Change_Interaction_Transportation_Type_getTransportationType(cer_M_Change_Interaction_Transportation_Type_t* cthis) ;
void cer_M_Change_Interaction_Transportation_Type_setTransportationType(cer_M_Change_Interaction_Transportation_Type_t* cthis,  cer_TransportType_t newTransportationType);
cer_OrderType_t cer_M_Change_Interaction_Transportation_Type_getOrderType(cer_M_Change_Interaction_Transportation_Type_t* cthis) ;
void cer_M_Change_Interaction_Transportation_Type_setOrderType(cer_M_Change_Interaction_Transportation_Type_t* cthis,  cer_OrderType_t newOrderType);
/* the show method */
FILE* M_Change_Interaction_Transportation_Type_show(FILE* out);
/* ---------------------- END <M_Change_Interaction_Transportation_Type> ------------------------ */

/* ---------------------- BEGIN <M_Request_Object_Attribute_Value_Update> ------------------------ */

typedef struct  cer_M_Request_Object_Attribute_Value_Update {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Request_Object_Attribute_Value_Update_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Request_Object_Attribute_Value_Update_t* cer_M_Request_Object_Attribute_Value_Update_create(uint32_t nb);
/* Destructor function */
void cer_M_Request_Object_Attribute_Value_Update_destroy(cer_M_Request_Object_Attribute_Value_Update_t** cthis);

/* Serialize function */
void cer_M_Request_Object_Attribute_Value_Update_serialize(cer_M_Request_Object_Attribute_Value_Update_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Request_Object_Attribute_Value_Update_deserialize(cer_M_Request_Object_Attribute_Value_Update_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Request_Object_Attribute_Value_Update_getObject(cer_M_Request_Object_Attribute_Value_Update_t* cthis) ;
void cer_M_Request_Object_Attribute_Value_Update_setObject(cer_M_Request_Object_Attribute_Value_Update_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Request_Object_Attribute_Value_Update_getAttributesSize(cer_M_Request_Object_Attribute_Value_Update_t* cthis);
void cer_M_Request_Object_Attribute_Value_Update_setAttributesSize(cer_M_Request_Object_Attribute_Value_Update_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Request_Object_Attribute_Value_Update_getAttributes(cer_M_Request_Object_Attribute_Value_Update_t* cthis, uint32_t rank);
void cer_M_Request_Object_Attribute_Value_Update_setAttributes(cer_M_Request_Object_Attribute_Value_Update_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Request_Object_Attribute_Value_Update_show(FILE* out);
/* ---------------------- END <M_Request_Object_Attribute_Value_Update> ------------------------ */

/* ---------------------- BEGIN <M_Request_Class_Attribute_Value_Update> ------------------------ */

typedef struct  cer_M_Request_Class_Attribute_Value_Update {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Request_Class_Attribute_Value_Update_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Request_Class_Attribute_Value_Update_t* cer_M_Request_Class_Attribute_Value_Update_create(uint32_t nb);
/* Destructor function */
void cer_M_Request_Class_Attribute_Value_Update_destroy(cer_M_Request_Class_Attribute_Value_Update_t** cthis);

/* Serialize function */
void cer_M_Request_Class_Attribute_Value_Update_serialize(cer_M_Request_Class_Attribute_Value_Update_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Request_Class_Attribute_Value_Update_deserialize(cer_M_Request_Class_Attribute_Value_Update_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Request_Class_Attribute_Value_Update_getObjectClass(cer_M_Request_Class_Attribute_Value_Update_t* cthis) ;
void cer_M_Request_Class_Attribute_Value_Update_setObjectClass(cer_M_Request_Class_Attribute_Value_Update_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
uint32_t cer_M_Request_Class_Attribute_Value_Update_getAttributesSize(cer_M_Request_Class_Attribute_Value_Update_t* cthis);
void cer_M_Request_Class_Attribute_Value_Update_setAttributesSize(cer_M_Request_Class_Attribute_Value_Update_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Request_Class_Attribute_Value_Update_getAttributes(cer_M_Request_Class_Attribute_Value_Update_t* cthis, uint32_t rank);
void cer_M_Request_Class_Attribute_Value_Update_setAttributes(cer_M_Request_Class_Attribute_Value_Update_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Request_Class_Attribute_Value_Update_show(FILE* out);
/* ---------------------- END <M_Request_Class_Attribute_Value_Update> ------------------------ */

/* ---------------------- BEGIN <M_Provide_Attribute_Value_Update> ------------------------ */

typedef struct  cer_M_Provide_Attribute_Value_Update {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Provide_Attribute_Value_Update_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Provide_Attribute_Value_Update_t* cer_M_Provide_Attribute_Value_Update_create(uint32_t nb);
/* Destructor function */
void cer_M_Provide_Attribute_Value_Update_destroy(cer_M_Provide_Attribute_Value_Update_t** cthis);

/* Serialize function */
void cer_M_Provide_Attribute_Value_Update_serialize(cer_M_Provide_Attribute_Value_Update_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Provide_Attribute_Value_Update_deserialize(cer_M_Provide_Attribute_Value_Update_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Provide_Attribute_Value_Update_getObject(cer_M_Provide_Attribute_Value_Update_t* cthis) ;
void cer_M_Provide_Attribute_Value_Update_setObject(cer_M_Provide_Attribute_Value_Update_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Provide_Attribute_Value_Update_getAttributesSize(cer_M_Provide_Attribute_Value_Update_t* cthis);
void cer_M_Provide_Attribute_Value_Update_setAttributesSize(cer_M_Provide_Attribute_Value_Update_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Provide_Attribute_Value_Update_getAttributes(cer_M_Provide_Attribute_Value_Update_t* cthis, uint32_t rank);
void cer_M_Provide_Attribute_Value_Update_setAttributes(cer_M_Provide_Attribute_Value_Update_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Provide_Attribute_Value_Update_show(FILE* out);
/* ---------------------- END <M_Provide_Attribute_Value_Update> ------------------------ */

/* ---------------------- BEGIN <M_Attributes_In_Scope> ------------------------ */

typedef struct  cer_M_Attributes_In_Scope {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Attributes_In_Scope_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Attributes_In_Scope_t* cer_M_Attributes_In_Scope_create(uint32_t nb);
/* Destructor function */
void cer_M_Attributes_In_Scope_destroy(cer_M_Attributes_In_Scope_t** cthis);

/* Serialize function */
void cer_M_Attributes_In_Scope_serialize(cer_M_Attributes_In_Scope_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Attributes_In_Scope_deserialize(cer_M_Attributes_In_Scope_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attributes_In_Scope_getObject(cer_M_Attributes_In_Scope_t* cthis) ;
void cer_M_Attributes_In_Scope_setObject(cer_M_Attributes_In_Scope_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Attributes_In_Scope_getAttributesSize(cer_M_Attributes_In_Scope_t* cthis);
void cer_M_Attributes_In_Scope_setAttributesSize(cer_M_Attributes_In_Scope_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Attributes_In_Scope_getAttributes(cer_M_Attributes_In_Scope_t* cthis, uint32_t rank);
void cer_M_Attributes_In_Scope_setAttributes(cer_M_Attributes_In_Scope_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Attributes_In_Scope_show(FILE* out);
/* ---------------------- END <M_Attributes_In_Scope> ------------------------ */

/* ---------------------- BEGIN <M_Attributes_Out_Of_Scope> ------------------------ */

typedef struct  cer_M_Attributes_Out_Of_Scope {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Attributes_Out_Of_Scope_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Attributes_Out_Of_Scope_t* cer_M_Attributes_Out_Of_Scope_create(uint32_t nb);
/* Destructor function */
void cer_M_Attributes_Out_Of_Scope_destroy(cer_M_Attributes_Out_Of_Scope_t** cthis);

/* Serialize function */
void cer_M_Attributes_Out_Of_Scope_serialize(cer_M_Attributes_Out_Of_Scope_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Attributes_Out_Of_Scope_deserialize(cer_M_Attributes_Out_Of_Scope_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attributes_Out_Of_Scope_getObject(cer_M_Attributes_Out_Of_Scope_t* cthis) ;
void cer_M_Attributes_Out_Of_Scope_setObject(cer_M_Attributes_Out_Of_Scope_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Attributes_Out_Of_Scope_getAttributesSize(cer_M_Attributes_Out_Of_Scope_t* cthis);
void cer_M_Attributes_Out_Of_Scope_setAttributesSize(cer_M_Attributes_Out_Of_Scope_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Attributes_Out_Of_Scope_getAttributes(cer_M_Attributes_Out_Of_Scope_t* cthis, uint32_t rank);
void cer_M_Attributes_Out_Of_Scope_setAttributes(cer_M_Attributes_Out_Of_Scope_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Attributes_Out_Of_Scope_show(FILE* out);
/* ---------------------- END <M_Attributes_Out_Of_Scope> ------------------------ */

/* ---------------------- BEGIN <M_Turn_Updates_On_For_Object_Instance> ------------------------ */

typedef struct  cer_M_Turn_Updates_On_For_Object_Instance {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Turn_Updates_On_For_Object_Instance_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Turn_Updates_On_For_Object_Instance_t* cer_M_Turn_Updates_On_For_Object_Instance_create(uint32_t nb);
/* Destructor function */
void cer_M_Turn_Updates_On_For_Object_Instance_destroy(cer_M_Turn_Updates_On_For_Object_Instance_t** cthis);

/* Serialize function */
void cer_M_Turn_Updates_On_For_Object_Instance_serialize(cer_M_Turn_Updates_On_For_Object_Instance_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Turn_Updates_On_For_Object_Instance_deserialize(cer_M_Turn_Updates_On_For_Object_Instance_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Turn_Updates_On_For_Object_Instance_getObject(cer_M_Turn_Updates_On_For_Object_Instance_t* cthis) ;
void cer_M_Turn_Updates_On_For_Object_Instance_setObject(cer_M_Turn_Updates_On_For_Object_Instance_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Turn_Updates_On_For_Object_Instance_getAttributesSize(cer_M_Turn_Updates_On_For_Object_Instance_t* cthis);
void cer_M_Turn_Updates_On_For_Object_Instance_setAttributesSize(cer_M_Turn_Updates_On_For_Object_Instance_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Turn_Updates_On_For_Object_Instance_getAttributes(cer_M_Turn_Updates_On_For_Object_Instance_t* cthis, uint32_t rank);
void cer_M_Turn_Updates_On_For_Object_Instance_setAttributes(cer_M_Turn_Updates_On_For_Object_Instance_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Turn_Updates_On_For_Object_Instance_show(FILE* out);
/* ---------------------- END <M_Turn_Updates_On_For_Object_Instance> ------------------------ */

/* ---------------------- BEGIN <M_Turn_Updates_Off_For_Object_Instance> ------------------------ */

typedef struct  cer_M_Turn_Updates_Off_For_Object_Instance {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Turn_Updates_Off_For_Object_Instance_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Turn_Updates_Off_For_Object_Instance_t* cer_M_Turn_Updates_Off_For_Object_Instance_create(uint32_t nb);
/* Destructor function */
void cer_M_Turn_Updates_Off_For_Object_Instance_destroy(cer_M_Turn_Updates_Off_For_Object_Instance_t** cthis);

/* Serialize function */
void cer_M_Turn_Updates_Off_For_Object_Instance_serialize(cer_M_Turn_Updates_Off_For_Object_Instance_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Turn_Updates_Off_For_Object_Instance_deserialize(cer_M_Turn_Updates_Off_For_Object_Instance_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Turn_Updates_Off_For_Object_Instance_getObject(cer_M_Turn_Updates_Off_For_Object_Instance_t* cthis) ;
void cer_M_Turn_Updates_Off_For_Object_Instance_setObject(cer_M_Turn_Updates_Off_For_Object_Instance_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Turn_Updates_Off_For_Object_Instance_getAttributesSize(cer_M_Turn_Updates_Off_For_Object_Instance_t* cthis);
void cer_M_Turn_Updates_Off_For_Object_Instance_setAttributesSize(cer_M_Turn_Updates_Off_For_Object_Instance_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Turn_Updates_Off_For_Object_Instance_getAttributes(cer_M_Turn_Updates_Off_For_Object_Instance_t* cthis, uint32_t rank);
void cer_M_Turn_Updates_Off_For_Object_Instance_setAttributes(cer_M_Turn_Updates_Off_For_Object_Instance_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Turn_Updates_Off_For_Object_Instance_show(FILE* out);
/* ---------------------- END <M_Turn_Updates_Off_For_Object_Instance> ------------------------ */

/* ---------------------- BEGIN <M_Request_Attribute_Ownership_Divestiture> ------------------------ */
/*  Ownership management
 */
typedef struct  cer_M_Request_Attribute_Ownership_Divestiture {
   Message super;
} cer_M_Request_Attribute_Ownership_Divestiture_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Request_Attribute_Ownership_Divestiture_t* cer_M_Request_Attribute_Ownership_Divestiture_create(uint32_t nb);
/* Destructor function */
void cer_M_Request_Attribute_Ownership_Divestiture_destroy(cer_M_Request_Attribute_Ownership_Divestiture_t** cthis);

/* ---------------------- BEGIN <M_Request_Attribute_Ownership_Assumption> ------------------------ */

typedef struct  cer_M_Request_Attribute_Ownership_Assumption {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Request_Attribute_Ownership_Assumption_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Request_Attribute_Ownership_Assumption_t* cer_M_Request_Attribute_Ownership_Assumption_create(uint32_t nb);
/* Destructor function */
void cer_M_Request_Attribute_Ownership_Assumption_destroy(cer_M_Request_Attribute_Ownership_Assumption_t** cthis);

/* Serialize function */
void cer_M_Request_Attribute_Ownership_Assumption_serialize(cer_M_Request_Attribute_Ownership_Assumption_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Request_Attribute_Ownership_Assumption_deserialize(cer_M_Request_Attribute_Ownership_Assumption_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Request_Attribute_Ownership_Assumption_getObject(cer_M_Request_Attribute_Ownership_Assumption_t* cthis) ;
void cer_M_Request_Attribute_Ownership_Assumption_setObject(cer_M_Request_Attribute_Ownership_Assumption_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Request_Attribute_Ownership_Assumption_getAttributesSize(cer_M_Request_Attribute_Ownership_Assumption_t* cthis);
void cer_M_Request_Attribute_Ownership_Assumption_setAttributesSize(cer_M_Request_Attribute_Ownership_Assumption_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Request_Attribute_Ownership_Assumption_getAttributes(cer_M_Request_Attribute_Ownership_Assumption_t* cthis, uint32_t rank);
void cer_M_Request_Attribute_Ownership_Assumption_setAttributes(cer_M_Request_Attribute_Ownership_Assumption_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Request_Attribute_Ownership_Assumption_show(FILE* out);
/* ---------------------- END <M_Request_Attribute_Ownership_Assumption> ------------------------ */

/* ---------------------- BEGIN <M_Negotiated_Attribute_Ownership_Divestiture> ------------------------ */

typedef struct  cer_M_Negotiated_Attribute_Ownership_Divestiture {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Negotiated_Attribute_Ownership_Divestiture_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Negotiated_Attribute_Ownership_Divestiture_t* cer_M_Negotiated_Attribute_Ownership_Divestiture_create(uint32_t nb);
/* Destructor function */
void cer_M_Negotiated_Attribute_Ownership_Divestiture_destroy(cer_M_Negotiated_Attribute_Ownership_Divestiture_t** cthis);

/* Serialize function */
void cer_M_Negotiated_Attribute_Ownership_Divestiture_serialize(cer_M_Negotiated_Attribute_Ownership_Divestiture_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Negotiated_Attribute_Ownership_Divestiture_deserialize(cer_M_Negotiated_Attribute_Ownership_Divestiture_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Negotiated_Attribute_Ownership_Divestiture_getObject(cer_M_Negotiated_Attribute_Ownership_Divestiture_t* cthis) ;
void cer_M_Negotiated_Attribute_Ownership_Divestiture_setObject(cer_M_Negotiated_Attribute_Ownership_Divestiture_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Negotiated_Attribute_Ownership_Divestiture_getAttributesSize(cer_M_Negotiated_Attribute_Ownership_Divestiture_t* cthis);
void cer_M_Negotiated_Attribute_Ownership_Divestiture_setAttributesSize(cer_M_Negotiated_Attribute_Ownership_Divestiture_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Negotiated_Attribute_Ownership_Divestiture_getAttributes(cer_M_Negotiated_Attribute_Ownership_Divestiture_t* cthis, uint32_t rank);
void cer_M_Negotiated_Attribute_Ownership_Divestiture_setAttributes(cer_M_Negotiated_Attribute_Ownership_Divestiture_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Negotiated_Attribute_Ownership_Divestiture_show(FILE* out);
/* ---------------------- END <M_Negotiated_Attribute_Ownership_Divestiture> ------------------------ */

/* ---------------------- BEGIN <M_Attribute_Ownership_Divestiture_Notification> ------------------------ */

typedef struct  cer_M_Attribute_Ownership_Divestiture_Notification {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Attribute_Ownership_Divestiture_Notification_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Attribute_Ownership_Divestiture_Notification_t* cer_M_Attribute_Ownership_Divestiture_Notification_create(uint32_t nb);
/* Destructor function */
void cer_M_Attribute_Ownership_Divestiture_Notification_destroy(cer_M_Attribute_Ownership_Divestiture_Notification_t** cthis);

/* Serialize function */
void cer_M_Attribute_Ownership_Divestiture_Notification_serialize(cer_M_Attribute_Ownership_Divestiture_Notification_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Attribute_Ownership_Divestiture_Notification_deserialize(cer_M_Attribute_Ownership_Divestiture_Notification_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attribute_Ownership_Divestiture_Notification_getObject(cer_M_Attribute_Ownership_Divestiture_Notification_t* cthis) ;
void cer_M_Attribute_Ownership_Divestiture_Notification_setObject(cer_M_Attribute_Ownership_Divestiture_Notification_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Attribute_Ownership_Divestiture_Notification_getAttributesSize(cer_M_Attribute_Ownership_Divestiture_Notification_t* cthis);
void cer_M_Attribute_Ownership_Divestiture_Notification_setAttributesSize(cer_M_Attribute_Ownership_Divestiture_Notification_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Attribute_Ownership_Divestiture_Notification_getAttributes(cer_M_Attribute_Ownership_Divestiture_Notification_t* cthis, uint32_t rank);
void cer_M_Attribute_Ownership_Divestiture_Notification_setAttributes(cer_M_Attribute_Ownership_Divestiture_Notification_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Attribute_Ownership_Divestiture_Notification_show(FILE* out);
/* ---------------------- END <M_Attribute_Ownership_Divestiture_Notification> ------------------------ */

/* ---------------------- BEGIN <M_Attribute_Ownership_Acquisition_Notification> ------------------------ */

typedef struct  cer_M_Attribute_Ownership_Acquisition_Notification {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Attribute_Ownership_Acquisition_Notification_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Attribute_Ownership_Acquisition_Notification_t* cer_M_Attribute_Ownership_Acquisition_Notification_create(uint32_t nb);
/* Destructor function */
void cer_M_Attribute_Ownership_Acquisition_Notification_destroy(cer_M_Attribute_Ownership_Acquisition_Notification_t** cthis);

/* Serialize function */
void cer_M_Attribute_Ownership_Acquisition_Notification_serialize(cer_M_Attribute_Ownership_Acquisition_Notification_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Attribute_Ownership_Acquisition_Notification_deserialize(cer_M_Attribute_Ownership_Acquisition_Notification_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attribute_Ownership_Acquisition_Notification_getObject(cer_M_Attribute_Ownership_Acquisition_Notification_t* cthis) ;
void cer_M_Attribute_Ownership_Acquisition_Notification_setObject(cer_M_Attribute_Ownership_Acquisition_Notification_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Attribute_Ownership_Acquisition_Notification_getAttributesSize(cer_M_Attribute_Ownership_Acquisition_Notification_t* cthis);
void cer_M_Attribute_Ownership_Acquisition_Notification_setAttributesSize(cer_M_Attribute_Ownership_Acquisition_Notification_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Attribute_Ownership_Acquisition_Notification_getAttributes(cer_M_Attribute_Ownership_Acquisition_Notification_t* cthis, uint32_t rank);
void cer_M_Attribute_Ownership_Acquisition_Notification_setAttributes(cer_M_Attribute_Ownership_Acquisition_Notification_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Attribute_Ownership_Acquisition_Notification_show(FILE* out);
/* ---------------------- END <M_Attribute_Ownership_Acquisition_Notification> ------------------------ */

/* ---------------------- BEGIN <M_Request_Attribute_Ownership_Acquisition> ------------------------ */

typedef struct  cer_M_Request_Attribute_Ownership_Acquisition {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Request_Attribute_Ownership_Acquisition_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Request_Attribute_Ownership_Acquisition_t* cer_M_Request_Attribute_Ownership_Acquisition_create(uint32_t nb);
/* Destructor function */
void cer_M_Request_Attribute_Ownership_Acquisition_destroy(cer_M_Request_Attribute_Ownership_Acquisition_t** cthis);

/* Serialize function */
void cer_M_Request_Attribute_Ownership_Acquisition_serialize(cer_M_Request_Attribute_Ownership_Acquisition_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Request_Attribute_Ownership_Acquisition_deserialize(cer_M_Request_Attribute_Ownership_Acquisition_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Request_Attribute_Ownership_Acquisition_getObject(cer_M_Request_Attribute_Ownership_Acquisition_t* cthis) ;
void cer_M_Request_Attribute_Ownership_Acquisition_setObject(cer_M_Request_Attribute_Ownership_Acquisition_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Request_Attribute_Ownership_Acquisition_getAttributesSize(cer_M_Request_Attribute_Ownership_Acquisition_t* cthis);
void cer_M_Request_Attribute_Ownership_Acquisition_setAttributesSize(cer_M_Request_Attribute_Ownership_Acquisition_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Request_Attribute_Ownership_Acquisition_getAttributes(cer_M_Request_Attribute_Ownership_Acquisition_t* cthis, uint32_t rank);
void cer_M_Request_Attribute_Ownership_Acquisition_setAttributes(cer_M_Request_Attribute_Ownership_Acquisition_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Request_Attribute_Ownership_Acquisition_show(FILE* out);
/* ---------------------- END <M_Request_Attribute_Ownership_Acquisition> ------------------------ */

/* ---------------------- BEGIN <M_Request_Attribute_Ownership_Release> ------------------------ */

typedef struct  cer_M_Request_Attribute_Ownership_Release {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Request_Attribute_Ownership_Release_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Request_Attribute_Ownership_Release_t* cer_M_Request_Attribute_Ownership_Release_create(uint32_t nb);
/* Destructor function */
void cer_M_Request_Attribute_Ownership_Release_destroy(cer_M_Request_Attribute_Ownership_Release_t** cthis);

/* Serialize function */
void cer_M_Request_Attribute_Ownership_Release_serialize(cer_M_Request_Attribute_Ownership_Release_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Request_Attribute_Ownership_Release_deserialize(cer_M_Request_Attribute_Ownership_Release_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Request_Attribute_Ownership_Release_getObject(cer_M_Request_Attribute_Ownership_Release_t* cthis) ;
void cer_M_Request_Attribute_Ownership_Release_setObject(cer_M_Request_Attribute_Ownership_Release_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Request_Attribute_Ownership_Release_getAttributesSize(cer_M_Request_Attribute_Ownership_Release_t* cthis);
void cer_M_Request_Attribute_Ownership_Release_setAttributesSize(cer_M_Request_Attribute_Ownership_Release_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Request_Attribute_Ownership_Release_getAttributes(cer_M_Request_Attribute_Ownership_Release_t* cthis, uint32_t rank);
void cer_M_Request_Attribute_Ownership_Release_setAttributes(cer_M_Request_Attribute_Ownership_Release_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Request_Attribute_Ownership_Release_show(FILE* out);
/* ---------------------- END <M_Request_Attribute_Ownership_Release> ------------------------ */

/* ---------------------- BEGIN <M_Query_Attribute_Ownership> ------------------------ */

typedef struct  cer_M_Query_Attribute_Ownership {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t attribute;
} cer_M_Query_Attribute_Ownership_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Query_Attribute_Ownership_t* cer_M_Query_Attribute_Ownership_create(uint32_t nb);
/* Destructor function */
void cer_M_Query_Attribute_Ownership_destroy(cer_M_Query_Attribute_Ownership_t** cthis);

/* Serialize function */
void cer_M_Query_Attribute_Ownership_serialize(cer_M_Query_Attribute_Ownership_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Query_Attribute_Ownership_deserialize(cer_M_Query_Attribute_Ownership_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Query_Attribute_Ownership_getObject(cer_M_Query_Attribute_Ownership_t* cthis) ;
void cer_M_Query_Attribute_Ownership_setObject(cer_M_Query_Attribute_Ownership_t* cthis,  cer_ObjectHandle_t newObject);
cer_AttributeHandle_t cer_M_Query_Attribute_Ownership_getAttribute(cer_M_Query_Attribute_Ownership_t* cthis) ;
void cer_M_Query_Attribute_Ownership_setAttribute(cer_M_Query_Attribute_Ownership_t* cthis,  cer_AttributeHandle_t newAttribute);
/* the show method */
FILE* M_Query_Attribute_Ownership_show(FILE* out);
/* ---------------------- END <M_Query_Attribute_Ownership> ------------------------ */

/* ---------------------- BEGIN <M_Inform_Attribute_Ownership> ------------------------ */

typedef struct  cer_M_Inform_Attribute_Ownership {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t attribute;
   cer_FederateHandle_t federate;
} cer_M_Inform_Attribute_Ownership_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Inform_Attribute_Ownership_t* cer_M_Inform_Attribute_Ownership_create(uint32_t nb);
/* Destructor function */
void cer_M_Inform_Attribute_Ownership_destroy(cer_M_Inform_Attribute_Ownership_t** cthis);

/* Serialize function */
void cer_M_Inform_Attribute_Ownership_serialize(cer_M_Inform_Attribute_Ownership_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Inform_Attribute_Ownership_deserialize(cer_M_Inform_Attribute_Ownership_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Inform_Attribute_Ownership_getObject(cer_M_Inform_Attribute_Ownership_t* cthis) ;
void cer_M_Inform_Attribute_Ownership_setObject(cer_M_Inform_Attribute_Ownership_t* cthis,  cer_ObjectHandle_t newObject);
cer_AttributeHandle_t cer_M_Inform_Attribute_Ownership_getAttribute(cer_M_Inform_Attribute_Ownership_t* cthis) ;
void cer_M_Inform_Attribute_Ownership_setAttribute(cer_M_Inform_Attribute_Ownership_t* cthis,  cer_AttributeHandle_t newAttribute);
cer_FederateHandle_t cer_M_Inform_Attribute_Ownership_getFederate(cer_M_Inform_Attribute_Ownership_t* cthis) ;
void cer_M_Inform_Attribute_Ownership_setFederate(cer_M_Inform_Attribute_Ownership_t* cthis,  cer_FederateHandle_t newFederate);
/* the show method */
FILE* M_Inform_Attribute_Ownership_show(FILE* out);
/* ---------------------- END <M_Inform_Attribute_Ownership> ------------------------ */

/* ---------------------- BEGIN <M_Is_Attribute_Owned_By_Federate> ------------------------ */

typedef struct  cer_M_Is_Attribute_Owned_By_Federate {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t attribute;
} cer_M_Is_Attribute_Owned_By_Federate_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Is_Attribute_Owned_By_Federate_t* cer_M_Is_Attribute_Owned_By_Federate_create(uint32_t nb);
/* Destructor function */
void cer_M_Is_Attribute_Owned_By_Federate_destroy(cer_M_Is_Attribute_Owned_By_Federate_t** cthis);

/* Serialize function */
void cer_M_Is_Attribute_Owned_By_Federate_serialize(cer_M_Is_Attribute_Owned_By_Federate_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Is_Attribute_Owned_By_Federate_deserialize(cer_M_Is_Attribute_Owned_By_Federate_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Is_Attribute_Owned_By_Federate_getObject(cer_M_Is_Attribute_Owned_By_Federate_t* cthis) ;
void cer_M_Is_Attribute_Owned_By_Federate_setObject(cer_M_Is_Attribute_Owned_By_Federate_t* cthis,  cer_ObjectHandle_t newObject);
cer_AttributeHandle_t cer_M_Is_Attribute_Owned_By_Federate_getAttribute(cer_M_Is_Attribute_Owned_By_Federate_t* cthis) ;
void cer_M_Is_Attribute_Owned_By_Federate_setAttribute(cer_M_Is_Attribute_Owned_By_Federate_t* cthis,  cer_AttributeHandle_t newAttribute);
/* the show method */
FILE* M_Is_Attribute_Owned_By_Federate_show(FILE* out);
/* ---------------------- END <M_Is_Attribute_Owned_By_Federate> ------------------------ */

/* ---------------------- BEGIN <M_Attribute_Is_Not_Owned> ------------------------ */

typedef struct  cer_M_Attribute_Is_Not_Owned {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t attribute;
   cer_FederateHandle_t federate;
} cer_M_Attribute_Is_Not_Owned_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Attribute_Is_Not_Owned_t* cer_M_Attribute_Is_Not_Owned_create(uint32_t nb);
/* Destructor function */
void cer_M_Attribute_Is_Not_Owned_destroy(cer_M_Attribute_Is_Not_Owned_t** cthis);

/* Serialize function */
void cer_M_Attribute_Is_Not_Owned_serialize(cer_M_Attribute_Is_Not_Owned_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Attribute_Is_Not_Owned_deserialize(cer_M_Attribute_Is_Not_Owned_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attribute_Is_Not_Owned_getObject(cer_M_Attribute_Is_Not_Owned_t* cthis) ;
void cer_M_Attribute_Is_Not_Owned_setObject(cer_M_Attribute_Is_Not_Owned_t* cthis,  cer_ObjectHandle_t newObject);
cer_AttributeHandle_t cer_M_Attribute_Is_Not_Owned_getAttribute(cer_M_Attribute_Is_Not_Owned_t* cthis) ;
void cer_M_Attribute_Is_Not_Owned_setAttribute(cer_M_Attribute_Is_Not_Owned_t* cthis,  cer_AttributeHandle_t newAttribute);
cer_FederateHandle_t cer_M_Attribute_Is_Not_Owned_getFederate(cer_M_Attribute_Is_Not_Owned_t* cthis) ;
void cer_M_Attribute_Is_Not_Owned_setFederate(cer_M_Attribute_Is_Not_Owned_t* cthis,  cer_FederateHandle_t newFederate);
/* the show method */
FILE* M_Attribute_Is_Not_Owned_show(FILE* out);
/* ---------------------- END <M_Attribute_Is_Not_Owned> ------------------------ */

/* ---------------------- BEGIN <M_Attribute_Owned_By_Rti> ------------------------ */

typedef struct  cer_M_Attribute_Owned_By_Rti {
   Message super;
} cer_M_Attribute_Owned_By_Rti_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Attribute_Owned_By_Rti_t* cer_M_Attribute_Owned_By_Rti_create(uint32_t nb);
/* Destructor function */
void cer_M_Attribute_Owned_By_Rti_destroy(cer_M_Attribute_Owned_By_Rti_t** cthis);

/* ---------------------- BEGIN <M_Attribute_Ownership_Acquisition_If_Available> ------------------------ */

typedef struct  cer_M_Attribute_Ownership_Acquisition_If_Available {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Attribute_Ownership_Acquisition_If_Available_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Attribute_Ownership_Acquisition_If_Available_t* cer_M_Attribute_Ownership_Acquisition_If_Available_create(uint32_t nb);
/* Destructor function */
void cer_M_Attribute_Ownership_Acquisition_If_Available_destroy(cer_M_Attribute_Ownership_Acquisition_If_Available_t** cthis);

/* Serialize function */
void cer_M_Attribute_Ownership_Acquisition_If_Available_serialize(cer_M_Attribute_Ownership_Acquisition_If_Available_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Attribute_Ownership_Acquisition_If_Available_deserialize(cer_M_Attribute_Ownership_Acquisition_If_Available_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attribute_Ownership_Acquisition_If_Available_getObject(cer_M_Attribute_Ownership_Acquisition_If_Available_t* cthis) ;
void cer_M_Attribute_Ownership_Acquisition_If_Available_setObject(cer_M_Attribute_Ownership_Acquisition_If_Available_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Attribute_Ownership_Acquisition_If_Available_getAttributesSize(cer_M_Attribute_Ownership_Acquisition_If_Available_t* cthis);
void cer_M_Attribute_Ownership_Acquisition_If_Available_setAttributesSize(cer_M_Attribute_Ownership_Acquisition_If_Available_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Attribute_Ownership_Acquisition_If_Available_getAttributes(cer_M_Attribute_Ownership_Acquisition_If_Available_t* cthis, uint32_t rank);
void cer_M_Attribute_Ownership_Acquisition_If_Available_setAttributes(cer_M_Attribute_Ownership_Acquisition_If_Available_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Attribute_Ownership_Acquisition_If_Available_show(FILE* out);
/* ---------------------- END <M_Attribute_Ownership_Acquisition_If_Available> ------------------------ */

/* ---------------------- BEGIN <M_Attribute_Ownership_Unavailable> ------------------------ */

typedef struct  cer_M_Attribute_Ownership_Unavailable {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Attribute_Ownership_Unavailable_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Attribute_Ownership_Unavailable_t* cer_M_Attribute_Ownership_Unavailable_create(uint32_t nb);
/* Destructor function */
void cer_M_Attribute_Ownership_Unavailable_destroy(cer_M_Attribute_Ownership_Unavailable_t** cthis);

/* Serialize function */
void cer_M_Attribute_Ownership_Unavailable_serialize(cer_M_Attribute_Ownership_Unavailable_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Attribute_Ownership_Unavailable_deserialize(cer_M_Attribute_Ownership_Unavailable_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attribute_Ownership_Unavailable_getObject(cer_M_Attribute_Ownership_Unavailable_t* cthis) ;
void cer_M_Attribute_Ownership_Unavailable_setObject(cer_M_Attribute_Ownership_Unavailable_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Attribute_Ownership_Unavailable_getAttributesSize(cer_M_Attribute_Ownership_Unavailable_t* cthis);
void cer_M_Attribute_Ownership_Unavailable_setAttributesSize(cer_M_Attribute_Ownership_Unavailable_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Attribute_Ownership_Unavailable_getAttributes(cer_M_Attribute_Ownership_Unavailable_t* cthis, uint32_t rank);
void cer_M_Attribute_Ownership_Unavailable_setAttributes(cer_M_Attribute_Ownership_Unavailable_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Attribute_Ownership_Unavailable_show(FILE* out);
/* ---------------------- END <M_Attribute_Ownership_Unavailable> ------------------------ */

/* ---------------------- BEGIN <M_Unconditional_Attribute_Ownership_Divestiture> ------------------------ */

typedef struct  cer_M_Unconditional_Attribute_Ownership_Divestiture {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Unconditional_Attribute_Ownership_Divestiture_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Unconditional_Attribute_Ownership_Divestiture_t* cer_M_Unconditional_Attribute_Ownership_Divestiture_create(uint32_t nb);
/* Destructor function */
void cer_M_Unconditional_Attribute_Ownership_Divestiture_destroy(cer_M_Unconditional_Attribute_Ownership_Divestiture_t** cthis);

/* Serialize function */
void cer_M_Unconditional_Attribute_Ownership_Divestiture_serialize(cer_M_Unconditional_Attribute_Ownership_Divestiture_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Unconditional_Attribute_Ownership_Divestiture_deserialize(cer_M_Unconditional_Attribute_Ownership_Divestiture_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Unconditional_Attribute_Ownership_Divestiture_getObject(cer_M_Unconditional_Attribute_Ownership_Divestiture_t* cthis) ;
void cer_M_Unconditional_Attribute_Ownership_Divestiture_setObject(cer_M_Unconditional_Attribute_Ownership_Divestiture_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Unconditional_Attribute_Ownership_Divestiture_getAttributesSize(cer_M_Unconditional_Attribute_Ownership_Divestiture_t* cthis);
void cer_M_Unconditional_Attribute_Ownership_Divestiture_setAttributesSize(cer_M_Unconditional_Attribute_Ownership_Divestiture_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Unconditional_Attribute_Ownership_Divestiture_getAttributes(cer_M_Unconditional_Attribute_Ownership_Divestiture_t* cthis, uint32_t rank);
void cer_M_Unconditional_Attribute_Ownership_Divestiture_setAttributes(cer_M_Unconditional_Attribute_Ownership_Divestiture_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Unconditional_Attribute_Ownership_Divestiture_show(FILE* out);
/* ---------------------- END <M_Unconditional_Attribute_Ownership_Divestiture> ------------------------ */

/* ---------------------- BEGIN <M_Attribute_Ownership_Acquisition> ------------------------ */

typedef struct  cer_M_Attribute_Ownership_Acquisition {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Attribute_Ownership_Acquisition_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Attribute_Ownership_Acquisition_t* cer_M_Attribute_Ownership_Acquisition_create(uint32_t nb);
/* Destructor function */
void cer_M_Attribute_Ownership_Acquisition_destroy(cer_M_Attribute_Ownership_Acquisition_t** cthis);

/* Serialize function */
void cer_M_Attribute_Ownership_Acquisition_serialize(cer_M_Attribute_Ownership_Acquisition_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Attribute_Ownership_Acquisition_deserialize(cer_M_Attribute_Ownership_Acquisition_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attribute_Ownership_Acquisition_getObject(cer_M_Attribute_Ownership_Acquisition_t* cthis) ;
void cer_M_Attribute_Ownership_Acquisition_setObject(cer_M_Attribute_Ownership_Acquisition_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Attribute_Ownership_Acquisition_getAttributesSize(cer_M_Attribute_Ownership_Acquisition_t* cthis);
void cer_M_Attribute_Ownership_Acquisition_setAttributesSize(cer_M_Attribute_Ownership_Acquisition_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Attribute_Ownership_Acquisition_getAttributes(cer_M_Attribute_Ownership_Acquisition_t* cthis, uint32_t rank);
void cer_M_Attribute_Ownership_Acquisition_setAttributes(cer_M_Attribute_Ownership_Acquisition_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Attribute_Ownership_Acquisition_show(FILE* out);
/* ---------------------- END <M_Attribute_Ownership_Acquisition> ------------------------ */

/* ---------------------- BEGIN <M_Cancel_Negotiated_Attribute_Ownership_Divestiture> ------------------------ */

typedef struct  cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_create(uint32_t nb);
/* Destructor function */
void cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_destroy(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t** cthis);

/* Serialize function */
void cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_serialize(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_deserialize(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_getObject(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* cthis) ;
void cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_setObject(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_getAttributesSize(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* cthis);
void cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_setAttributesSize(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_getAttributes(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* cthis, uint32_t rank);
void cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_setAttributes(cer_M_Cancel_Negotiated_Attribute_Ownership_Divestiture_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Cancel_Negotiated_Attribute_Ownership_Divestiture_show(FILE* out);
/* ---------------------- END <M_Cancel_Negotiated_Attribute_Ownership_Divestiture> ------------------------ */

/* ---------------------- BEGIN <M_Attribute_Ownership_Release_Response> ------------------------ */

typedef struct  cer_M_Attribute_Ownership_Release_Response {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Attribute_Ownership_Release_Response_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Attribute_Ownership_Release_Response_t* cer_M_Attribute_Ownership_Release_Response_create(uint32_t nb);
/* Destructor function */
void cer_M_Attribute_Ownership_Release_Response_destroy(cer_M_Attribute_Ownership_Release_Response_t** cthis);

/* Serialize function */
void cer_M_Attribute_Ownership_Release_Response_serialize(cer_M_Attribute_Ownership_Release_Response_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Attribute_Ownership_Release_Response_deserialize(cer_M_Attribute_Ownership_Release_Response_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Attribute_Ownership_Release_Response_getObject(cer_M_Attribute_Ownership_Release_Response_t* cthis) ;
void cer_M_Attribute_Ownership_Release_Response_setObject(cer_M_Attribute_Ownership_Release_Response_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Attribute_Ownership_Release_Response_getAttributesSize(cer_M_Attribute_Ownership_Release_Response_t* cthis);
void cer_M_Attribute_Ownership_Release_Response_setAttributesSize(cer_M_Attribute_Ownership_Release_Response_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Attribute_Ownership_Release_Response_getAttributes(cer_M_Attribute_Ownership_Release_Response_t* cthis, uint32_t rank);
void cer_M_Attribute_Ownership_Release_Response_setAttributes(cer_M_Attribute_Ownership_Release_Response_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Attribute_Ownership_Release_Response_show(FILE* out);
/* ---------------------- END <M_Attribute_Ownership_Release_Response> ------------------------ */

/* ---------------------- BEGIN <M_Cancel_Attribute_Ownership_Acquisition> ------------------------ */

typedef struct  cer_M_Cancel_Attribute_Ownership_Acquisition {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Cancel_Attribute_Ownership_Acquisition_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Cancel_Attribute_Ownership_Acquisition_t* cer_M_Cancel_Attribute_Ownership_Acquisition_create(uint32_t nb);
/* Destructor function */
void cer_M_Cancel_Attribute_Ownership_Acquisition_destroy(cer_M_Cancel_Attribute_Ownership_Acquisition_t** cthis);

/* Serialize function */
void cer_M_Cancel_Attribute_Ownership_Acquisition_serialize(cer_M_Cancel_Attribute_Ownership_Acquisition_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Cancel_Attribute_Ownership_Acquisition_deserialize(cer_M_Cancel_Attribute_Ownership_Acquisition_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Cancel_Attribute_Ownership_Acquisition_getObject(cer_M_Cancel_Attribute_Ownership_Acquisition_t* cthis) ;
void cer_M_Cancel_Attribute_Ownership_Acquisition_setObject(cer_M_Cancel_Attribute_Ownership_Acquisition_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Cancel_Attribute_Ownership_Acquisition_getAttributesSize(cer_M_Cancel_Attribute_Ownership_Acquisition_t* cthis);
void cer_M_Cancel_Attribute_Ownership_Acquisition_setAttributesSize(cer_M_Cancel_Attribute_Ownership_Acquisition_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Cancel_Attribute_Ownership_Acquisition_getAttributes(cer_M_Cancel_Attribute_Ownership_Acquisition_t* cthis, uint32_t rank);
void cer_M_Cancel_Attribute_Ownership_Acquisition_setAttributes(cer_M_Cancel_Attribute_Ownership_Acquisition_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Cancel_Attribute_Ownership_Acquisition_show(FILE* out);
/* ---------------------- END <M_Cancel_Attribute_Ownership_Acquisition> ------------------------ */

/* ---------------------- BEGIN <M_Confirm_Attribute_Ownership_Acquisition_Cancellation> ------------------------ */

typedef struct  cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation {
   Message super;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_create(uint32_t nb);
/* Destructor function */
void cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_destroy(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t** cthis);

/* Serialize function */
void cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_serialize(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_deserialize(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_getObject(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* cthis) ;
void cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_setObject(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_getAttributesSize(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* cthis);
void cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_setAttributesSize(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_getAttributes(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* cthis, uint32_t rank);
void cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_setAttributes(cer_M_Confirm_Attribute_Ownership_Acquisition_Cancellation_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Confirm_Attribute_Ownership_Acquisition_Cancellation_show(FILE* out);
/* ---------------------- END <M_Confirm_Attribute_Ownership_Acquisition_Cancellation> ------------------------ */

/* ---------------------- BEGIN <M_Change_Attribute_Order_Type> ------------------------ */
/*  Time
 */
typedef struct  cer_M_Change_Attribute_Order_Type {
   Message super;
   cer_TransportType_t transport;
   cer_OrderType_t order;
   cer_ObjectHandle_t object;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Change_Attribute_Order_Type_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Change_Attribute_Order_Type_t* cer_M_Change_Attribute_Order_Type_create(uint32_t nb);
/* Destructor function */
void cer_M_Change_Attribute_Order_Type_destroy(cer_M_Change_Attribute_Order_Type_t** cthis);

/* Serialize function */
void cer_M_Change_Attribute_Order_Type_serialize(cer_M_Change_Attribute_Order_Type_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Change_Attribute_Order_Type_deserialize(cer_M_Change_Attribute_Order_Type_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_TransportType_t cer_M_Change_Attribute_Order_Type_getTransport(cer_M_Change_Attribute_Order_Type_t* cthis) ;
void cer_M_Change_Attribute_Order_Type_setTransport(cer_M_Change_Attribute_Order_Type_t* cthis,  cer_TransportType_t newTransport);
cer_OrderType_t cer_M_Change_Attribute_Order_Type_getOrder(cer_M_Change_Attribute_Order_Type_t* cthis) ;
void cer_M_Change_Attribute_Order_Type_setOrder(cer_M_Change_Attribute_Order_Type_t* cthis,  cer_OrderType_t newOrder);
cer_ObjectHandle_t cer_M_Change_Attribute_Order_Type_getObject(cer_M_Change_Attribute_Order_Type_t* cthis) ;
void cer_M_Change_Attribute_Order_Type_setObject(cer_M_Change_Attribute_Order_Type_t* cthis,  cer_ObjectHandle_t newObject);
uint32_t cer_M_Change_Attribute_Order_Type_getAttributesSize(cer_M_Change_Attribute_Order_Type_t* cthis);
void cer_M_Change_Attribute_Order_Type_setAttributesSize(cer_M_Change_Attribute_Order_Type_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Change_Attribute_Order_Type_getAttributes(cer_M_Change_Attribute_Order_Type_t* cthis, uint32_t rank);
void cer_M_Change_Attribute_Order_Type_setAttributes(cer_M_Change_Attribute_Order_Type_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Change_Attribute_Order_Type_show(FILE* out);
/* ---------------------- END <M_Change_Attribute_Order_Type> ------------------------ */

/* ---------------------- BEGIN <M_Change_Interaction_Order_Type> ------------------------ */

typedef struct  cer_M_Change_Interaction_Order_Type {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
   cer_TransportType_t transport;
   cer_OrderType_t order;
} cer_M_Change_Interaction_Order_Type_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Change_Interaction_Order_Type_t* cer_M_Change_Interaction_Order_Type_create(uint32_t nb);
/* Destructor function */
void cer_M_Change_Interaction_Order_Type_destroy(cer_M_Change_Interaction_Order_Type_t** cthis);

/* Serialize function */
void cer_M_Change_Interaction_Order_Type_serialize(cer_M_Change_Interaction_Order_Type_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Change_Interaction_Order_Type_deserialize(cer_M_Change_Interaction_Order_Type_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Change_Interaction_Order_Type_getInteractionClass(cer_M_Change_Interaction_Order_Type_t* cthis) ;
void cer_M_Change_Interaction_Order_Type_setInteractionClass(cer_M_Change_Interaction_Order_Type_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
cer_TransportType_t cer_M_Change_Interaction_Order_Type_getTransport(cer_M_Change_Interaction_Order_Type_t* cthis) ;
void cer_M_Change_Interaction_Order_Type_setTransport(cer_M_Change_Interaction_Order_Type_t* cthis,  cer_TransportType_t newTransport);
cer_OrderType_t cer_M_Change_Interaction_Order_Type_getOrder(cer_M_Change_Interaction_Order_Type_t* cthis) ;
void cer_M_Change_Interaction_Order_Type_setOrder(cer_M_Change_Interaction_Order_Type_t* cthis,  cer_OrderType_t newOrder);
/* the show method */
FILE* M_Change_Interaction_Order_Type_show(FILE* out);
/* ---------------------- END <M_Change_Interaction_Order_Type> ------------------------ */

/* ---------------------- BEGIN <M_Enable_Time_Regulation> ------------------------ */
/*  HLA 1.3 - §8.2
 */
typedef struct  cer_M_Enable_Time_Regulation {
   Message super;
   double lookahead;
} cer_M_Enable_Time_Regulation_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Enable_Time_Regulation_t* cer_M_Enable_Time_Regulation_create(uint32_t nb);
/* Destructor function */
void cer_M_Enable_Time_Regulation_destroy(cer_M_Enable_Time_Regulation_t** cthis);

/* Serialize function */
void cer_M_Enable_Time_Regulation_serialize(cer_M_Enable_Time_Regulation_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Enable_Time_Regulation_deserialize(cer_M_Enable_Time_Regulation_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
double cer_M_Enable_Time_Regulation_getLookahead(cer_M_Enable_Time_Regulation_t* cthis) ;
void cer_M_Enable_Time_Regulation_setLookahead(cer_M_Enable_Time_Regulation_t* cthis,  double newLookahead);
/* the show method */
FILE* M_Enable_Time_Regulation_show(FILE* out);
/* ---------------------- END <M_Enable_Time_Regulation> ------------------------ */

/* ---------------------- BEGIN <M_Disable_Time_Regulation> ------------------------ */
/*  HLA 1.3 - §8.4
 */
typedef struct  cer_M_Disable_Time_Regulation {
   Message super;
   double lookahead;
} cer_M_Disable_Time_Regulation_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Disable_Time_Regulation_t* cer_M_Disable_Time_Regulation_create(uint32_t nb);
/* Destructor function */
void cer_M_Disable_Time_Regulation_destroy(cer_M_Disable_Time_Regulation_t** cthis);

/* Serialize function */
void cer_M_Disable_Time_Regulation_serialize(cer_M_Disable_Time_Regulation_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Disable_Time_Regulation_deserialize(cer_M_Disable_Time_Regulation_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
double cer_M_Disable_Time_Regulation_getLookahead(cer_M_Disable_Time_Regulation_t* cthis) ;
void cer_M_Disable_Time_Regulation_setLookahead(cer_M_Disable_Time_Regulation_t* cthis,  double newLookahead);
/* the show method */
FILE* M_Disable_Time_Regulation_show(FILE* out);
/* ---------------------- END <M_Disable_Time_Regulation> ------------------------ */

/* ---------------------- BEGIN <M_Enable_Time_Constrained> ------------------------ */
/*  HLA 1.3 - §8.5
 */
typedef struct  cer_M_Enable_Time_Constrained {
   Message super;
} cer_M_Enable_Time_Constrained_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Enable_Time_Constrained_t* cer_M_Enable_Time_Constrained_create(uint32_t nb);
/* Destructor function */
void cer_M_Enable_Time_Constrained_destroy(cer_M_Enable_Time_Constrained_t** cthis);

/* ---------------------- BEGIN <M_Disable_Time_Constrained> ------------------------ */
/*  HLA 1.3 - §8.7
 */
typedef struct  cer_M_Disable_Time_Constrained {
   Message super;
} cer_M_Disable_Time_Constrained_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Disable_Time_Constrained_t* cer_M_Disable_Time_Constrained_create(uint32_t nb);
/* Destructor function */
void cer_M_Disable_Time_Constrained_destroy(cer_M_Disable_Time_Constrained_t** cthis);

/* ---------------------- BEGIN <M_Query_Lbts> ------------------------ */

typedef struct  cer_M_Query_Lbts {
   Message super;
} cer_M_Query_Lbts_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Query_Lbts_t* cer_M_Query_Lbts_create(uint32_t nb);
/* Destructor function */
void cer_M_Query_Lbts_destroy(cer_M_Query_Lbts_t** cthis);

/* ---------------------- BEGIN <M_Query_Federate_Time> ------------------------ */

typedef struct  cer_M_Query_Federate_Time {
   Message super;
} cer_M_Query_Federate_Time_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Query_Federate_Time_t* cer_M_Query_Federate_Time_create(uint32_t nb);
/* Destructor function */
void cer_M_Query_Federate_Time_destroy(cer_M_Query_Federate_Time_t** cthis);

/* ---------------------- BEGIN <M_Query_Min_Next_Event_Time> ------------------------ */

typedef struct  cer_M_Query_Min_Next_Event_Time {
   Message super;
} cer_M_Query_Min_Next_Event_Time_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Query_Min_Next_Event_Time_t* cer_M_Query_Min_Next_Event_Time_create(uint32_t nb);
/* Destructor function */
void cer_M_Query_Min_Next_Event_Time_destroy(cer_M_Query_Min_Next_Event_Time_t** cthis);

/* ---------------------- BEGIN <M_Modify_Lookahead> ------------------------ */

typedef struct  cer_M_Modify_Lookahead {
   Message super;
   double lookahead;
} cer_M_Modify_Lookahead_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Modify_Lookahead_t* cer_M_Modify_Lookahead_create(uint32_t nb);
/* Destructor function */
void cer_M_Modify_Lookahead_destroy(cer_M_Modify_Lookahead_t** cthis);

/* Serialize function */
void cer_M_Modify_Lookahead_serialize(cer_M_Modify_Lookahead_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Modify_Lookahead_deserialize(cer_M_Modify_Lookahead_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
double cer_M_Modify_Lookahead_getLookahead(cer_M_Modify_Lookahead_t* cthis) ;
void cer_M_Modify_Lookahead_setLookahead(cer_M_Modify_Lookahead_t* cthis,  double newLookahead);
/* the show method */
FILE* M_Modify_Lookahead_show(FILE* out);
/* ---------------------- END <M_Modify_Lookahead> ------------------------ */

/* ---------------------- BEGIN <M_Query_Lookahead> ------------------------ */

typedef struct  cer_M_Query_Lookahead {
   Message super;
   double lookahead;
} cer_M_Query_Lookahead_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Query_Lookahead_t* cer_M_Query_Lookahead_create(uint32_t nb);
/* Destructor function */
void cer_M_Query_Lookahead_destroy(cer_M_Query_Lookahead_t** cthis);

/* Serialize function */
void cer_M_Query_Lookahead_serialize(cer_M_Query_Lookahead_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Query_Lookahead_deserialize(cer_M_Query_Lookahead_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
double cer_M_Query_Lookahead_getLookahead(cer_M_Query_Lookahead_t* cthis) ;
void cer_M_Query_Lookahead_setLookahead(cer_M_Query_Lookahead_t* cthis,  double newLookahead);
/* the show method */
FILE* M_Query_Lookahead_show(FILE* out);
/* ---------------------- END <M_Query_Lookahead> ------------------------ */

/* ---------------------- BEGIN <M_Retract> ------------------------ */

typedef struct  cer_M_Retract {
   Message super;
   cer_EventRetraction_t eventRetraction;
} cer_M_Retract_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Retract_t* cer_M_Retract_create(uint32_t nb);
/* Destructor function */
void cer_M_Retract_destroy(cer_M_Retract_t** cthis);

/* Serialize function */
void cer_M_Retract_serialize(cer_M_Retract_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Retract_deserialize(cer_M_Retract_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_EventRetraction_t cer_M_Retract_getEventRetraction(cer_M_Retract_t* cthis) ;
void cer_M_Retract_setEventRetraction(cer_M_Retract_t* cthis,  cer_EventRetraction_t newEventRetraction);
/* the show method */
FILE* M_Retract_show(FILE* out);
/* ---------------------- END <M_Retract> ------------------------ */

/* ---------------------- BEGIN <M_Request_Retraction> ------------------------ */

typedef struct  cer_M_Request_Retraction {
   Message super;
} cer_M_Request_Retraction_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Request_Retraction_t* cer_M_Request_Retraction_create(uint32_t nb);
/* Destructor function */
void cer_M_Request_Retraction_destroy(cer_M_Request_Retraction_t** cthis);

/* ---------------------- BEGIN <M_Time_Advance_Request> ------------------------ */
/*  HLA 1.3 - §8.8
 */
typedef struct  cer_M_Time_Advance_Request {
   Message super;
} cer_M_Time_Advance_Request_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Time_Advance_Request_t* cer_M_Time_Advance_Request_create(uint32_t nb);
/* Destructor function */
void cer_M_Time_Advance_Request_destroy(cer_M_Time_Advance_Request_t** cthis);

/* ---------------------- BEGIN <M_Time_Advance_Request_Available> ------------------------ */

typedef struct  cer_M_Time_Advance_Request_Available {
   Message super;
} cer_M_Time_Advance_Request_Available_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Time_Advance_Request_Available_t* cer_M_Time_Advance_Request_Available_create(uint32_t nb);
/* Destructor function */
void cer_M_Time_Advance_Request_Available_destroy(cer_M_Time_Advance_Request_Available_t** cthis);

/* ---------------------- BEGIN <M_Next_Event_Request> ------------------------ */

typedef struct  cer_M_Next_Event_Request {
   Message super;
} cer_M_Next_Event_Request_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Next_Event_Request_t* cer_M_Next_Event_Request_create(uint32_t nb);
/* Destructor function */
void cer_M_Next_Event_Request_destroy(cer_M_Next_Event_Request_t** cthis);

/* ---------------------- BEGIN <M_Next_Event_Request_Available> ------------------------ */

typedef struct  cer_M_Next_Event_Request_Available {
   Message super;
} cer_M_Next_Event_Request_Available_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Next_Event_Request_Available_t* cer_M_Next_Event_Request_Available_create(uint32_t nb);
/* Destructor function */
void cer_M_Next_Event_Request_Available_destroy(cer_M_Next_Event_Request_Available_t** cthis);

/* ---------------------- BEGIN <M_Flush_Queue_Request> ------------------------ */

typedef struct  cer_M_Flush_Queue_Request {
   Message super;
} cer_M_Flush_Queue_Request_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Flush_Queue_Request_t* cer_M_Flush_Queue_Request_create(uint32_t nb);
/* Destructor function */
void cer_M_Flush_Queue_Request_destroy(cer_M_Flush_Queue_Request_t** cthis);

/* ---------------------- BEGIN <M_Time_Advance_Grant> ------------------------ */

typedef struct  cer_M_Time_Advance_Grant {
   Message super;
} cer_M_Time_Advance_Grant_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Time_Advance_Grant_t* cer_M_Time_Advance_Grant_create(uint32_t nb);
/* Destructor function */
void cer_M_Time_Advance_Grant_destroy(cer_M_Time_Advance_Grant_t** cthis);

/* ---------------------- BEGIN <M_Enable_Asynchronous_Delivery> ------------------------ */

typedef struct  cer_M_Enable_Asynchronous_Delivery {
   Message super;
} cer_M_Enable_Asynchronous_Delivery_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Enable_Asynchronous_Delivery_t* cer_M_Enable_Asynchronous_Delivery_create(uint32_t nb);
/* Destructor function */
void cer_M_Enable_Asynchronous_Delivery_destroy(cer_M_Enable_Asynchronous_Delivery_t** cthis);

/* ---------------------- BEGIN <M_Disable_Asynchronous_Delivery> ------------------------ */

typedef struct  cer_M_Disable_Asynchronous_Delivery {
   Message super;
} cer_M_Disable_Asynchronous_Delivery_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Disable_Asynchronous_Delivery_t* cer_M_Disable_Asynchronous_Delivery_create(uint32_t nb);
/* Destructor function */
void cer_M_Disable_Asynchronous_Delivery_destroy(cer_M_Disable_Asynchronous_Delivery_t** cthis);

/* ---------------------- BEGIN <M_Time_Regulation_Enabled> ------------------------ */
/*  HLA 1.3 - §8.3
 */
typedef struct  cer_M_Time_Regulation_Enabled {
   Message super;
} cer_M_Time_Regulation_Enabled_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Time_Regulation_Enabled_t* cer_M_Time_Regulation_Enabled_create(uint32_t nb);
/* Destructor function */
void cer_M_Time_Regulation_Enabled_destroy(cer_M_Time_Regulation_Enabled_t** cthis);

/* ---------------------- BEGIN <M_Time_Constrained_Enabled> ------------------------ */
/*  HLA 1.3 - §8.6
 */
typedef struct  cer_M_Time_Constrained_Enabled {
   Message super;
} cer_M_Time_Constrained_Enabled_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Time_Constrained_Enabled_t* cer_M_Time_Constrained_Enabled_create(uint32_t nb);
/* Destructor function */
void cer_M_Time_Constrained_Enabled_destroy(cer_M_Time_Constrained_Enabled_t** cthis);

/* ---------------------- BEGIN <M_Ddm_Create_Region> ------------------------ */
/*  Data Distribution Management
 */
typedef struct  cer_M_Ddm_Create_Region {
   Message super;
   cer_SpaceHandle_t space;/*  the routing space designator
 */
   cer_Extent_t* extentSet;
   uint32_t extentSetSize;/*  the extent set    
 */
   cer_RegionHandle_t region;/*  the region handle obtained upon successful creation
 */
} cer_M_Ddm_Create_Region_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Ddm_Create_Region_t* cer_M_Ddm_Create_Region_create(uint32_t nb);
/* Destructor function */
void cer_M_Ddm_Create_Region_destroy(cer_M_Ddm_Create_Region_t** cthis);

/* Serialize function */
void cer_M_Ddm_Create_Region_serialize(cer_M_Ddm_Create_Region_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Ddm_Create_Region_deserialize(cer_M_Ddm_Create_Region_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_SpaceHandle_t cer_M_Ddm_Create_Region_getSpace(cer_M_Ddm_Create_Region_t* cthis) ;
void cer_M_Ddm_Create_Region_setSpace(cer_M_Ddm_Create_Region_t* cthis,  cer_SpaceHandle_t newSpace);
uint32_t cer_M_Ddm_Create_Region_getExtentSetSize(cer_M_Ddm_Create_Region_t* cthis);
void cer_M_Ddm_Create_Region_setExtentSetSize(cer_M_Ddm_Create_Region_t* cthis, uint32_t num);
cer_Extent_t cer_M_Ddm_Create_Region_getExtentSet(cer_M_Ddm_Create_Region_t* cthis, uint32_t rank);
void cer_M_Ddm_Create_Region_setExtentSet(cer_M_Ddm_Create_Region_t* cthis, cer_Extent_t newExtentSet, uint32_t rank);
cer_RegionHandle_t cer_M_Ddm_Create_Region_getRegion(cer_M_Ddm_Create_Region_t* cthis) ;
void cer_M_Ddm_Create_Region_setRegion(cer_M_Ddm_Create_Region_t* cthis,  cer_RegionHandle_t newRegion);
/* the show method */
FILE* M_Ddm_Create_Region_show(FILE* out);
/* ---------------------- END <M_Ddm_Create_Region> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Modify_Region> ------------------------ */

typedef struct  cer_M_Ddm_Modify_Region {
   Message super;
   cer_RegionHandle_t region;
   cer_Extent_t* extentSet;
   uint32_t extentSetSize;/*  the extent set
 */
} cer_M_Ddm_Modify_Region_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Ddm_Modify_Region_t* cer_M_Ddm_Modify_Region_create(uint32_t nb);
/* Destructor function */
void cer_M_Ddm_Modify_Region_destroy(cer_M_Ddm_Modify_Region_t** cthis);

/* Serialize function */
void cer_M_Ddm_Modify_Region_serialize(cer_M_Ddm_Modify_Region_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Ddm_Modify_Region_deserialize(cer_M_Ddm_Modify_Region_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_RegionHandle_t cer_M_Ddm_Modify_Region_getRegion(cer_M_Ddm_Modify_Region_t* cthis) ;
void cer_M_Ddm_Modify_Region_setRegion(cer_M_Ddm_Modify_Region_t* cthis,  cer_RegionHandle_t newRegion);
uint32_t cer_M_Ddm_Modify_Region_getExtentSetSize(cer_M_Ddm_Modify_Region_t* cthis);
void cer_M_Ddm_Modify_Region_setExtentSetSize(cer_M_Ddm_Modify_Region_t* cthis, uint32_t num);
cer_Extent_t cer_M_Ddm_Modify_Region_getExtentSet(cer_M_Ddm_Modify_Region_t* cthis, uint32_t rank);
void cer_M_Ddm_Modify_Region_setExtentSet(cer_M_Ddm_Modify_Region_t* cthis, cer_Extent_t newExtentSet, uint32_t rank);
/* the show method */
FILE* M_Ddm_Modify_Region_show(FILE* out);
/* ---------------------- END <M_Ddm_Modify_Region> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Delete_Region> ------------------------ */

typedef struct  cer_M_Ddm_Delete_Region {
   Message super;
   cer_RegionHandle_t region;
} cer_M_Ddm_Delete_Region_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Ddm_Delete_Region_t* cer_M_Ddm_Delete_Region_create(uint32_t nb);
/* Destructor function */
void cer_M_Ddm_Delete_Region_destroy(cer_M_Ddm_Delete_Region_t** cthis);

/* Serialize function */
void cer_M_Ddm_Delete_Region_serialize(cer_M_Ddm_Delete_Region_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Ddm_Delete_Region_deserialize(cer_M_Ddm_Delete_Region_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_RegionHandle_t cer_M_Ddm_Delete_Region_getRegion(cer_M_Ddm_Delete_Region_t* cthis) ;
void cer_M_Ddm_Delete_Region_setRegion(cer_M_Ddm_Delete_Region_t* cthis,  cer_RegionHandle_t newRegion);
/* the show method */
FILE* M_Ddm_Delete_Region_show(FILE* out);
/* ---------------------- END <M_Ddm_Delete_Region> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Register_Object> ------------------------ */

typedef struct  cer_M_Ddm_Register_Object {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   cer_ObjectHandle_t object;
   char* objectInstanceName;
   uint8_t _hasObjectInstanceName;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;/*  repeated RegionHandle      regions 
 */
} cer_M_Ddm_Register_Object_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Ddm_Register_Object_t* cer_M_Ddm_Register_Object_create(uint32_t nb);
/* Destructor function */
void cer_M_Ddm_Register_Object_destroy(cer_M_Ddm_Register_Object_t** cthis);

/* Serialize function */
void cer_M_Ddm_Register_Object_serialize(cer_M_Ddm_Register_Object_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Ddm_Register_Object_deserialize(cer_M_Ddm_Register_Object_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Ddm_Register_Object_getObjectClass(cer_M_Ddm_Register_Object_t* cthis) ;
void cer_M_Ddm_Register_Object_setObjectClass(cer_M_Ddm_Register_Object_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
cer_ObjectHandle_t cer_M_Ddm_Register_Object_getObject(cer_M_Ddm_Register_Object_t* cthis) ;
void cer_M_Ddm_Register_Object_setObject(cer_M_Ddm_Register_Object_t* cthis,  cer_ObjectHandle_t newObject);
char* cer_M_Ddm_Register_Object_getObjectInstanceName(cer_M_Ddm_Register_Object_t* cthis) ;
void cer_M_Ddm_Register_Object_setObjectInstanceName(cer_M_Ddm_Register_Object_t* cthis,  char* newObjectInstanceName);
uint8_t hasObjectInstanceName(cer_M_Ddm_Register_Object_t cthis);
uint32_t cer_M_Ddm_Register_Object_getAttributesSize(cer_M_Ddm_Register_Object_t* cthis);
void cer_M_Ddm_Register_Object_setAttributesSize(cer_M_Ddm_Register_Object_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Ddm_Register_Object_getAttributes(cer_M_Ddm_Register_Object_t* cthis, uint32_t rank);
void cer_M_Ddm_Register_Object_setAttributes(cer_M_Ddm_Register_Object_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Ddm_Register_Object_show(FILE* out);
/* ---------------------- END <M_Ddm_Register_Object> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Associate_Region> ------------------------ */

typedef struct  cer_M_Ddm_Associate_Region {
   Message super;
   cer_ObjectHandle_t object;
   cer_RegionHandle_t region;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Ddm_Associate_Region_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Ddm_Associate_Region_t* cer_M_Ddm_Associate_Region_create(uint32_t nb);
/* Destructor function */
void cer_M_Ddm_Associate_Region_destroy(cer_M_Ddm_Associate_Region_t** cthis);

/* Serialize function */
void cer_M_Ddm_Associate_Region_serialize(cer_M_Ddm_Associate_Region_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Ddm_Associate_Region_deserialize(cer_M_Ddm_Associate_Region_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Ddm_Associate_Region_getObject(cer_M_Ddm_Associate_Region_t* cthis) ;
void cer_M_Ddm_Associate_Region_setObject(cer_M_Ddm_Associate_Region_t* cthis,  cer_ObjectHandle_t newObject);
cer_RegionHandle_t cer_M_Ddm_Associate_Region_getRegion(cer_M_Ddm_Associate_Region_t* cthis) ;
void cer_M_Ddm_Associate_Region_setRegion(cer_M_Ddm_Associate_Region_t* cthis,  cer_RegionHandle_t newRegion);
uint32_t cer_M_Ddm_Associate_Region_getAttributesSize(cer_M_Ddm_Associate_Region_t* cthis);
void cer_M_Ddm_Associate_Region_setAttributesSize(cer_M_Ddm_Associate_Region_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Ddm_Associate_Region_getAttributes(cer_M_Ddm_Associate_Region_t* cthis, uint32_t rank);
void cer_M_Ddm_Associate_Region_setAttributes(cer_M_Ddm_Associate_Region_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Ddm_Associate_Region_show(FILE* out);
/* ---------------------- END <M_Ddm_Associate_Region> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Unassociate_Region> ------------------------ */

typedef struct  cer_M_Ddm_Unassociate_Region {
   Message super;
   cer_ObjectHandle_t object;
   cer_RegionHandle_t region;
} cer_M_Ddm_Unassociate_Region_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Ddm_Unassociate_Region_t* cer_M_Ddm_Unassociate_Region_create(uint32_t nb);
/* Destructor function */
void cer_M_Ddm_Unassociate_Region_destroy(cer_M_Ddm_Unassociate_Region_t** cthis);

/* Serialize function */
void cer_M_Ddm_Unassociate_Region_serialize(cer_M_Ddm_Unassociate_Region_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Ddm_Unassociate_Region_deserialize(cer_M_Ddm_Unassociate_Region_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Ddm_Unassociate_Region_getObject(cer_M_Ddm_Unassociate_Region_t* cthis) ;
void cer_M_Ddm_Unassociate_Region_setObject(cer_M_Ddm_Unassociate_Region_t* cthis,  cer_ObjectHandle_t newObject);
cer_RegionHandle_t cer_M_Ddm_Unassociate_Region_getRegion(cer_M_Ddm_Unassociate_Region_t* cthis) ;
void cer_M_Ddm_Unassociate_Region_setRegion(cer_M_Ddm_Unassociate_Region_t* cthis,  cer_RegionHandle_t newRegion);
/* the show method */
FILE* M_Ddm_Unassociate_Region_show(FILE* out);
/* ---------------------- END <M_Ddm_Unassociate_Region> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Subscribe_Attributes> ------------------------ */

typedef struct  cer_M_Ddm_Subscribe_Attributes {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   cer_RegionHandle_t region;
   uint8_t passive;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Ddm_Subscribe_Attributes_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Ddm_Subscribe_Attributes_t* cer_M_Ddm_Subscribe_Attributes_create(uint32_t nb);
/* Destructor function */
void cer_M_Ddm_Subscribe_Attributes_destroy(cer_M_Ddm_Subscribe_Attributes_t** cthis);

/* Serialize function */
void cer_M_Ddm_Subscribe_Attributes_serialize(cer_M_Ddm_Subscribe_Attributes_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Ddm_Subscribe_Attributes_deserialize(cer_M_Ddm_Subscribe_Attributes_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Ddm_Subscribe_Attributes_getObjectClass(cer_M_Ddm_Subscribe_Attributes_t* cthis) ;
void cer_M_Ddm_Subscribe_Attributes_setObjectClass(cer_M_Ddm_Subscribe_Attributes_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
cer_RegionHandle_t cer_M_Ddm_Subscribe_Attributes_getRegion(cer_M_Ddm_Subscribe_Attributes_t* cthis) ;
void cer_M_Ddm_Subscribe_Attributes_setRegion(cer_M_Ddm_Subscribe_Attributes_t* cthis,  cer_RegionHandle_t newRegion);
void cer_M_Ddm_Subscribe_Attributes_passiveOn(cer_M_Ddm_Subscribe_Attributes_t* cthis);
void cer_M_Ddm_Subscribe_Attributes_passiveOff(cer_M_Ddm_Subscribe_Attributes_t* cthis);
uint8_t isPassiveOn(cer_M_Ddm_Subscribe_Attributes* cthis) ;
uint32_t cer_M_Ddm_Subscribe_Attributes_getAttributesSize(cer_M_Ddm_Subscribe_Attributes_t* cthis);
void cer_M_Ddm_Subscribe_Attributes_setAttributesSize(cer_M_Ddm_Subscribe_Attributes_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Ddm_Subscribe_Attributes_getAttributes(cer_M_Ddm_Subscribe_Attributes_t* cthis, uint32_t rank);
void cer_M_Ddm_Subscribe_Attributes_setAttributes(cer_M_Ddm_Subscribe_Attributes_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Ddm_Subscribe_Attributes_show(FILE* out);
/* ---------------------- END <M_Ddm_Subscribe_Attributes> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Unsubscribe_Attributes> ------------------------ */

typedef struct  cer_M_Ddm_Unsubscribe_Attributes {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   cer_RegionHandle_t region;
} cer_M_Ddm_Unsubscribe_Attributes_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Ddm_Unsubscribe_Attributes_t* cer_M_Ddm_Unsubscribe_Attributes_create(uint32_t nb);
/* Destructor function */
void cer_M_Ddm_Unsubscribe_Attributes_destroy(cer_M_Ddm_Unsubscribe_Attributes_t** cthis);

/* Serialize function */
void cer_M_Ddm_Unsubscribe_Attributes_serialize(cer_M_Ddm_Unsubscribe_Attributes_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Ddm_Unsubscribe_Attributes_deserialize(cer_M_Ddm_Unsubscribe_Attributes_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Ddm_Unsubscribe_Attributes_getObjectClass(cer_M_Ddm_Unsubscribe_Attributes_t* cthis) ;
void cer_M_Ddm_Unsubscribe_Attributes_setObjectClass(cer_M_Ddm_Unsubscribe_Attributes_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
cer_RegionHandle_t cer_M_Ddm_Unsubscribe_Attributes_getRegion(cer_M_Ddm_Unsubscribe_Attributes_t* cthis) ;
void cer_M_Ddm_Unsubscribe_Attributes_setRegion(cer_M_Ddm_Unsubscribe_Attributes_t* cthis,  cer_RegionHandle_t newRegion);
/* the show method */
FILE* M_Ddm_Unsubscribe_Attributes_show(FILE* out);
/* ---------------------- END <M_Ddm_Unsubscribe_Attributes> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Subscribe_Interaction> ------------------------ */

typedef struct  cer_M_Ddm_Subscribe_Interaction {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
   cer_RegionHandle_t region;
   uint8_t passive;
} cer_M_Ddm_Subscribe_Interaction_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Ddm_Subscribe_Interaction_t* cer_M_Ddm_Subscribe_Interaction_create(uint32_t nb);
/* Destructor function */
void cer_M_Ddm_Subscribe_Interaction_destroy(cer_M_Ddm_Subscribe_Interaction_t** cthis);

/* Serialize function */
void cer_M_Ddm_Subscribe_Interaction_serialize(cer_M_Ddm_Subscribe_Interaction_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Ddm_Subscribe_Interaction_deserialize(cer_M_Ddm_Subscribe_Interaction_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Ddm_Subscribe_Interaction_getInteractionClass(cer_M_Ddm_Subscribe_Interaction_t* cthis) ;
void cer_M_Ddm_Subscribe_Interaction_setInteractionClass(cer_M_Ddm_Subscribe_Interaction_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
cer_RegionHandle_t cer_M_Ddm_Subscribe_Interaction_getRegion(cer_M_Ddm_Subscribe_Interaction_t* cthis) ;
void cer_M_Ddm_Subscribe_Interaction_setRegion(cer_M_Ddm_Subscribe_Interaction_t* cthis,  cer_RegionHandle_t newRegion);
void cer_M_Ddm_Subscribe_Interaction_passiveOn(cer_M_Ddm_Subscribe_Interaction_t* cthis);
void cer_M_Ddm_Subscribe_Interaction_passiveOff(cer_M_Ddm_Subscribe_Interaction_t* cthis);
uint8_t isPassiveOn(cer_M_Ddm_Subscribe_Interaction* cthis) ;
/* the show method */
FILE* M_Ddm_Subscribe_Interaction_show(FILE* out);
/* ---------------------- END <M_Ddm_Subscribe_Interaction> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Unsubscribe_Interaction> ------------------------ */

typedef struct  cer_M_Ddm_Unsubscribe_Interaction {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
   cer_RegionHandle_t region;
   uint8_t passive;
} cer_M_Ddm_Unsubscribe_Interaction_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Ddm_Unsubscribe_Interaction_t* cer_M_Ddm_Unsubscribe_Interaction_create(uint32_t nb);
/* Destructor function */
void cer_M_Ddm_Unsubscribe_Interaction_destroy(cer_M_Ddm_Unsubscribe_Interaction_t** cthis);

/* Serialize function */
void cer_M_Ddm_Unsubscribe_Interaction_serialize(cer_M_Ddm_Unsubscribe_Interaction_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Ddm_Unsubscribe_Interaction_deserialize(cer_M_Ddm_Unsubscribe_Interaction_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Ddm_Unsubscribe_Interaction_getInteractionClass(cer_M_Ddm_Unsubscribe_Interaction_t* cthis) ;
void cer_M_Ddm_Unsubscribe_Interaction_setInteractionClass(cer_M_Ddm_Unsubscribe_Interaction_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
cer_RegionHandle_t cer_M_Ddm_Unsubscribe_Interaction_getRegion(cer_M_Ddm_Unsubscribe_Interaction_t* cthis) ;
void cer_M_Ddm_Unsubscribe_Interaction_setRegion(cer_M_Ddm_Unsubscribe_Interaction_t* cthis,  cer_RegionHandle_t newRegion);
void cer_M_Ddm_Unsubscribe_Interaction_passiveOn(cer_M_Ddm_Unsubscribe_Interaction_t* cthis);
void cer_M_Ddm_Unsubscribe_Interaction_passiveOff(cer_M_Ddm_Unsubscribe_Interaction_t* cthis);
uint8_t isPassiveOn(cer_M_Ddm_Unsubscribe_Interaction* cthis) ;
/* the show method */
FILE* M_Ddm_Unsubscribe_Interaction_show(FILE* out);
/* ---------------------- END <M_Ddm_Unsubscribe_Interaction> ------------------------ */

/* ---------------------- BEGIN <M_Ddm_Request_Update> ------------------------ */

typedef struct  cer_M_Ddm_Request_Update {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   cer_RegionHandle_t region;
   cer_AttributeHandle_t* attributes;
   uint32_t attributesSize;
} cer_M_Ddm_Request_Update_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Ddm_Request_Update_t* cer_M_Ddm_Request_Update_create(uint32_t nb);
/* Destructor function */
void cer_M_Ddm_Request_Update_destroy(cer_M_Ddm_Request_Update_t** cthis);

/* Serialize function */
void cer_M_Ddm_Request_Update_serialize(cer_M_Ddm_Request_Update_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Ddm_Request_Update_deserialize(cer_M_Ddm_Request_Update_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Ddm_Request_Update_getObjectClass(cer_M_Ddm_Request_Update_t* cthis) ;
void cer_M_Ddm_Request_Update_setObjectClass(cer_M_Ddm_Request_Update_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
cer_RegionHandle_t cer_M_Ddm_Request_Update_getRegion(cer_M_Ddm_Request_Update_t* cthis) ;
void cer_M_Ddm_Request_Update_setRegion(cer_M_Ddm_Request_Update_t* cthis,  cer_RegionHandle_t newRegion);
uint32_t cer_M_Ddm_Request_Update_getAttributesSize(cer_M_Ddm_Request_Update_t* cthis);
void cer_M_Ddm_Request_Update_setAttributesSize(cer_M_Ddm_Request_Update_t* cthis, uint32_t num);
cer_AttributeHandle_t cer_M_Ddm_Request_Update_getAttributes(cer_M_Ddm_Request_Update_t* cthis, uint32_t rank);
void cer_M_Ddm_Request_Update_setAttributes(cer_M_Ddm_Request_Update_t* cthis, cer_AttributeHandle_t newAttributes, uint32_t rank);
/* the show method */
FILE* M_Ddm_Request_Update_show(FILE* out);
/* ---------------------- END <M_Ddm_Request_Update> ------------------------ */

/* ---------------------- BEGIN <M_Get_Object_Class_Handle> ------------------------ */
/*  Support Services
 */
typedef struct  cer_M_Get_Object_Class_Handle {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   char* className;
} cer_M_Get_Object_Class_Handle_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Object_Class_Handle_t* cer_M_Get_Object_Class_Handle_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Object_Class_Handle_destroy(cer_M_Get_Object_Class_Handle_t** cthis);

/* Serialize function */
void cer_M_Get_Object_Class_Handle_serialize(cer_M_Get_Object_Class_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Object_Class_Handle_deserialize(cer_M_Get_Object_Class_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Get_Object_Class_Handle_getObjectClass(cer_M_Get_Object_Class_Handle_t* cthis) ;
void cer_M_Get_Object_Class_Handle_setObjectClass(cer_M_Get_Object_Class_Handle_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
char* cer_M_Get_Object_Class_Handle_getClassName(cer_M_Get_Object_Class_Handle_t* cthis) ;
void cer_M_Get_Object_Class_Handle_setClassName(cer_M_Get_Object_Class_Handle_t* cthis,  char* newClassName);
/* the show method */
FILE* M_Get_Object_Class_Handle_show(FILE* out);
/* ---------------------- END <M_Get_Object_Class_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Object_Class_Name> ------------------------ */

typedef struct  cer_M_Get_Object_Class_Name {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   char* className;
} cer_M_Get_Object_Class_Name_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Object_Class_Name_t* cer_M_Get_Object_Class_Name_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Object_Class_Name_destroy(cer_M_Get_Object_Class_Name_t** cthis);

/* Serialize function */
void cer_M_Get_Object_Class_Name_serialize(cer_M_Get_Object_Class_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Object_Class_Name_deserialize(cer_M_Get_Object_Class_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Get_Object_Class_Name_getObjectClass(cer_M_Get_Object_Class_Name_t* cthis) ;
void cer_M_Get_Object_Class_Name_setObjectClass(cer_M_Get_Object_Class_Name_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
char* cer_M_Get_Object_Class_Name_getClassName(cer_M_Get_Object_Class_Name_t* cthis) ;
void cer_M_Get_Object_Class_Name_setClassName(cer_M_Get_Object_Class_Name_t* cthis,  char* newClassName);
/* the show method */
FILE* M_Get_Object_Class_Name_show(FILE* out);
/* ---------------------- END <M_Get_Object_Class_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Attribute_Handle> ------------------------ */

typedef struct  cer_M_Get_Attribute_Handle {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   char* attributeName;
   cer_AttributeHandle_t attribute;
} cer_M_Get_Attribute_Handle_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Attribute_Handle_t* cer_M_Get_Attribute_Handle_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Attribute_Handle_destroy(cer_M_Get_Attribute_Handle_t** cthis);

/* Serialize function */
void cer_M_Get_Attribute_Handle_serialize(cer_M_Get_Attribute_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Attribute_Handle_deserialize(cer_M_Get_Attribute_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Get_Attribute_Handle_getObjectClass(cer_M_Get_Attribute_Handle_t* cthis) ;
void cer_M_Get_Attribute_Handle_setObjectClass(cer_M_Get_Attribute_Handle_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
char* cer_M_Get_Attribute_Handle_getAttributeName(cer_M_Get_Attribute_Handle_t* cthis) ;
void cer_M_Get_Attribute_Handle_setAttributeName(cer_M_Get_Attribute_Handle_t* cthis,  char* newAttributeName);
cer_AttributeHandle_t cer_M_Get_Attribute_Handle_getAttribute(cer_M_Get_Attribute_Handle_t* cthis) ;
void cer_M_Get_Attribute_Handle_setAttribute(cer_M_Get_Attribute_Handle_t* cthis,  cer_AttributeHandle_t newAttribute);
/* the show method */
FILE* M_Get_Attribute_Handle_show(FILE* out);
/* ---------------------- END <M_Get_Attribute_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Attribute_Name> ------------------------ */

typedef struct  cer_M_Get_Attribute_Name {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   char* attributeName;
   cer_AttributeHandle_t attribute;
} cer_M_Get_Attribute_Name_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Attribute_Name_t* cer_M_Get_Attribute_Name_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Attribute_Name_destroy(cer_M_Get_Attribute_Name_t** cthis);

/* Serialize function */
void cer_M_Get_Attribute_Name_serialize(cer_M_Get_Attribute_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Attribute_Name_deserialize(cer_M_Get_Attribute_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Get_Attribute_Name_getObjectClass(cer_M_Get_Attribute_Name_t* cthis) ;
void cer_M_Get_Attribute_Name_setObjectClass(cer_M_Get_Attribute_Name_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
char* cer_M_Get_Attribute_Name_getAttributeName(cer_M_Get_Attribute_Name_t* cthis) ;
void cer_M_Get_Attribute_Name_setAttributeName(cer_M_Get_Attribute_Name_t* cthis,  char* newAttributeName);
cer_AttributeHandle_t cer_M_Get_Attribute_Name_getAttribute(cer_M_Get_Attribute_Name_t* cthis) ;
void cer_M_Get_Attribute_Name_setAttribute(cer_M_Get_Attribute_Name_t* cthis,  cer_AttributeHandle_t newAttribute);
/* the show method */
FILE* M_Get_Attribute_Name_show(FILE* out);
/* ---------------------- END <M_Get_Attribute_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Interaction_Class_Handle> ------------------------ */

typedef struct  cer_M_Get_Interaction_Class_Handle {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
   char* className;
} cer_M_Get_Interaction_Class_Handle_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Interaction_Class_Handle_t* cer_M_Get_Interaction_Class_Handle_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Interaction_Class_Handle_destroy(cer_M_Get_Interaction_Class_Handle_t** cthis);

/* Serialize function */
void cer_M_Get_Interaction_Class_Handle_serialize(cer_M_Get_Interaction_Class_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Interaction_Class_Handle_deserialize(cer_M_Get_Interaction_Class_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Get_Interaction_Class_Handle_getInteractionClass(cer_M_Get_Interaction_Class_Handle_t* cthis) ;
void cer_M_Get_Interaction_Class_Handle_setInteractionClass(cer_M_Get_Interaction_Class_Handle_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
char* cer_M_Get_Interaction_Class_Handle_getClassName(cer_M_Get_Interaction_Class_Handle_t* cthis) ;
void cer_M_Get_Interaction_Class_Handle_setClassName(cer_M_Get_Interaction_Class_Handle_t* cthis,  char* newClassName);
/* the show method */
FILE* M_Get_Interaction_Class_Handle_show(FILE* out);
/* ---------------------- END <M_Get_Interaction_Class_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Interaction_Class_Name> ------------------------ */

typedef struct  cer_M_Get_Interaction_Class_Name {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
   char* className;
} cer_M_Get_Interaction_Class_Name_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Interaction_Class_Name_t* cer_M_Get_Interaction_Class_Name_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Interaction_Class_Name_destroy(cer_M_Get_Interaction_Class_Name_t** cthis);

/* Serialize function */
void cer_M_Get_Interaction_Class_Name_serialize(cer_M_Get_Interaction_Class_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Interaction_Class_Name_deserialize(cer_M_Get_Interaction_Class_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Get_Interaction_Class_Name_getInteractionClass(cer_M_Get_Interaction_Class_Name_t* cthis) ;
void cer_M_Get_Interaction_Class_Name_setInteractionClass(cer_M_Get_Interaction_Class_Name_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
char* cer_M_Get_Interaction_Class_Name_getClassName(cer_M_Get_Interaction_Class_Name_t* cthis) ;
void cer_M_Get_Interaction_Class_Name_setClassName(cer_M_Get_Interaction_Class_Name_t* cthis,  char* newClassName);
/* the show method */
FILE* M_Get_Interaction_Class_Name_show(FILE* out);
/* ---------------------- END <M_Get_Interaction_Class_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Parameter_Handle> ------------------------ */

typedef struct  cer_M_Get_Parameter_Handle {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
   char* parameterName;
   cer_ParameterHandle_t parameter;
} cer_M_Get_Parameter_Handle_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Parameter_Handle_t* cer_M_Get_Parameter_Handle_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Parameter_Handle_destroy(cer_M_Get_Parameter_Handle_t** cthis);

/* Serialize function */
void cer_M_Get_Parameter_Handle_serialize(cer_M_Get_Parameter_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Parameter_Handle_deserialize(cer_M_Get_Parameter_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Get_Parameter_Handle_getInteractionClass(cer_M_Get_Parameter_Handle_t* cthis) ;
void cer_M_Get_Parameter_Handle_setInteractionClass(cer_M_Get_Parameter_Handle_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
char* cer_M_Get_Parameter_Handle_getParameterName(cer_M_Get_Parameter_Handle_t* cthis) ;
void cer_M_Get_Parameter_Handle_setParameterName(cer_M_Get_Parameter_Handle_t* cthis,  char* newParameterName);
cer_ParameterHandle_t cer_M_Get_Parameter_Handle_getParameter(cer_M_Get_Parameter_Handle_t* cthis) ;
void cer_M_Get_Parameter_Handle_setParameter(cer_M_Get_Parameter_Handle_t* cthis,  cer_ParameterHandle_t newParameter);
/* the show method */
FILE* M_Get_Parameter_Handle_show(FILE* out);
/* ---------------------- END <M_Get_Parameter_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Parameter_Name> ------------------------ */

typedef struct  cer_M_Get_Parameter_Name {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
   char* parameterName;
   cer_ParameterHandle_t parameter;
} cer_M_Get_Parameter_Name_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Parameter_Name_t* cer_M_Get_Parameter_Name_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Parameter_Name_destroy(cer_M_Get_Parameter_Name_t** cthis);

/* Serialize function */
void cer_M_Get_Parameter_Name_serialize(cer_M_Get_Parameter_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Parameter_Name_deserialize(cer_M_Get_Parameter_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Get_Parameter_Name_getInteractionClass(cer_M_Get_Parameter_Name_t* cthis) ;
void cer_M_Get_Parameter_Name_setInteractionClass(cer_M_Get_Parameter_Name_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
char* cer_M_Get_Parameter_Name_getParameterName(cer_M_Get_Parameter_Name_t* cthis) ;
void cer_M_Get_Parameter_Name_setParameterName(cer_M_Get_Parameter_Name_t* cthis,  char* newParameterName);
cer_ParameterHandle_t cer_M_Get_Parameter_Name_getParameter(cer_M_Get_Parameter_Name_t* cthis) ;
void cer_M_Get_Parameter_Name_setParameter(cer_M_Get_Parameter_Name_t* cthis,  cer_ParameterHandle_t newParameter);
/* the show method */
FILE* M_Get_Parameter_Name_show(FILE* out);
/* ---------------------- END <M_Get_Parameter_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Object_Instance_Handle> ------------------------ */

typedef struct  cer_M_Get_Object_Instance_Handle {
   Message super;
   cer_ObjectHandle_t object;
   char* objectInstanceName;
} cer_M_Get_Object_Instance_Handle_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Object_Instance_Handle_t* cer_M_Get_Object_Instance_Handle_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Object_Instance_Handle_destroy(cer_M_Get_Object_Instance_Handle_t** cthis);

/* Serialize function */
void cer_M_Get_Object_Instance_Handle_serialize(cer_M_Get_Object_Instance_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Object_Instance_Handle_deserialize(cer_M_Get_Object_Instance_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Get_Object_Instance_Handle_getObject(cer_M_Get_Object_Instance_Handle_t* cthis) ;
void cer_M_Get_Object_Instance_Handle_setObject(cer_M_Get_Object_Instance_Handle_t* cthis,  cer_ObjectHandle_t newObject);
char* cer_M_Get_Object_Instance_Handle_getObjectInstanceName(cer_M_Get_Object_Instance_Handle_t* cthis) ;
void cer_M_Get_Object_Instance_Handle_setObjectInstanceName(cer_M_Get_Object_Instance_Handle_t* cthis,  char* newObjectInstanceName);
/* the show method */
FILE* M_Get_Object_Instance_Handle_show(FILE* out);
/* ---------------------- END <M_Get_Object_Instance_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Object_Instance_Name> ------------------------ */

typedef struct  cer_M_Get_Object_Instance_Name {
   Message super;
   cer_ObjectHandle_t object;
   char* objectInstanceName;
} cer_M_Get_Object_Instance_Name_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Object_Instance_Name_t* cer_M_Get_Object_Instance_Name_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Object_Instance_Name_destroy(cer_M_Get_Object_Instance_Name_t** cthis);

/* Serialize function */
void cer_M_Get_Object_Instance_Name_serialize(cer_M_Get_Object_Instance_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Object_Instance_Name_deserialize(cer_M_Get_Object_Instance_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectHandle_t cer_M_Get_Object_Instance_Name_getObject(cer_M_Get_Object_Instance_Name_t* cthis) ;
void cer_M_Get_Object_Instance_Name_setObject(cer_M_Get_Object_Instance_Name_t* cthis,  cer_ObjectHandle_t newObject);
char* cer_M_Get_Object_Instance_Name_getObjectInstanceName(cer_M_Get_Object_Instance_Name_t* cthis) ;
void cer_M_Get_Object_Instance_Name_setObjectInstanceName(cer_M_Get_Object_Instance_Name_t* cthis,  char* newObjectInstanceName);
/* the show method */
FILE* M_Get_Object_Instance_Name_show(FILE* out);
/* ---------------------- END <M_Get_Object_Instance_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Space_Handle> ------------------------ */

typedef struct  cer_M_Get_Space_Handle {
   Message super;
   char* spaceName;
   cer_SpaceHandle_t space;
} cer_M_Get_Space_Handle_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Space_Handle_t* cer_M_Get_Space_Handle_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Space_Handle_destroy(cer_M_Get_Space_Handle_t** cthis);

/* Serialize function */
void cer_M_Get_Space_Handle_serialize(cer_M_Get_Space_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Space_Handle_deserialize(cer_M_Get_Space_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Space_Handle_getSpaceName(cer_M_Get_Space_Handle_t* cthis) ;
void cer_M_Get_Space_Handle_setSpaceName(cer_M_Get_Space_Handle_t* cthis,  char* newSpaceName);
cer_SpaceHandle_t cer_M_Get_Space_Handle_getSpace(cer_M_Get_Space_Handle_t* cthis) ;
void cer_M_Get_Space_Handle_setSpace(cer_M_Get_Space_Handle_t* cthis,  cer_SpaceHandle_t newSpace);
/* the show method */
FILE* M_Get_Space_Handle_show(FILE* out);
/* ---------------------- END <M_Get_Space_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Space_Name> ------------------------ */

typedef struct  cer_M_Get_Space_Name {
   Message super;
   char* spaceName;
   cer_SpaceHandle_t space;
} cer_M_Get_Space_Name_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Space_Name_t* cer_M_Get_Space_Name_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Space_Name_destroy(cer_M_Get_Space_Name_t** cthis);

/* Serialize function */
void cer_M_Get_Space_Name_serialize(cer_M_Get_Space_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Space_Name_deserialize(cer_M_Get_Space_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Space_Name_getSpaceName(cer_M_Get_Space_Name_t* cthis) ;
void cer_M_Get_Space_Name_setSpaceName(cer_M_Get_Space_Name_t* cthis,  char* newSpaceName);
cer_SpaceHandle_t cer_M_Get_Space_Name_getSpace(cer_M_Get_Space_Name_t* cthis) ;
void cer_M_Get_Space_Name_setSpace(cer_M_Get_Space_Name_t* cthis,  cer_SpaceHandle_t newSpace);
/* the show method */
FILE* M_Get_Space_Name_show(FILE* out);
/* ---------------------- END <M_Get_Space_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Dimension_Handle> ------------------------ */

typedef struct  cer_M_Get_Dimension_Handle {
   Message super;
   char* dimensionName;
   cer_SpaceHandle_t space;
   cer_DimensionHandle_t dimension;
} cer_M_Get_Dimension_Handle_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Dimension_Handle_t* cer_M_Get_Dimension_Handle_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Dimension_Handle_destroy(cer_M_Get_Dimension_Handle_t** cthis);

/* Serialize function */
void cer_M_Get_Dimension_Handle_serialize(cer_M_Get_Dimension_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Dimension_Handle_deserialize(cer_M_Get_Dimension_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Dimension_Handle_getDimensionName(cer_M_Get_Dimension_Handle_t* cthis) ;
void cer_M_Get_Dimension_Handle_setDimensionName(cer_M_Get_Dimension_Handle_t* cthis,  char* newDimensionName);
cer_SpaceHandle_t cer_M_Get_Dimension_Handle_getSpace(cer_M_Get_Dimension_Handle_t* cthis) ;
void cer_M_Get_Dimension_Handle_setSpace(cer_M_Get_Dimension_Handle_t* cthis,  cer_SpaceHandle_t newSpace);
cer_DimensionHandle_t cer_M_Get_Dimension_Handle_getDimension(cer_M_Get_Dimension_Handle_t* cthis) ;
void cer_M_Get_Dimension_Handle_setDimension(cer_M_Get_Dimension_Handle_t* cthis,  cer_DimensionHandle_t newDimension);
/* the show method */
FILE* M_Get_Dimension_Handle_show(FILE* out);
/* ---------------------- END <M_Get_Dimension_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Dimension_Name> ------------------------ */

typedef struct  cer_M_Get_Dimension_Name {
   Message super;
   char* dimensionName;
   cer_SpaceHandle_t space;
   cer_DimensionHandle_t dimension;
} cer_M_Get_Dimension_Name_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Dimension_Name_t* cer_M_Get_Dimension_Name_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Dimension_Name_destroy(cer_M_Get_Dimension_Name_t** cthis);

/* Serialize function */
void cer_M_Get_Dimension_Name_serialize(cer_M_Get_Dimension_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Dimension_Name_deserialize(cer_M_Get_Dimension_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Dimension_Name_getDimensionName(cer_M_Get_Dimension_Name_t* cthis) ;
void cer_M_Get_Dimension_Name_setDimensionName(cer_M_Get_Dimension_Name_t* cthis,  char* newDimensionName);
cer_SpaceHandle_t cer_M_Get_Dimension_Name_getSpace(cer_M_Get_Dimension_Name_t* cthis) ;
void cer_M_Get_Dimension_Name_setSpace(cer_M_Get_Dimension_Name_t* cthis,  cer_SpaceHandle_t newSpace);
cer_DimensionHandle_t cer_M_Get_Dimension_Name_getDimension(cer_M_Get_Dimension_Name_t* cthis) ;
void cer_M_Get_Dimension_Name_setDimension(cer_M_Get_Dimension_Name_t* cthis,  cer_DimensionHandle_t newDimension);
/* the show method */
FILE* M_Get_Dimension_Name_show(FILE* out);
/* ---------------------- END <M_Get_Dimension_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Attribute_Space_Handle> ------------------------ */

typedef struct  cer_M_Get_Attribute_Space_Handle {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   cer_AttributeHandle_t attribute;
   cer_SpaceHandle_t space;
} cer_M_Get_Attribute_Space_Handle_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Attribute_Space_Handle_t* cer_M_Get_Attribute_Space_Handle_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Attribute_Space_Handle_destroy(cer_M_Get_Attribute_Space_Handle_t** cthis);

/* Serialize function */
void cer_M_Get_Attribute_Space_Handle_serialize(cer_M_Get_Attribute_Space_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Attribute_Space_Handle_deserialize(cer_M_Get_Attribute_Space_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Get_Attribute_Space_Handle_getObjectClass(cer_M_Get_Attribute_Space_Handle_t* cthis) ;
void cer_M_Get_Attribute_Space_Handle_setObjectClass(cer_M_Get_Attribute_Space_Handle_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
cer_AttributeHandle_t cer_M_Get_Attribute_Space_Handle_getAttribute(cer_M_Get_Attribute_Space_Handle_t* cthis) ;
void cer_M_Get_Attribute_Space_Handle_setAttribute(cer_M_Get_Attribute_Space_Handle_t* cthis,  cer_AttributeHandle_t newAttribute);
cer_SpaceHandle_t cer_M_Get_Attribute_Space_Handle_getSpace(cer_M_Get_Attribute_Space_Handle_t* cthis) ;
void cer_M_Get_Attribute_Space_Handle_setSpace(cer_M_Get_Attribute_Space_Handle_t* cthis,  cer_SpaceHandle_t newSpace);
/* the show method */
FILE* M_Get_Attribute_Space_Handle_show(FILE* out);
/* ---------------------- END <M_Get_Attribute_Space_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Object_Class> ------------------------ */

typedef struct  cer_M_Get_Object_Class {
   Message super;
   cer_ObjectClassHandle_t objectClass;
   cer_ObjectHandle_t object;
} cer_M_Get_Object_Class_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Object_Class_t* cer_M_Get_Object_Class_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Object_Class_destroy(cer_M_Get_Object_Class_t** cthis);

/* Serialize function */
void cer_M_Get_Object_Class_serialize(cer_M_Get_Object_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Object_Class_deserialize(cer_M_Get_Object_Class_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_ObjectClassHandle_t cer_M_Get_Object_Class_getObjectClass(cer_M_Get_Object_Class_t* cthis) ;
void cer_M_Get_Object_Class_setObjectClass(cer_M_Get_Object_Class_t* cthis,  cer_ObjectClassHandle_t newObjectClass);
cer_ObjectHandle_t cer_M_Get_Object_Class_getObject(cer_M_Get_Object_Class_t* cthis) ;
void cer_M_Get_Object_Class_setObject(cer_M_Get_Object_Class_t* cthis,  cer_ObjectHandle_t newObject);
/* the show method */
FILE* M_Get_Object_Class_show(FILE* out);
/* ---------------------- END <M_Get_Object_Class> ------------------------ */

/* ---------------------- BEGIN <M_Get_Interaction_Space_Handle> ------------------------ */

typedef struct  cer_M_Get_Interaction_Space_Handle {
   Message super;
   cer_InteractionClassHandle_t interactionClass;
   cer_SpaceHandle_t space;
} cer_M_Get_Interaction_Space_Handle_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Interaction_Space_Handle_t* cer_M_Get_Interaction_Space_Handle_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Interaction_Space_Handle_destroy(cer_M_Get_Interaction_Space_Handle_t** cthis);

/* Serialize function */
void cer_M_Get_Interaction_Space_Handle_serialize(cer_M_Get_Interaction_Space_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Interaction_Space_Handle_deserialize(cer_M_Get_Interaction_Space_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
cer_InteractionClassHandle_t cer_M_Get_Interaction_Space_Handle_getInteractionClass(cer_M_Get_Interaction_Space_Handle_t* cthis) ;
void cer_M_Get_Interaction_Space_Handle_setInteractionClass(cer_M_Get_Interaction_Space_Handle_t* cthis,  cer_InteractionClassHandle_t newInteractionClass);
cer_SpaceHandle_t cer_M_Get_Interaction_Space_Handle_getSpace(cer_M_Get_Interaction_Space_Handle_t* cthis) ;
void cer_M_Get_Interaction_Space_Handle_setSpace(cer_M_Get_Interaction_Space_Handle_t* cthis,  cer_SpaceHandle_t newSpace);
/* the show method */
FILE* M_Get_Interaction_Space_Handle_show(FILE* out);
/* ---------------------- END <M_Get_Interaction_Space_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Transportation_Handle> ------------------------ */

typedef struct  cer_M_Get_Transportation_Handle {
   Message super;
   char* transportationName;
   cer_TransportType_t transportation;
} cer_M_Get_Transportation_Handle_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Transportation_Handle_t* cer_M_Get_Transportation_Handle_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Transportation_Handle_destroy(cer_M_Get_Transportation_Handle_t** cthis);

/* Serialize function */
void cer_M_Get_Transportation_Handle_serialize(cer_M_Get_Transportation_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Transportation_Handle_deserialize(cer_M_Get_Transportation_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Transportation_Handle_getTransportationName(cer_M_Get_Transportation_Handle_t* cthis) ;
void cer_M_Get_Transportation_Handle_setTransportationName(cer_M_Get_Transportation_Handle_t* cthis,  char* newTransportationName);
cer_TransportType_t cer_M_Get_Transportation_Handle_getTransportation(cer_M_Get_Transportation_Handle_t* cthis) ;
void cer_M_Get_Transportation_Handle_setTransportation(cer_M_Get_Transportation_Handle_t* cthis,  cer_TransportType_t newTransportation);
/* the show method */
FILE* M_Get_Transportation_Handle_show(FILE* out);
/* ---------------------- END <M_Get_Transportation_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Transportation_Name> ------------------------ */

typedef struct  cer_M_Get_Transportation_Name {
   Message super;
   char* transportationName;
   cer_TransportType_t transportation;
} cer_M_Get_Transportation_Name_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Transportation_Name_t* cer_M_Get_Transportation_Name_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Transportation_Name_destroy(cer_M_Get_Transportation_Name_t** cthis);

/* Serialize function */
void cer_M_Get_Transportation_Name_serialize(cer_M_Get_Transportation_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Transportation_Name_deserialize(cer_M_Get_Transportation_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Transportation_Name_getTransportationName(cer_M_Get_Transportation_Name_t* cthis) ;
void cer_M_Get_Transportation_Name_setTransportationName(cer_M_Get_Transportation_Name_t* cthis,  char* newTransportationName);
cer_TransportType_t cer_M_Get_Transportation_Name_getTransportation(cer_M_Get_Transportation_Name_t* cthis) ;
void cer_M_Get_Transportation_Name_setTransportation(cer_M_Get_Transportation_Name_t* cthis,  cer_TransportType_t newTransportation);
/* the show method */
FILE* M_Get_Transportation_Name_show(FILE* out);
/* ---------------------- END <M_Get_Transportation_Name> ------------------------ */

/* ---------------------- BEGIN <M_Get_Ordering_Handle> ------------------------ */

typedef struct  cer_M_Get_Ordering_Handle {
   Message super;
   char* orderingName;
   cer_OrderType_t ordering;
} cer_M_Get_Ordering_Handle_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Ordering_Handle_t* cer_M_Get_Ordering_Handle_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Ordering_Handle_destroy(cer_M_Get_Ordering_Handle_t** cthis);

/* Serialize function */
void cer_M_Get_Ordering_Handle_serialize(cer_M_Get_Ordering_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Ordering_Handle_deserialize(cer_M_Get_Ordering_Handle_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Ordering_Handle_getOrderingName(cer_M_Get_Ordering_Handle_t* cthis) ;
void cer_M_Get_Ordering_Handle_setOrderingName(cer_M_Get_Ordering_Handle_t* cthis,  char* newOrderingName);
cer_OrderType_t cer_M_Get_Ordering_Handle_getOrdering(cer_M_Get_Ordering_Handle_t* cthis) ;
void cer_M_Get_Ordering_Handle_setOrdering(cer_M_Get_Ordering_Handle_t* cthis,  cer_OrderType_t newOrdering);
/* the show method */
FILE* M_Get_Ordering_Handle_show(FILE* out);
/* ---------------------- END <M_Get_Ordering_Handle> ------------------------ */

/* ---------------------- BEGIN <M_Get_Ordering_Name> ------------------------ */

typedef struct  cer_M_Get_Ordering_Name {
   Message super;
   char* orderingName;
   cer_OrderType_t ordering;
} cer_M_Get_Ordering_Name_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Get_Ordering_Name_t* cer_M_Get_Ordering_Name_create(uint32_t nb);
/* Destructor function */
void cer_M_Get_Ordering_Name_destroy(cer_M_Get_Ordering_Name_t** cthis);

/* Serialize function */
void cer_M_Get_Ordering_Name_serialize(cer_M_Get_Ordering_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Get_Ordering_Name_deserialize(cer_M_Get_Ordering_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
char* cer_M_Get_Ordering_Name_getOrderingName(cer_M_Get_Ordering_Name_t* cthis) ;
void cer_M_Get_Ordering_Name_setOrderingName(cer_M_Get_Ordering_Name_t* cthis,  char* newOrderingName);
cer_OrderType_t cer_M_Get_Ordering_Name_getOrdering(cer_M_Get_Ordering_Name_t* cthis) ;
void cer_M_Get_Ordering_Name_setOrdering(cer_M_Get_Ordering_Name_t* cthis,  cer_OrderType_t newOrdering);
/* the show method */
FILE* M_Get_Ordering_Name_show(FILE* out);
/* ---------------------- END <M_Get_Ordering_Name> ------------------------ */

/* ---------------------- BEGIN <M_Enable_Class_Relevance_Advisory_Switch> ------------------------ */

typedef struct  cer_M_Enable_Class_Relevance_Advisory_Switch {
   Message super;
} cer_M_Enable_Class_Relevance_Advisory_Switch_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Enable_Class_Relevance_Advisory_Switch_t* cer_M_Enable_Class_Relevance_Advisory_Switch_create(uint32_t nb);
/* Destructor function */
void cer_M_Enable_Class_Relevance_Advisory_Switch_destroy(cer_M_Enable_Class_Relevance_Advisory_Switch_t** cthis);

/* ---------------------- BEGIN <M_Disable_Class_Relevance_Advisory_Switch> ------------------------ */

typedef struct  cer_M_Disable_Class_Relevance_Advisory_Switch {
   Message super;
} cer_M_Disable_Class_Relevance_Advisory_Switch_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Disable_Class_Relevance_Advisory_Switch_t* cer_M_Disable_Class_Relevance_Advisory_Switch_create(uint32_t nb);
/* Destructor function */
void cer_M_Disable_Class_Relevance_Advisory_Switch_destroy(cer_M_Disable_Class_Relevance_Advisory_Switch_t** cthis);

/* ---------------------- BEGIN <M_Enable_Attribute_Relevance_Advisory_Switch> ------------------------ */

typedef struct  cer_M_Enable_Attribute_Relevance_Advisory_Switch {
   Message super;
} cer_M_Enable_Attribute_Relevance_Advisory_Switch_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Enable_Attribute_Relevance_Advisory_Switch_t* cer_M_Enable_Attribute_Relevance_Advisory_Switch_create(uint32_t nb);
/* Destructor function */
void cer_M_Enable_Attribute_Relevance_Advisory_Switch_destroy(cer_M_Enable_Attribute_Relevance_Advisory_Switch_t** cthis);

/* ---------------------- BEGIN <M_Disable_Attribute_Relevance_Advisory_Switch> ------------------------ */

typedef struct  cer_M_Disable_Attribute_Relevance_Advisory_Switch {
   Message super;
} cer_M_Disable_Attribute_Relevance_Advisory_Switch_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Disable_Attribute_Relevance_Advisory_Switch_t* cer_M_Disable_Attribute_Relevance_Advisory_Switch_create(uint32_t nb);
/* Destructor function */
void cer_M_Disable_Attribute_Relevance_Advisory_Switch_destroy(cer_M_Disable_Attribute_Relevance_Advisory_Switch_t** cthis);

/* ---------------------- BEGIN <M_Enable_Attribute_Scope_Advisory_Switch> ------------------------ */

typedef struct  cer_M_Enable_Attribute_Scope_Advisory_Switch {
   Message super;
} cer_M_Enable_Attribute_Scope_Advisory_Switch_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Enable_Attribute_Scope_Advisory_Switch_t* cer_M_Enable_Attribute_Scope_Advisory_Switch_create(uint32_t nb);
/* Destructor function */
void cer_M_Enable_Attribute_Scope_Advisory_Switch_destroy(cer_M_Enable_Attribute_Scope_Advisory_Switch_t** cthis);

/* ---------------------- BEGIN <M_Disable_Attribute_Scope_Advisory_Switch> ------------------------ */

typedef struct  cer_M_Disable_Attribute_Scope_Advisory_Switch {
   Message super;
} cer_M_Disable_Attribute_Scope_Advisory_Switch_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Disable_Attribute_Scope_Advisory_Switch_t* cer_M_Disable_Attribute_Scope_Advisory_Switch_create(uint32_t nb);
/* Destructor function */
void cer_M_Disable_Attribute_Scope_Advisory_Switch_destroy(cer_M_Disable_Attribute_Scope_Advisory_Switch_t** cthis);

/* ---------------------- BEGIN <M_Enable_Interaction_Relevance_Advisory_Switch> ------------------------ */

typedef struct  cer_M_Enable_Interaction_Relevance_Advisory_Switch {
   Message super;
} cer_M_Enable_Interaction_Relevance_Advisory_Switch_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Enable_Interaction_Relevance_Advisory_Switch_t* cer_M_Enable_Interaction_Relevance_Advisory_Switch_create(uint32_t nb);
/* Destructor function */
void cer_M_Enable_Interaction_Relevance_Advisory_Switch_destroy(cer_M_Enable_Interaction_Relevance_Advisory_Switch_t** cthis);

/* ---------------------- BEGIN <M_Disable_Interaction_Relevance_Advisory_Switch> ------------------------ */

typedef struct  cer_M_Disable_Interaction_Relevance_Advisory_Switch {
   Message super;
} cer_M_Disable_Interaction_Relevance_Advisory_Switch_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Disable_Interaction_Relevance_Advisory_Switch_t* cer_M_Disable_Interaction_Relevance_Advisory_Switch_create(uint32_t nb);
/* Destructor function */
void cer_M_Disable_Interaction_Relevance_Advisory_Switch_destroy(cer_M_Disable_Interaction_Relevance_Advisory_Switch_t** cthis);

/* ---------------------- BEGIN <M_Tick_Request> ------------------------ */

typedef struct  cer_M_Tick_Request {
   Message super;
   uint8_t multiple;
   double minTickTime;
   double maxTickTime;
} cer_M_Tick_Request_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Tick_Request_t* cer_M_Tick_Request_create(uint32_t nb);
/* Destructor function */
void cer_M_Tick_Request_destroy(cer_M_Tick_Request_t** cthis);

/* Serialize function */
void cer_M_Tick_Request_serialize(cer_M_Tick_Request_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Tick_Request_deserialize(cer_M_Tick_Request_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
uint8_t cer_M_Tick_Request_getMultiple(cer_M_Tick_Request_t* cthis) ;
void cer_M_Tick_Request_setMultiple(cer_M_Tick_Request_t* cthis,  uint8_t newMultiple);
double cer_M_Tick_Request_getMinTickTime(cer_M_Tick_Request_t* cthis) ;
void cer_M_Tick_Request_setMinTickTime(cer_M_Tick_Request_t* cthis,  double newMinTickTime);
double cer_M_Tick_Request_getMaxTickTime(cer_M_Tick_Request_t* cthis) ;
void cer_M_Tick_Request_setMaxTickTime(cer_M_Tick_Request_t* cthis,  double newMaxTickTime);
/* the show method */
FILE* M_Tick_Request_show(FILE* out);
/* ---------------------- END <M_Tick_Request> ------------------------ */

/* ---------------------- BEGIN <M_Tick_Request_Next> ------------------------ */

typedef struct  cer_M_Tick_Request_Next {
   Message super;
} cer_M_Tick_Request_Next_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Tick_Request_Next_t* cer_M_Tick_Request_Next_create(uint32_t nb);
/* Destructor function */
void cer_M_Tick_Request_Next_destroy(cer_M_Tick_Request_Next_t** cthis);

/* ---------------------- BEGIN <M_Tick_Request_Stop> ------------------------ */

typedef struct  cer_M_Tick_Request_Stop {
   Message super;
} cer_M_Tick_Request_Stop_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Tick_Request_Stop_t* cer_M_Tick_Request_Stop_create(uint32_t nb);
/* Destructor function */
void cer_M_Tick_Request_Stop_destroy(cer_M_Tick_Request_Stop_t** cthis);

/* ---------------------- BEGIN <M_Reserve_Object_Instance_Name> ------------------------ */
/*  HLA 1516 - §6.2
 */
typedef struct  cer_M_Reserve_Object_Instance_Name {
   Message super;
   char* objectName;
} cer_M_Reserve_Object_Instance_Name_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Reserve_Object_Instance_Name_t* cer_M_Reserve_Object_Instance_Name_create(uint32_t nb);
/* Destructor function */
void cer_M_Reserve_Object_Instance_Name_destroy(cer_M_Reserve_Object_Instance_Name_t** cthis);

/* Serialize function */
void cer_M_Reserve_Object_Instance_Name_serialize(cer_M_Reserve_Object_Instance_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* DeSerialize function */
void cer_M_Reserve_Object_Instance_Name_deserialize(cer_M_Reserve_Object_Instance_Name_t* cthis, MsgBuffer_t* msgBuffer);
/* specific Getter(s)/Setter(s) */
char* cer_M_Reserve_Object_Instance_Name_getObjectName(cer_M_Reserve_Object_Instance_Name_t* cthis) ;
void cer_M_Reserve_Object_Instance_Name_setObjectName(cer_M_Reserve_Object_Instance_Name_t* cthis,  char* newObjectName);
/* the show method */
FILE* M_Reserve_Object_Instance_Name_show(FILE* out);
/* ---------------------- END <M_Reserve_Object_Instance_Name> ------------------------ */

/* ---------------------- BEGIN <M_Reserve_Object_Instance_Name_Succeeded> ------------------------ */
/*  HLA 1516 - §6.3
 */
typedef struct  cer_M_Reserve_Object_Instance_Name_Succeeded {
   M_Reserve_Object_Instance_Name super;
} cer_M_Reserve_Object_Instance_Name_Succeeded_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Reserve_Object_Instance_Name_Succeeded_t* cer_M_Reserve_Object_Instance_Name_Succeeded_create(uint32_t nb);
/* Destructor function */
void cer_M_Reserve_Object_Instance_Name_Succeeded_destroy(cer_M_Reserve_Object_Instance_Name_Succeeded_t** cthis);

/* ---------------------- BEGIN <M_Reserve_Object_Instance_Name_Failed> ------------------------ */

typedef struct  cer_M_Reserve_Object_Instance_Name_Failed {
   M_Reserve_Object_Instance_Name super;
} cer_M_Reserve_Object_Instance_Name_Failed_t; 

/* Creator function
 * @param[in] nb>0 is the number of element(s) to create (array)
 */
cer_M_Reserve_Object_Instance_Name_Failed_t* cer_M_Reserve_Object_Instance_Name_Failed_create(uint32_t nb);
/* Destructor function */
void cer_M_Reserve_Object_Instance_Name_Failed_destroy(cer_M_Reserve_Object_Instance_Name_Failed_t** cthis);


/*
Message* M_Factory_create(M_Type type); 
Message* M_Factory_receive(MStreamType stream); 
*/
/*  GG_H
#endif
