/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.Info;
import com.izforge.izpack.Pack;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.compiler.DynamicVariable;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.InstallerRequirement;
import com.izforge.izpack.installer.PrivilegedRunner;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallerBase {
    private static final String CONDITIONS_SPECRESOURCENAME = "conditions.xml";
    private RulesEngine rules;
    private List<InstallerRequirement> installerrequirements;
    private Map<String, List<DynamicVariable>> dynamicvariables;
    protected static final String LANG_FILE_NAME = "CustomLangpack.xml";

    public List<String> getAvailableLangPacks() throws Exception {
        InputStream inputStream = this.getClass().getResourceAsStream("/langpacks.info");
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        List list = (List)objectInputStream.readObject();
        objectInputStream.close();
        return list;
    }

    public RulesEngine getRules() {
        return this.rules;
    }

    public void loadInstallData(AutomatedInstallData automatedInstallData) throws Exception {
        Object object2;
        String string;
        String string2;
        Object object3;
        Object object4;
        ObjectInputStream objectInputStream;
        Properties properties = null;
        InputStream inputStream = InstallerBase.class.getResourceAsStream("/vars");
        if (null != inputStream) {
            objectInputStream = new ObjectInputStream(inputStream);
            properties = (Properties)objectInputStream.readObject();
            objectInputStream.close();
        }
        inputStream = InstallerBase.class.getResourceAsStream("/info");
        objectInputStream = new ObjectInputStream(inputStream);
        Info info = (Info)objectInputStream.readObject();
        objectInputStream.close();
        this.checkForPrivilegedExecution(info);
        automatedInstallData.setVariable("APP_NAME", info.getAppName());
        if (info.getAppURL() != null) {
            automatedInstallData.setVariable("APP_URL", info.getAppURL());
        }
        automatedInstallData.setVariable("APP_VER", info.getAppVersion());
        if (info.getUninstallerCondition() != null) {
            automatedInstallData.setVariable("UNINSTALLER_CONDITION", info.getUninstallerCondition());
        }
        inputStream = InstallerBase.class.getResourceAsStream("/panelsOrder");
        objectInputStream = new ObjectInputStream(inputStream);
        List list = (List)objectInputStream.readObject();
        objectInputStream.close();
        inputStream = InstallerBase.class.getResourceAsStream("/packs.info");
        objectInputStream = new ObjectInputStream(inputStream);
        int n = objectInputStream.readInt();
        ArrayList<Pack> arrayList = new ArrayList<Pack>();
        ArrayList<Pack> arrayList2 = new ArrayList<Pack>();
        for (int i = 0; i < n; ++i) {
            object4 = (Pack)objectInputStream.readObject();
            arrayList2.add((Pack)object4);
            if (!OsConstraint.oneMatchesCurrentSystem(((Pack)object4).osConstraints)) continue;
            arrayList.add((Pack)object4);
        }
        objectInputStream.close();
        object4 = OsVersion.IS_WINDOWS ? this.buildWindowsDefaultPath() : (OsVersion.IS_OSX ? "/Applications" : (new File("/usr/local/").canWrite() ? "/usr/local" : System.getProperty("user.home")));
        try {
            object3 = InetAddress.getLocalHost();
            string2 = ((InetAddress)object3).getHostAddress();
            string = ((InetAddress)object3).getHostName();
        }
        catch (Exception exception) {
            string = "";
            string2 = "";
        }
        automatedInstallData.setVariable("APPLICATIONS_DEFAULT_ROOT", (String)object4);
        object4 = (String)object4 + File.separator;
        automatedInstallData.setVariable("JAVA_HOME", System.getProperty("java.home"));
        automatedInstallData.setVariable("CLASS_PATH", System.getProperty("java.class.path"));
        automatedInstallData.setVariable("USER_HOME", System.getProperty("user.home"));
        automatedInstallData.setVariable("USER_NAME", System.getProperty("user.name"));
        automatedInstallData.setVariable("IP_ADDRESS", string2);
        automatedInstallData.setVariable("HOST_NAME", string);
        automatedInstallData.setVariable("FILE_SEPARATOR", File.separator);
        object3 = System.getProperties().keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            String object5 = System.getProperty((String)object2);
            if (object5 == null) continue;
            object2 = ((String)object2).replace('.', '_');
            automatedInstallData.setVariable("SYSTEM_" + object2, object5);
        }
        if (null != properties) {
            object2 = properties.keys();
            while (object2.hasMoreElements()) {
                String string3 = (String)object2.nextElement();
                String string4 = properties.getProperty(string3);
                automatedInstallData.setVariable(string3, string4);
            }
        }
        automatedInstallData.info = info;
        automatedInstallData.panelsOrder = list;
        automatedInstallData.availablePacks = arrayList;
        automatedInstallData.allPacks = arrayList2;
        for (Pack pack : arrayList) {
            if (!pack.preselected) continue;
            automatedInstallData.selectedPacks.add(pack);
        }
        String string5 = (String)object4 + info.getAppName();
        if (info.getInstallationSubPath() != null) {
            string5 = IoHelper.translatePath((String)object4 + info.getInstallationSubPath(), new VariableSubstitutor(automatedInstallData.getVariables()));
        }
        automatedInstallData.setInstallPath(string5);
        this.loadCustomData(automatedInstallData);
    }

    private void checkForPrivilegedExecution(Info info) {
        if (PrivilegedRunner.isPrivilegedMode()) {
            return;
        }
        if (info.isPrivilegedExecutionRequired()) {
            PrivilegedRunner privilegedRunner;
            boolean bl = true;
            String string = info.getPrivilegedExecutionConditionID();
            if (string != null) {
                bl = RulesEngine.getCondition(string).isTrue();
            }
            if ((privilegedRunner = new PrivilegedRunner(!bl)).isPlatformSupported() && privilegedRunner.isElevationNeeded()) {
                try {
                    if (privilegedRunner.relaunchWithElevatedRights() != 0) {
                        throw new RuntimeException("Launching an installer with elevated permissions failed.");
                    }
                    System.exit(0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(null, "The installer could not launch itself with administrator permissions.\nThe installation will still continue but you may encounter problems due to insufficient permissions.");
                }
            } else if (!privilegedRunner.isPlatformSupported()) {
                JOptionPane.showMessageDialog(null, "This installer should be run by an administrator.\nThe installation will still continue but you may encounter problems due to insufficient permissions.");
            }
        }
    }

    protected void addCustomLangpack(AutomatedInstallData automatedInstallData) {
        try {
            automatedInstallData.langpack.add(ResourceManager.getInstance().getInputStream(LANG_FILE_NAME));
        }
        catch (Throwable throwable) {
            Debug.trace("No custom langpack available.");
            return;
        }
        Debug.trace("Custom langpack for " + automatedInstallData.localeISO3 + " available.");
    }

    private String buildWindowsDefaultPath() {
        try {
            String string = IoHelper.getenv("ProgramFiles");
            if (string != null && string.length() > 0) {
                return string;
            }
            return this.buildWindowsDefaultPathFromProps();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.buildWindowsDefaultPathFromProps();
        }
    }

    private String buildWindowsDefaultPathFromProps() {
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            Properties properties = new Properties();
            properties.load(InstallerBase.class.getResourceAsStream("/com/izforge/izpack/installer/win32-defaultpaths.properties"));
            String string = System.getProperty("user.home");
            if (string.length() > 3) {
                string = string.substring(0, 3);
            }
            stringBuffer.append(string);
            if (string.length() == 2) {
                stringBuffer.append("\\");
            }
            String string2 = Locale.getDefault().getLanguage();
            String string3 = Locale.getDefault().getCountry();
            String string4 = string2 + "_" + string3;
            if (null != properties.getProperty(string4)) {
                stringBuffer.append(properties.getProperty(string4));
            } else if (null != properties.getProperty(string2)) {
                stringBuffer.append(properties.getProperty(string2));
            } else {
                stringBuffer.append(properties.getProperty(Locale.ENGLISH.getLanguage()));
            }
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer("C:\\Program Files");
        }
        return stringBuffer.toString();
    }

    private void loadCustomData(AutomatedInstallData automatedInstallData) throws Exception {
        int n;
        String[] stringArray = AutomatedInstallData.CUSTOM_ACTION_TYPES;
        List[] listArray = new List[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            listArray[n] = new ArrayList();
        }
        InputStream inputStream = InstallerBase.class.getResourceAsStream("/customData");
        if (inputStream != null) {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            Iterator iterator = ((List)object).iterator();
            while (iterator != null && iterator.hasNext()) {
                CustomData customData = (CustomData)iterator.next();
                if (customData.osConstraints != null && !OsConstraint.oneMatchesCurrentSystem(customData.osConstraints)) continue;
                switch (customData.type) {
                    case 0: {
                        Class<?> clazz = Class.forName(customData.listenerName);
                        if (clazz == null) {
                            throw new InstallerException("Custom action " + customData.listenerName + " not bound!");
                        }
                        listArray[customData.type].add(clazz.newInstance());
                        break;
                    }
                    case 1: 
                    case 3: {
                        listArray[customData.type].add(customData);
                        break;
                    }
                    case 2: {
                        listArray[customData.type].add(customData.contents);
                    }
                }
            }
            for (n = 0; n < stringArray.length; ++n) {
                automatedInstallData.customData.put(stringArray[n], listArray[n]);
            }
        }
    }

    protected void loadConditions(AutomatedInstallData automatedInstallData) {
        Object object;
        Object object2;
        InputStream inputStream;
        try {
            inputStream = InstallerBase.class.getResourceAsStream("/rules");
            object2 = new ObjectInputStream(inputStream);
            object = (Map)((ObjectInputStream)object2).readObject();
            if (object != null && object.size() != 0) {
                this.rules = new RulesEngine((Map<String, Condition>)object, automatedInstallData);
            }
            ((ObjectInputStream)object2).close();
        }
        catch (Exception exception) {
            Debug.trace("Can not find optional rules");
        }
        if (this.rules != null) {
            automatedInstallData.setRules(this.rules);
            return;
        }
        try {
            inputStream = null;
            inputStream = this.getResource(CONDITIONS_SPECRESOURCENAME);
            if (inputStream == null) {
                this.rules = new RulesEngine((IXMLElement)null, automatedInstallData);
                return;
            }
            object2 = new XMLParser();
            object = ((XMLParser)object2).parse(inputStream);
            this.rules = new RulesEngine((IXMLElement)object, automatedInstallData);
        }
        catch (Exception exception) {
            Debug.trace("Can not find optional resource conditions.xml");
            this.rules = new RulesEngine((IXMLElement)null, automatedInstallData);
        }
        automatedInstallData.setRules(this.rules);
    }

    protected void loadDynamicVariables() {
        try {
            InputStream inputStream = InstallerFrame.class.getResourceAsStream("/dynvariables");
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            this.dynamicvariables = (Map)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            Debug.trace("Cannot find optional dynamic variables");
            System.out.println(exception);
        }
    }

    public void loadInstallerRequirements() throws Exception {
        InputStream inputStream = InstallerBase.class.getResourceAsStream("/installerrequirements");
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this.installerrequirements = (List)objectInputStream.readObject();
        objectInputStream.close();
    }

    public boolean checkInstallerRequirements(AutomatedInstallData automatedInstallData) throws Exception {
        boolean bl = true;
        for (InstallerRequirement installerRequirement : this.installerrequirements) {
            String string = installerRequirement.getCondition();
            Condition condition = RulesEngine.getCondition(string);
            if (condition == null) {
                Debug.log(string + " not a valid condition.");
                throw new Exception(string + "could not be found as a defined condition");
            }
            if (condition.isTrue()) continue;
            String string2 = installerRequirement.getMessage();
            if (string2 != null && string2.length() > 0) {
                String string3 = automatedInstallData.langpack.getString(string2);
                this.showMissingRequirementMessage(string3);
            }
            bl = false;
            break;
        }
        return bl;
    }

    protected void showMissingRequirementMessage(String string) {
        Debug.log(string);
    }

    public InputStream getResource(String string) throws Exception {
        String string2 = "";
        ResourceManager resourceManager = null;
        try {
            resourceManager = ResourceManager.getInstance();
            string2 = resourceManager.resourceBasePath;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        InputStream inputStream = this.getClass().getResourceAsStream(string2 + string);
        if (inputStream == null) {
            throw new ResourceNotFoundException("Warning: Resource not found: " + string);
        }
        return inputStream;
    }

    protected void refreshDynamicVariables(VariableSubstitutor variableSubstitutor, AutomatedInstallData automatedInstallData) {
        Debug.log("refreshing dyamic variables.");
        if (this.dynamicvariables != null) {
            for (String string : this.dynamicvariables.keySet()) {
                Debug.log("Variable: " + string);
                for (DynamicVariable dynamicVariable : this.dynamicvariables.get(string)) {
                    boolean bl = false;
                    String string2 = dynamicVariable.getConditionid();
                    Debug.log("condition: " + string2);
                    if (string2 != null && string2.length() > 0) {
                        if (this.rules != null && this.rules.isConditionTrue(string2)) {
                            Debug.log("refresh condition");
                            bl = true;
                        }
                    } else {
                        Debug.log("refresh condition");
                        bl = true;
                    }
                    if (!bl) continue;
                    String string3 = variableSubstitutor.substitute(dynamicVariable.getValue(), null);
                    Debug.log("newvalue: " + string3);
                    automatedInstallData.variables.setProperty(dynamicVariable.getName(), string3);
                }
            }
        }
    }
}

