// -*- mode:C++; tab-width:4; c-basic-offset:4; indent-tabs-mode:nil -*- 
// ===========================================================================
// $Id: Fed.cc,v 1.4 2003/03/24 17:54:25 breholee Exp $
// ===========================================================================

#include "Fed.hh"

Fed::Fed(RTI::RTIambassador *rtia, 
         Federate* federate_, 
         Federation* federation_)
{
    this->rtiamb = rtia ;
    this->granted = false ;
    federate = federate_ ;
    federation = federation_ ;
    verbose = false ;
    id = -1 ;
}

Fed::~Fed()
{ 

}

// ===========================================================================
// 1. FEDERATION MANAGEMENT
// ===========================================================================

// ---------------------------------------------------------------------------
// 1.1 announceSynchronizationPoint
// ---------------------------------------------------------------------------
void 
Fed::announceSynchronizationPoint(const char* label_, const char* tag_)
    throw(FederateInternalError)
{
    if (verbose) {
        cout << "Callback(" << id << ") - Announce Synchronization Point : " 
             << label_ << endl ;
    }
    federate->announce(label_);
}

// FIXME: 1.2 federationNotRestored
// FIXME: 1.3 federationNotSaved
// FIXME: 1.4 federationRestoreBegun
// FIXME: 1.5 federationRestored
// FIXME: 1.6 federationSaved

// ---------------------------------------------------------------------------
// 1.7 federationSynchronized
// ---------------------------------------------------------------------------
void 
Fed::federationSynchronized(const char *label_)
    throw(FederateInternalError)
{ 
    federate->endSynchronization(label_);
}

// FIXME: 1.8 initiateFederateRestore
// FIXME: 1.9 initiateFederateSave
// FIXME: 1.10 requestFederationRestoreFailed
// FIXME: 1.11 requestFederationRestoreSucceeded

// ---------------------------------------------------------------------------
// 1.12 synchronisationPointRegistrationFailed
// ---------------------------------------------------------------------------
void 
Fed::synchronizationPointRegistrationFailed(const char *label_) 
    throw (FederateInternalError)
{
}

// ---------------------------------------------------------------------------
// 1.13 synchronisationPointRegistrationSucceeded
// ---------------------------------------------------------------------------

void 
Fed::synchronizationPointRegistrationSucceeded(const char *label_) 
    throw(FederateInternalError)
{
 
}

// ===========================================================================
// 2. DECLARATION MANAGEMENT
// ===========================================================================

// ---------------------------------------------------------------------------
// 2.1 startRegistrationForObjectClass
// ---------------------------------------------------------------------------
void 
Fed::startRegistrationForObjectClass(ObjectClassHandle theClass)
    throw (ObjectClassNotPublished, FederateInternalError)
{
}

// ---------------------------------------------------------------------------
// 2.2 stopRegistrationForObjectClass
// ---------------------------------------------------------------------------
void 
Fed::stopRegistrationForObjectClass(ObjectClassHandle theClass)
    throw (ObjectClassNotPublished, FederateInternalError)
{
}

// ---------------------------------------------------------------------------
// 2.3 turnInteractionsOff
// ---------------------------------------------------------------------------
void Fed::turnInteractionsOff(InteractionClassHandle theHandle) 
    throw (InteractionClassNotPublished, FederateInternalError)
{
}

// ---------------------------------------------------------------------------
// 2.4 turnInteractionsOn
// ---------------------------------------------------------------------------
void
Fed::turnInteractionsOn(InteractionClassHandle theHandle) 
    throw (InteractionClassNotPublished, FederateInternalError)
{

}

// ===========================================================================
// 3. OBJECT MANAGEMENT
// ===========================================================================

// FIXME: 3.1 attributesInScope
// FIXME: 3.2 attributesOutOfScope

// ---------------------------------------------------------------------------
// 3.3 discoverObjectInstance
// ---------------------------------------------------------------------------
void
Fed::discoverObjectInstance(ObjectHandle handle,
                            ObjectClassHandle class_handle, 
                            const char *name)
    throw (CouldNotDiscover, ObjectClassNotKnown, InvalidFederationTime,
           FederateInternalError)
{ 
    if (verbose) {
        cout << "Callback(" << id << ") - Discover Object Instance, "
             << "handle " << handle << ", class " << class_handle << ", name "
             << name << endl ;
    }

    federate->discoverObject(handle, class_handle, name);
}

// FIXME: 3.4 provideAttributeValueUpdate

// ---------------------------------------------------------------------------
// 3.5 receiveInteraction
// ---------------------------------------------------------------------------
void 
Fed::receiveInteraction(InteractionClassHandle interaction, 
                        const ParameterHandleValuePairSet& parameters, 
                        const FedTime& time, 
                        const char *tag, 
                        EventRetractionHandle theHandle) 
    throw (InteractionClassNotKnown, InteractionParameterNotKnown,
           InvalidFederationTime, FederateInternalError)
{
    if (verbose) {
    cout << "Callback(" << id << ") - Receive Interaction " 
         << interaction << endl ;
    }

    federate->receive(interaction, parameters, time);
}

// ---------------------------------------------------------------------------
// 3.6 reflectAttributeValues
// ---------------------------------------------------------------------------
void 
Fed::reflectAttributeValues(ObjectHandle object,
                            const AttributeHandleValuePairSet& attributes,
                            const FedTime& time, 
                            const char *tag, 
                            EventRetractionHandle theHandle) 
    throw (ObjectNotKnown, AttributeNotKnown, InvalidFederationTime,
           FederateInternalError)
{
    if (verbose) {
        cout << "Callback(" << id << ") - Reflect Attribute Values "
             << object << endl ;
    }

    federate->reflect(object, attributes, time);
}

// --------------------------------------------------------------------------
// 3.7 removeObjectInstance
// --------------------------------------------------------------------------
void
Fed::removeObjectInstance(ObjectHandle object, 
                          const FedTime& time, 
                          const char *tag, 
                          EventRetractionHandle theHandle) 
    throw (ObjectNotKnown, InvalidFederationTime, FederateInternalError)
{
    if (verbose) {
        cout << "Callback(" << id << ") - Remove Object Instance " 
             << object << endl ;
    }
    federate->removeObject(object, time);
}

// FIXME: 3.8 turnUpdatesOffForObjectInstance 
// FIXME: 3.9 turnUpdatesOnForObjectInstance 

// ===========================================================================
// 4. OWNERSHIP MANAGEMENT
// ===========================================================================

// ---------------------------------------------------------------------------
// 4.1 attributeIsNotOwned
// ---------------------------------------------------------------------------
void 
Fed::attributeIsNotOwned(ObjectHandle theObject, AttributeHandle theAttribute)
    throw (ObjectNotKnown, AttributeNotKnown, FederateInternalError)
{
}

// FIXME: 4.2 attributeOwnedByRTI

// ---------------------------------------------------------------------------
// 4.3 attributeOwnershipAcquisitionNotification
// ---------------------------------------------------------------------------
void 
Fed::attributeOwnershipAcquisitionNotification(ObjectHandle theObject,
                                               const AttributeHandleSet& securedAttributes)
    throw (ObjectNotKnown, AttributeNotKnown, 
           AttributeAcquisitionWasNotRequested, AttributeAlreadyOwned,
           AttributeNotPublished, FederateInternalError)
{
}

// ---------------------------------------------------------------------------
// 4.4 attributeOwnershipDivestitureNotification
// ---------------------------------------------------------------------------
void 
Fed::attributeOwnershipDivestitureNotification(ObjectHandle theObject, 
                                               const AttributeHandleSet& releasedAttributes) 
    throw (ObjectNotKnown, AttributeNotKnown, AttributeNotOwned,
           AttributeDivestitureWasNotRequested, FederateInternalError)
{
}

// ---------------------------------------------------------------------------
// 4.5 attributeOwnershipUnavailable
// ---------------------------------------------------------------------------
void 
Fed::attributeOwnershipUnavailable(ObjectHandle theObject, 
                                   const AttributeHandleSet& offeredAttributes)
    throw (ObjectNotKnown, AttributeNotDefined, AttributeAlreadyOwned,
           AttributeAcquisitionWasNotRequested, FederateInternalError)
{
} 

// ---------------------------------------------------------------------------
// 4.6 confirmAttributeOwnershipAcquisitionCancellation
// ---------------------------------------------------------------------------
void Fed::confirmAttributeOwnershipAcquisitionCancellation(
                                                           ObjectHandle theObject,
                                                           const AttributeHandleSet& theAttributes)
    throw (ObjectNotKnown, AttributeNotKnown, AttributeAlreadyOwned,
           AttributeAcquisitionWasNotCanceled, FederateInternalError)
{
}

// ---------------------------------------------------------------------------
// 4.7 informAttributeOwnership
// ---------------------------------------------------------------------------
void Fed::informAttributeOwnership(ObjectHandle theObject,
                                   AttributeHandle theAttribute,
                                   FederateHandle theOwner)
    throw (ObjectNotKnown, AttributeNotKnown, FederateInternalError)
{
}

// ---------------------------------------------------------------------------
// 4.8 requestAttributeOwnershipAssumption
// ---------------------------------------------------------------------------
void
Fed::requestAttributeOwnershipAssumption(ObjectHandle theObject,
                                         const AttributeHandleSet& offeredAttributes,
                                         const char *theTag)
    throw (ObjectNotKnown, AttributeNotKnown, AttributeAlreadyOwned, 
           AttributeNotPublished, FederateInternalError)
{
}

// ---------------------------------------------------------------------------
// 4.9 requestAttributeOwnershipRelease
// ---------------------------------------------------------------------------
void 
Fed::requestAttributeOwnershipRelease(ObjectHandle theObject,
                                      const AttributeHandleSet& candidateAttributes,
                                      const char *theTag) 
    throw (ObjectNotKnown, AttributeNotKnown, AttributeNotOwned, 
           FederateInternalError)
{
}

// ===========================================================================
// 5. TIME MANAGEMENT
// ===========================================================================

// FIXME: 5.1 requestRetraction

// ---------------------------------------------------------------------------
// 5.2 timeAdvanceGrant
// ---------------------------------------------------------------------------
void 
Fed::timeAdvanceGrant(const FedTime& theTime) 
    throw (InvalidFederationTime, TimeAdvanceWasNotInProgress, 
           FederationTimeAlreadyPassed, FederateInternalError) 
{
    granted = true ;
}

// FIXME: 5.3 timeConstrainedEnabled

// ---------------------------------------------------------------------------
// 5.4 timeRegulationEnabled
// ---------------------------------------------------------------------------
void 
Fed::timeRegulationEnabled(const FedTime& theTime) 
    throw(InvalidFederationTime, EnableTimeRegulationWasNotPending,
          FederateInternalError) 
{

}

// TEMPORAIRE

void
Fed::setTAG(bool granted_) {

    this->granted = granted_ ;
}

bool
Fed::getTAG(void) {

    return granted ;
}

void
Fed::setId(int i) {
    id = i ;
}

// ---------------------------------------------------------------------------
// setVerbose
//
void
Fed::setVerbose(bool v)
{
    verbose = v ;
}

// $Id: Fed.cc,v 1.4 2003/03/24 17:54:25 breholee Exp $


