#!/bin/sh
# myCERTI_env.sh.  Generated from myCERTI_env.sh.in by configure.

export CERTI_VERSION="3.2.4"
echo "CERTI version <$CERTI_VERSION>"

if [ $# -gt 0 ];
then
   export CERTI_HOST=$1
else
   export CERTI_HOST=localhost
fi

echo "Using CERTI_HOST=$CERTI_HOST"

ARCH=`arch`
if [ "$ARCH" = "i686" ];
then
  NBITS="32bits"
else
  NBITS="64bits"
fi

echo "Current machine architecture is <$ARCH> assumed to be $NBITS"

export CERTI_HOME=/udd/deri/enoulard/CERTI/Linux-i386
alias go_certi_home='pushd $CERTI_HOME'
echo "Using CERTI installation at <$CERTI_HOME>..."

export CERTI_FED=$CERTI_HOME/share/federations
alias go_certi_fed='pushd $CERTI_FED'

export PATH=$PATH:$CERTI_HOME/bin:$CERTI_HOME/scripts

export LD_LIBRARY_PATH=$CERTI_HOME/lib:$LD_LIBRARY_PATH


