# This file contains the Project specific variables.
#
# Extra parameters can be added to the following variables:
#
# CFLAGS, CXXFLAGS, INCLUDEFLAGS, SYSTEMINCLUDEFLAGS, LDFLAGS.
#
# Always use a += for these variables to *add* parameters rather
# than overriding them!

#
# CFLAGS / CXXFLAGS
#
# Project specific compiler flags.
#
# Use this when profiling:

##CFLAGS=-pg -O6 -pipe
##CXXFLAGS=-pg -O6 -pipe -fno-exceptions
##LDFLAGS=-pg

# Add extra, project specific, defines here, etc.

##CFLAGS+=-D__MYCLIB__
##CXXFLAGS+=-D__MYCXXLIB__

#
# INCLUDEFLAGS
#
# Project specific "include" flags.
#
# These directories are searched when you use an #include "foobar.h"
# in your source code.
#
# The given directories will be relative to the directory from which
# the compiler is started, which is the directory that the source
# file being compiled is in.  Therefore always use -I$(BASEDIR) as
# a prefix (BASEDIR is the directory this file is in).
#
# Note: If you want to add an include directory that is specific for
# only one executable or library, you might want to add this -I flag
# to the Makefile for that executable or library respectively instead.

INCLUDEFLAGS+=-I$(BASEDIR)/include

#
# SYSTEMINCLUDEFLAGS
#
# Project specific system <include> flags.
#
# These directories are searched when you use a #include <foobar.h>
# in your source code.
#
# Note: If you are writting a library, then you want to use
# #include <yourlib/foobar.h> in your headerfiles, because later on
# these header files are installed in /usr/local/include for instance.
# In that case you need to add -I$(BASEDIR)/include *here* instead
# to in INCLUDEFLAGS above.
#

##SYSTEMINCLUDEFLAGS+=-I/usr/local/obscurelib/include -I$(BASEDIR)/include

#
# LDFLAGS
#
# Project specific linker flags (Overridden flags: -s or -pg ...)
#
# These flags are passed to the compiler at link time, these flags
# are given a default value in $(PROTODIR)/Makedefs.h.  You can
# override them here.
#

##LDFLAGS=-s

#
# LIBFLAGS
#
# Project specific linker flags (Persistent flags: -L and -Wl,...)
#
# If you want to link your (test) executables with the latest version of
# your project library instead of the version that was actually installed
# in /usr/local (for example), then you need to add -L$(BASEDIR)/lib to
# LIBFLAGS.

LIBPATH=$(shell cd $(BASEDIR)/lib; pwd)
LIBFLAGS+=-L$(BASEDIR)/lib -Wl,-rpath -Wl,$(LIBPATH)

#
# DFLAGS
#
# Extra flags for generating dependencies.
# The default is -MM, only including "local" headers.
# Use this if you need dependencies on <system> headers,
# (for example when you are writing a library and are using <headers>
# with angle brackets yourself).

##DFLAGS=-M

#
# CPPEXT
#
# The C++ extension that is used in this project.  Correct this!

CPPEXT=.cc
